
#pragma once

#include <QString>

#include "pappsomspp/core/msrun/msrunid.h"


namespace pappso
{


class MsFileReader
{
  protected:
  QString m_fileName;
  Enums::MsDataFormat m_fileFormat = Enums::MsDataFormat::unknown;

  public:
  MsFileReader(const QString &file_name);
  virtual ~MsFileReader();

  virtual Enums::MsDataFormat getFileFormat() = 0;

  virtual std::vector<MsRunIdCstSPtr>
  getMsRunIds(const QString &run_prefix) = 0;
};

} // namespace pappso
