#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Daguhh
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# A Monster's Expedition
# send your bug reports to contact@dotslashplay.it
###

script_version=20241109.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='a-monsters-expedition'
GAME_NAME='A Monsterʼs Expedition'

ARCHIVE_BASE_0_NAME='a-monsters-expedition-linux.zip'
ARCHIVE_BASE_0_MD5='0bf9d7b9d7df996024716145d5fa0074'
ARCHIVE_BASE_0_SIZE='570000'
ARCHIVE_BASE_0_VERSION='1.0-itch'
ARCHIVE_BASE_0_URL='https://draknek.itch.io/a-monsters-expedition'

UNITY3D_NAME='a-monsters-expedition'

CONTENT_PATH_DEFAULT='.'
## FIXME: The Unity3D plugins to include should be listed through UNITY3D_PLUGINS
CONTENT_GAME0_BIN_FILES="
${UNITY3D_NAME}_Data/Plugins"

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
## TODO: The dependencies list should be completed
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libstdc++.so.6'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
