% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-beeswarm.R
\name{position_beeswarm}
\alias{position_beeswarm}
\title{Arrange points using the \verb{\link[beeswarm]} package.}
\usage{
position_beeswarm(
  method = "swarm",
  cex = 1,
  side = 0L,
  priority = "ascending",
  fast = TRUE,
  orientation = NULL,
  groupOnX = NULL,
  dodge.width = 0,
  corral = "none",
  corral.width = 0.2,
  preserve.data.axis = FALSE
)
}
\arguments{
\item{method}{Method for arranging points.
Options are \code{"swarm"} (default), \code{"compactswarm"}, \code{"square"}, \code{"hex"}, and \code{"center"}.
See Details below.}

\item{cex}{Scaling for adjusting point spacing (see \code{\link[beeswarm:swarmx]{beeswarm::swarmx()}}).
Values between 1 (default) and 3 tend to work best.}

\item{side}{Direction to perform jittering: 0: both directions;
1: to the right or upwards; -1: to the left or downwards.}

\item{priority}{Method used to perform point layout.
Options are \code{"ascending"} (default), \code{"descending"}, \code{"density"}, \code{"random"}, or \code{"none"}.
See Details below.}

\item{fast}{If \code{TRUE} (default), use compiled version of swarm algorithm.
This option is ignored for all methods except \code{"swarm"} and \code{"compactswarm"}.}

\item{orientation}{The orientation (i.e., which axis to group on) is inferred from the data.
This can be overridden by setting \code{orientation} to either \code{"x"} or \code{"y"}.}

\item{groupOnX}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}} See \code{orientation}.}

\item{dodge.width}{Amount by which points from different aesthetic groups
will be dodged. This requires that one of the aesthetics is a factor.}

\item{corral}{Method used to adjust points that would be placed too wide
horizontally. Options are \code{"none"} (default), \code{"gutter"}, \code{"wrap"}, \code{"random"}, and \code{"omit"}.
See Details below.}

\item{corral.width}{Width of the corral, if not \code{"none"}. Default is \code{0.9}.}

\item{preserve.data.axis}{If TRUE, prevent \code{method} from modifying the data axis (default FALSE). See Details for more info.}
}
\description{
Arrange points using the \verb{\link[beeswarm]} package.
}
\details{
\strong{method:} specifies the algorithm used to avoid overlapping points. The
default \code{"swarm"} method places points in increasing order. If a point would
overlap with an existing point, it is shifted sideways (along the group axis)
by a minimal amount sufficient to avoid overlap.

While the \code{"swarm"} method places points in a predetermined
order, the \code{"compactswarm"} method uses a greedy strategy to determine which
point will be placed next. This often leads to a more tightly-packed layout.
The strategy is very simple: on each iteration, a point that can be placed as
close as possible to the non-data axis is chosen and placed. If there are two
or more equally good points, \code{priority} is used to break ties.

The other 3 methods first discretise the values along the data axis, in order
to create more efficient packing. The \code{"square"} method places points on a
square grid, whereas \code{"hex"} uses a hexagonal grid. \code{"centre"}/\code{"center"}
uses a square grid to produce a symmetric swarm. The number of break points
for discretisation is determined by a combination of the available plotting
area and the \code{cex} argument.

\strong{priority:} controls the order in which points are placed, which generally
has a noticeable effect on the plot appearance. \code{"ascending"} gives the
'traditional' beeswarm plot. \code{"descending"} is the opposite. \code{"density"}
prioritizes points with higher local density. \code{"random"} places points in a
random order. \code{"none"} places points in the order provided.

\strong{corral:} By default, swarms from different groups are not prevented from
overlapping, i.e. \verb{"corral = "none"}. Thus, datasets that are very large or
unevenly distributed may produce ugly overlapping beeswarms. To control
runaway points one can use the following methods. \code{"gutter"} collects runaway
points along the boundary between groups. \code{"wrap"} implement periodic boundaries.
\code{"random"} places runaway points randomly in the region. \code{"omit"} omits runaway
points.

#' \strong{preserve.data.axis:} In some cases, the underlying method may
attempt to change the position of points along the ungrouped, or data, axis,
in order to keep them from overlapping. To prevent this, set this
option to TRUE.
}
\seealso{
\code{\link[=geom_beeswarm]{geom_beeswarm()}}, \code{\link[=position_quasirandom]{position_quasirandom()}},
\code{\link[beeswarm:swarmx]{beeswarm::swarmx()}}

Other position adjustments: 
\code{\link{offset_beeswarm}()},
\code{\link{position_quasirandom}()}
}
\concept{position adjustments}
