/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class FunctionList
extends TransformedList {
    private final List sourceElements;
    private final List mappedElements;
    private final AdvancedFunction forward;
    private final Function reverse;

    public FunctionList(EventList source, Function forward) {
        this(source, forward, null);
    }

    public FunctionList(EventList source, Function forward, Function reverse) {
        super(source);
        if (forward == null) {
            throw new IllegalArgumentException("forward Function may not be null");
        }
        this.forward = forward instanceof AdvancedFunction ? (AdvancedFunction)forward : new AdvancedFunctionAdapter(forward);
        this.reverse = reverse;
        this.sourceElements = new ArrayList(source);
        this.mappedElements = new ArrayList(source.size());
        Iterator iter = source.iterator();
        while (iter.hasNext()) {
            this.mappedElements.add(this.forward(iter.next()));
        }
        source.addListEventListener(this);
    }

    private Object forward(Object s) {
        return this.forward.evaluate(s);
    }

    private Object forward(Object e, Object s) {
        return this.forward.reevaluate(s, e);
    }

    private Object reverse(Object e) {
        if (this.reverse == null) {
            throw new IllegalStateException("A reverse mapping function must be specified to support this List operation");
        }
        return this.reverse.evaluate(e);
    }

    public Function getForwardFunction() {
        if (this.forward instanceof AdvancedFunctionAdapter) {
            return ((AdvancedFunctionAdapter)this.forward).getDelegate();
        }
        return this.forward;
    }

    public Function getReverseFunction() {
        return this.reverse;
    }

    protected boolean isWritable() {
        return true;
    }

    public void listChanged(ListEvent listChanges) {
        while (listChanges.next()) {
            int changeIndex = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType == 2) {
                Object inserted = this.source.get(changeIndex);
                this.sourceElements.add(changeIndex, inserted);
                this.mappedElements.add(changeIndex, this.forward(inserted));
                continue;
            }
            if (changeType == 1) {
                Object updated = this.source.get(changeIndex);
                this.sourceElements.set(changeIndex, updated);
                this.mappedElements.set(changeIndex, this.forward(this.get(changeIndex), updated));
                continue;
            }
            if (changeType != 0) continue;
            Object deletedSource = this.sourceElements.remove(changeIndex);
            Object deletedTransform = this.mappedElements.remove(changeIndex);
            this.forward.dispose(deletedSource, deletedTransform);
        }
        listChanges.reset();
        this.updates.forwardEvent(listChanges);
    }

    public Object get(int index) {
        return this.mappedElements.get(index);
    }

    public Object remove(int index) {
        Object removed = this.get(index);
        this.source.remove(index);
        return removed;
    }

    public Object set(int index, Object value) {
        Object updated = this.get(index);
        this.source.set(index, this.reverse(value));
        return updated;
    }

    public void add(int index, Object value) {
        this.source.add(index, this.reverse(value));
    }

    private static final class AdvancedFunctionAdapter
    implements AdvancedFunction {
        private final Function delegate;

        public AdvancedFunctionAdapter(Function delegate) {
            this.delegate = delegate;
        }

        public Object evaluate(Object sourceValue) {
            return this.delegate.evaluate(sourceValue);
        }

        public Object reevaluate(Object sourceValue, Object transformedValue) {
            return this.evaluate(sourceValue);
        }

        public void dispose(Object sourceValue, Object transformedValue) {
        }

        public Function getDelegate() {
            return this.delegate;
        }
    }

    public static interface AdvancedFunction
    extends Function {
        public Object reevaluate(Object var1, Object var2);

        public void dispose(Object var1, Object var2);
    }

    public static interface Function {
        public Object evaluate(Object var1);
    }
}

