/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.RangeList;
import ca.odell.glazedlists.SortedList;
import java.util.Comparator;

public final class ThresholdList
extends RangeList {
    private int lowerThreshold = Integer.MIN_VALUE;
    private int upperThreshold = Integer.MAX_VALUE;
    private Evaluator evaluator = null;
    private final SortedList sortedSource;

    public ThresholdList(EventList source, String propertyName) {
        this(source, GlazedLists.thresholdEvaluator(propertyName));
    }

    public ThresholdList(EventList source, Evaluator evaluator) {
        this(new SortedList(source, new ThresholdComparator(evaluator)), evaluator);
    }

    private ThresholdList(SortedList sortedSource, Evaluator evaluator) {
        super(sortedSource);
        this.sortedSource = sortedSource;
        this.evaluator = evaluator;
    }

    public void setLowerThreshold(Object object) {
        this.setLowerThreshold(this.evaluator.evaluate(object));
    }

    public void setLowerThreshold(int lowerThreshold) {
        this.lowerThreshold = lowerThreshold;
        this.adjustRange();
    }

    public int getLowerThreshold() {
        return this.lowerThreshold;
    }

    public void setUpperThreshold(Object object) {
        this.setUpperThreshold(this.evaluator.evaluate(object));
    }

    public void setUpperThreshold(int upperThreshold) {
        this.upperThreshold = upperThreshold;
        this.adjustRange();
    }

    public int getUpperThreshold() {
        return this.upperThreshold;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public boolean contains(Object object) {
        if (!this.withinRange(object)) {
            return false;
        }
        return this.source.contains(object);
    }

    public int indexOf(Object object) {
        if (!this.withinRange(object)) {
            return -1;
        }
        return this.source.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        if (!this.withinRange(object)) {
            return -1;
        }
        return this.source.lastIndexOf(object);
    }

    private boolean withinRange(Object object) {
        int objectEvaluation = this.evaluator.evaluate(object);
        return objectEvaluation >= this.lowerThreshold && objectEvaluation <= this.upperThreshold;
    }

    public void setRange(int startIndex, int endIndex) {
        this.lowerThreshold = this.sourceIndexToThreshold(startIndex);
        this.upperThreshold = this.sourceIndexToThreshold(endIndex);
        this.adjustRange();
    }

    public void setTailRange(int startIndex, int endIndex) {
        this.lowerThreshold = this.sourceIndexToThreshold(this.source.size() - startIndex);
        this.upperThreshold = this.sourceIndexToThreshold(this.source.size() - endIndex);
        this.adjustRange();
    }

    private int sourceIndexToThreshold(int sourceIndex) {
        if (sourceIndex < 0) {
            return Integer.MIN_VALUE;
        }
        if (sourceIndex < this.source.size()) {
            return this.evaluator.evaluate(this.source.get(sourceIndex));
        }
        return Integer.MIN_VALUE;
    }

    public int getStartIndex() {
        return this.sortedSource.sortIndex(new Integer(this.lowerThreshold));
    }

    public int getEndIndex() {
        int index = this.sortedSource.lastSortIndex(new Integer(this.upperThreshold));
        if (index < this.sortedSource.size() && this.evaluator.evaluate(this.sortedSource.get(index)) == this.upperThreshold) {
            ++index;
        }
        return index;
    }

    public void dispose() {
        this.sortedSource.dispose();
        super.dispose();
    }

    private static final class ThresholdComparator
    implements Comparator {
        private Evaluator evaluator = null;

        ThresholdComparator(Evaluator evaluator) {
            this.evaluator = evaluator;
        }

        public int compare(Object alpha, Object beta) {
            int betaValue;
            int alphaValue = alpha instanceof Integer ? ((Integer)alpha).intValue() : this.evaluator.evaluate(alpha);
            if (alphaValue > (betaValue = beta instanceof Integer ? ((Integer)beta).intValue() : this.evaluator.evaluate(beta))) {
                return 1;
            }
            if (alphaValue < betaValue) {
                return -1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ThresholdComparator)) {
                return false;
            }
            ThresholdComparator other = (ThresholdComparator)object;
            return this.evaluator == other.evaluator;
        }
    }

    public static interface Evaluator {
        public int evaluate(Object var1);
    }
}

