/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ConceptData.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:53:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import com.sun.xmlsearch.xml.ContextTables;

class ConceptData {
    protected final byte    _queryNo;
    protected final byte    _nColumns;
    protected final byte    _role;
    protected final int    _concept;
    protected final int    _proximity;
    protected final double _penalty;
    protected final ContextTables _ctx;
    protected ConceptData _next;
  
    protected static final int ProxPerTerm = 10;

    protected ConceptData() {
	// !!! inelegant hack for now
	_queryNo = 0;
	_nColumns = 0;
	_concept = 0;
	_proximity = 0;
	_role = 0;
	_penalty = 0;
	_ctx = null;
	_next = null;
    }
  
    public ConceptData(int id, int role, double score, int queryNo, int nColumns,
		       ContextTables contextTables) {
	_queryNo = (byte)queryNo;
	_nColumns = (byte)nColumns;
	_concept = id;
	_proximity = nColumns * ProxPerTerm;
	_role = (byte)role;
	_penalty = score;
	_ctx = contextTables;
	_next = null;
    }
  
    public final int getConcept() {
	return _concept;
    }
  
    public final double getPenalty() {
	return _penalty;
    }
  
    public final byte getRole() {
	return _role;
    }

    public final byte getQuery() {
	return _queryNo;
    }

    public final byte getNColumns() {
	return _nColumns;
    }

    public final double getScore() {
	return _penalty;
    }
  
    public final ConceptData getNext() {
	return _next;
    }
  
    public final int getQueryMask() {
	return (_next != null ? _next.getQueryMask() : 0) | (1 << _queryNo);
    }

    public final void setNext(ConceptData next) {
	_next = next;
    }
  
    public final boolean cEquals(ConceptData other) {
	return _concept == other._concept;
    }

    public final boolean crEquals(ConceptData other) {
	return _concept == other._concept && _role == other._role;
    }
  
    public final boolean crqEquals(ConceptData other) {
	return _concept == other._concept && _role == other._role &&
	    _queryNo == other._queryNo;
    }
  
    public final void addLast(ConceptData other) {
	if (_next != null) {
	    _next.addLast(other);
	}
	else {
	    _next = other;
	}
    }

    public final boolean compareWith(ConceptData other) {
	return _concept < other._concept
	    || cEquals(other)  && _role < other._role
	    || crEquals(other) && _penalty < other._penalty;
    }

    public final void runBy(Query[] queries) {
	ConceptData cd = this;
	do {
	    queries[cd._queryNo].updateEstimate(cd._role, cd._penalty);
	}
	while ((cd = cd._next) != null);
    }

    public void generateFillers(final RoleFiller[] array, final int pos) {
	if (array[_queryNo] != RoleFiller.STOP) // not 'prohibited'
	    (new RoleFiller(_nColumns,
			    this,
			    _role,
			    pos,
			    _ctx.wordContextLin(pos),
			    pos + _proximity)).use(array, _queryNo);
	// !!! maybe eliminate tail recursion
	if (_next != null) {
	    _next.generateFillers(array, pos);
	}
    }
}
