/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: setnodeaccess.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:19:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "setnodeaccess.hxx"

#ifndef CONFIGMGR_TREEACCESSOR_HXX
#include "treeaccessor.hxx"
#endif
#ifndef CONFIGMGR_UPDATEACCESSOR_HXX
#include "updateaccessor.hxx"
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

// -----------------------------------------------------------------------------	

namespace configmgr
{
// -----------------------------------------------------------------------------	
    namespace data
    {
    // -------------------------------------------------------------------------
        using memory::Pointer;
    // -------------------------------------------------------------------------
    // -------------------------------------------------------------------------
        Pointer SetNodeAccess::check(Accessor const& _aAccessor, sharable::SetNode const* pInnerNode)
        {
            return _aAccessor.address(pInnerNode);      
        }
    // -------------------------------------------------------------------------

        Pointer SetNodeAccess::check(NodeAccessRef const& _aNode)
        {
            if (sharable::Node const* pNode = _aNode.getDataPtr())
                return check(_aNode.accessor(),pNode->setData());

            else
                return Pointer();
        }
    // -------------------------------------------------------------------------
    
        TreeAddress SetNodeAccess::implGetElement(Name const& _aName) const
        {
            using namespace sharable;
            SetNode const  & aNode = data();
            for (TreeFragment const * pElement = aNode.getFirstElement(m_aAccessor);
                       pElement  != NULL;
                       pElement  = aNode.getNextElement(m_aAccessor, pElement))
            {
                if (pElement->isNamed(_aName.toString(), m_aAccessor))
                {
                    TreeAccessor aElementTree(m_aAccessor,pElement);
                    return aElementTree.address();
                }            
            }
            return TreeAddress();
        }
    // -------------------------------------------------------------------------*/
        
        void SetNodeAccess::addElement(memory::UpdateAccessor & _aAccessor, SetNodeAddress _aSetAddress, ElementAddress _aNewElement)
        {
            using namespace sharable;

            SetNode * pNode = static_cast<SetNode *>( _aAccessor.access( _aSetAddress.m_pData) );
            OSL_ENSURE(pNode, "ERROR: Trying to add an element to a NULL set node");

            // To do (?): insert sorted - find location here
            TreeFragment * pElement = TreeAccessor::access(_aNewElement, _aAccessor);
            OSL_ENSURE(pElement, "ERROR: Trying to add a NULL element to a set node");

            pElement->header.next   = pNode->elements;
            pElement->header.parent = _aSetAddress.m_pData.value();

            pNode->elements = _aNewElement.addressValue();
        }
    // -------------------------------------------------------------------------*/
        
        TreeAddress SetNodeAccess::removeElement(memory::UpdateAccessor & _aAccessor, SetNodeAddress _aSetAddress, Name const & _aName)
        {
            using namespace sharable;
            using memory::Pointer;
            
            memory::Accessor _aReadAccessor = _aAccessor.accessor();

            SetNode * pNode = static_cast<SetNode *>( _aAccessor.access( _aSetAddress.m_pData) );
            OSL_ENSURE(pNode, "ERROR: Trying to add an element to a NULL set node");

            TreeAddress aRemoved;
            
            List * pLink = & pNode->elements;
            while( TreeFragment * pElement = static_cast<TreeFragment *>(_aAccessor.access(Pointer(*pLink))) )
            {
                if (pElement->isNamed(_aName.toString(), _aReadAccessor))
                {
                    aRemoved = TreeAddress( Pointer(*pLink) );
                   // aRemoved = TreeAccessor(_aReadAccessor,pElement).address();

                    *pLink = pElement->header.next;
                    pElement->header.next   = 0;
                    pElement->header.parent = 0;

                    break;
                }

                pLink = & pElement->header.next;
            }

            return aRemoved;
        }
    // -------------------------------------------------------------------------*/

    // -------------------------------------------------------------------------
    // -------------------------------------------------------------------------
        
        bool SetNodeAccess::hasElement(Name const& _aName) const 
        { 
            return SetNodeAccess::implGetElement(_aName).is(); 
        }
    // -------------------------------------------------------------------------

        TreeAccessor SetNodeAccess::getElementTree(Name const& _aName) const
        { 
            return TreeAccessor(m_aAccessor, implGetElement(_aName)); 
        }
    // -------------------------------------------------------------------------
    }
// -----------------------------------------------------------------------------	
} // namespace configmgr


