/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: singledoccontroller.hxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: hr $ $Date: 2005/09/23 12:35:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef DBAUI_SINGLEDOCCONTROLLER_HXX
#define DBAUI_SINGLEDOCCONTROLLER_HXX

#ifndef DBAUI_GENERICCONTROLLER_HXX
#include "genericcontroller.hxx"
#endif
#ifndef _COMPHELPER_PROPERTYCONTAINER_HXX_ 
#include <comphelper/propertycontainer.hxx>
#endif
#ifndef _COMPHELPER_PROPERTY_ARRAY_HELPER_HXX_ 
#include <comphelper/proparrhlp.hxx>
#endif
#ifndef _COMPHELPER_BROADCASTHELPER_HXX_
#include <comphelper/broadcasthelper.hxx>
#endif
#ifndef _COM_SUN_STAR_SDBC_XCONNECTION_HPP_
#include <com/sun/star/sdbc/XConnection.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XDATASOURCE_HPP_
#include <com/sun/star/sdbc/XDataSource.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XDATABASEMETADATA_HPP_ 
#include <com/sun/star/sdbc/XDatabaseMetaData.hpp>
#endif
#ifndef DBAUI_IENVIRONMENT_HXX
#include "IEnvironment.hxx"
#endif
#ifndef DBACCESS_SOURCE_UI_INC_DOCUMENTCONTROLLER_HXX
#include "documentcontroller.hxx"
#endif
#ifndef _UNDO_HXX
#include <svtools/undo.hxx>
#endif

#include <memory>

//........................................................................
namespace dbaui
{
//........................................................................

	//====================================================================
	//= OSingleDocumentController
	//====================================================================
	class OSingleDocumentController;
	typedef OGenericUnoController					OSingleDocumentController_CBASE;
	typedef ::comphelper::OPropertyContainer		OSingleDocumentController_PBASE;
	typedef ::comphelper::OPropertyArrayUsageHelper	<	OSingleDocumentController
													>	OSingleDocumentController_PABASE;

	class OSingleDocumentController
			:public OSingleDocumentController_CBASE
			,public OSingleDocumentController_PBASE
			,public OSingleDocumentController_PABASE
			,public IEnvironment
	{
		friend class OConnectionChangeBroadcaster;
	private:
		::com::sun::star::uno::Any m_aCurrentError; // contains the current error which can be set through IEnvironment
		// <properties>
		::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >
						m_xConnection;
		// </properties>
		::rtl::OUString	m_sDataSourceName;		// the data source we're working for
		::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >
						m_xDataSource;
        ModelControllerConnector
                        m_aModelConnector;
		sal_Bool		m_bOwnConnection : 1;	// is true when we created our own connection
		sal_Bool		m_bSuspended	 : 1;	// is true when the controller was already suspended
		sal_Bool		m_bEditable		 : 1;	// is the control readonly or not
		sal_Bool		m_bModified		 : 1;	// is the data modified

	protected:
		SfxUndoManager	m_aUndoManager;

	protected:
		// ----------------------------------------------------------------
		// initalizing members
		/** forces usage of a connection which we do not own
			<p>To be used from within XInitialization::initialize only.</p>
		*/
		void		initializeConnection( const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _rxForeignConn );

		// state of a feature. 'feature' may be the handle of a ::com::sun::star::util::URL somebody requested a dispatch interface for OR a toolbar slot.
		virtual FeatureState	GetState(sal_uInt16 nId) const;
		// execute a feature
		virtual void			Execute(sal_uInt16 nId, const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue>& aArgs);

	public:

		inline sal_Bool		isReadOnly()			const { return !m_bEditable; }
		inline sal_Bool		isEditable()			const { return m_bEditable; }
		inline sal_Bool		isModified()			const { return m_bModified; }

		virtual void setModified(sal_Bool _bModified=sal_True);
		inline void setEditable(sal_Bool _bEditable)	  { m_bEditable = _bEditable; }

		// need for undo's and redo's
		SfxUndoManager* getUndoMgr();

		/** addUndoActionAndInvalidate adds an undo action to the undoManager,
			additionally invalidates the UNDO and REDO slot
			@param	pAction	the undo action to add
		*/
		void addUndoActionAndInvalidate(SfxUndoAction *pAction);
		// ----------------------------------------------------------------
		// asking for connection-related stuff
		
		inline sal_Bool	isConnected() const { return m_xConnection.is(); }

		::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDatabaseMetaData >
					getMetaData( ) const { return isConnected() ? m_xConnection->getMetaData() : ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XDatabaseMetaData >(); }
		// ----------------------------------------------------------------
		// access to the data source
		::rtl::OUString getDataSourceName() const;
		inline const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet >&
					getDataSource() const { return m_xDataSource; }
		inline sal_Bool	haveDataSource() const { return m_xDataSource.is(); }

		// IEnvironment
		/** appends an error in the current environment.
			@param	_aException
				contains a description of the error or the error directly
		*/
		virtual void appendError(const ::com::sun::star::sdbc::SQLException& _aException);

		/** clears the error state.
		*/
		virtual void clearError();

		/** set the current error in the given parameter.
			@param	_rException
				will contain the current error
		*/
		virtual void getError(::com::sun::star::sdbc::SQLException& _rException ) const;

		/** @retrun
			returns <TRUE/> when an error was set otherwise <FALSE/>
		*/
		virtual sal_Bool hasError() const;

		/** gives access to the currently used connection
			@return
				the currently used connection.
		*/
		inline virtual const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >&
					getConnection() const { return m_xConnection; }

		// ::com::sun::star::frame::XController
		virtual sal_Bool SAL_CALL suspend(sal_Bool bSuspend) throw( ::com::sun::star::uno::RuntimeException );
		virtual sal_Bool SAL_CALL attachModel(const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XModel > & xModel) throw( ::com::sun::star::uno::RuntimeException );
		virtual ::com::sun::star::uno::Reference< ::com::sun::star::frame::XModel >  SAL_CALL getModel(void) throw( ::com::sun::star::uno::RuntimeException );

	protected:
		OSingleDocumentController(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB);

		virtual void		disconnect();
		virtual void		reconnect( sal_Bool _bUI );
				sal_Bool	ensureConnected( sal_Bool _bUI )	{ if ( !isConnected() ) reconnect( _bUI ); return isConnected(); }

		/** called when our connection is beeing disposed
			<p>The default implementation does a reconnect</p>
		*/
		virtual void losingConnection( );

		// late construction
		virtual sal_Bool Construct(Window* pParent);

	protected:
		// XInterface
		virtual ::com::sun::star::uno::Any SAL_CALL queryInterface( const ::com::sun::star::uno::Type& aType ) throw (::com::sun::star::uno::RuntimeException);
		virtual void SAL_CALL acquire(  ) throw ();
		virtual void SAL_CALL release(  ) throw ();

		// XTypeProvider
		virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > SAL_CALL getTypes(  ) throw (::com::sun::star::uno::RuntimeException);
		virtual ::com::sun::star::uno::Sequence<sal_Int8> SAL_CALL getImplementationId(  ) throw(::com::sun::star::uno::RuntimeException);

		// OPropertyArrayUsageHelper
		virtual ::cppu::IPropertyArrayHelper* createArrayHelper( ) const;

		// XPropertySet
		virtual com::sun::star::uno::Reference<com::sun::star::beans::XPropertySetInfo>  SAL_CALL getPropertySetInfo() throw(com::sun::star::uno::RuntimeException);
		virtual ::cppu::IPropertyArrayHelper& SAL_CALL getInfoHelper();

		// XEventListener
		virtual void SAL_CALL disposing(const ::com::sun::star::lang::EventObject& Source) throw( ::com::sun::star::uno::RuntimeException );

		// OComponentHelper
		virtual void SAL_CALL disposing();
	};

//........................................................................
}	// namespace dbaui
//........................................................................

#endif // DBAUI_SINGLEDOCCONTROLLER_HXX

