/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: argumentanalyzer.hxx,v $
 *
 *  $Revision: 1.28 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:02:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef __FRAMEWORK_CLASSES_ARGUMENTANALYZER_HXX_
#define __FRAMEWORK_CLASSES_ARGUMENTANALYZER_HXX_

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_MACROS_DEBUG_HXX_
#include <macros/debug.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_GENERIC_HXX_
#include <macros/generic.hxx>
#endif

#ifndef __FRAMEWORK_ARGUMENTS_H_
#include <arguments.h>
#endif

#ifndef __FRAMEWORK_FILTERFLAGS_H_
#include <filterflags.h>
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif

#ifndef _COM_SUN_STAR_AWT_RECTANGLE_HPP_
#include <com/sun/star/awt/Rectangle.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_URL_HPP_
#include <com/sun/star/util/URL.hpp>
#endif

#ifndef _COM_SUN_STAR_TASK_XSTATUSINDICATOR_HPP_
#include <com/sun/star/task/XStatusIndicator.hpp>
#endif

#ifndef _COM_SUN_STAR_TASK_XINTERACTIONHANDLER_HPP_
#include <com/sun/star/task/XInteractionHandler.hpp>
#endif

#ifdef ENABLE_COMPONENT_SELF_CHECK
    #ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
    #include <com/sun/star/lang/XMultiServiceFactory.hpp>
    #endif
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _RTL_USTRING_
#include <rtl/ustring.hxx>
#endif

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

//_________________________________________________________________________________________________________________
//	const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

/*-************************************************************************************************************//**
	@short			Structure to hold internal variables and safe his valid-state.
*//*-*************************************************************************************************************/

#define ARGUMENT_NOT_EXIST  -1

struct ArgumentReferences
{
    public:
        inline  ArgumentReferences() { forgetIt(); }
        inline ~ArgumentReferences() { forgetIt(); }

        inline sal_Int32* getLastReference()
        {
            sal_Int32* pRef = NULL;
            sal_Int32  nMax = -1  ;

            if( psCharacterSet       > nMax ) { nMax = psCharacterSet       ; pRef = &psCharacterSet       ; }
            if( psMediaType          > nMax ) { nMax = psMediaType          ; pRef = &psMediaType          ; }
            if( psDetectService      > nMax ) { nMax = psDetectService      ; pRef = &psDetectService      ; }
            if( psExtension          > nMax ) { nMax = psExtension          ; pRef = &psExtension          ; }
            if( psURL                > nMax ) { nMax = psURL                ; pRef = &psURL                ; }
            if( psFilterName         > nMax ) { nMax = psFilterName         ; pRef = &psFilterName         ; }
            if( psFormat             > nMax ) { nMax = psFormat             ; pRef = &psFormat             ; }
            if( psFrameName          > nMax ) { nMax = psFrameName          ; pRef = &psFrameName          ; }
            if( psPattern            > nMax ) { nMax = psPattern            ; pRef = &psPattern            ; }
            if( pxPostData           > nMax ) { nMax = pxPostData           ; pRef = &pxPostData           ; }
            if( psPostString         > nMax ) { nMax = psPostString         ; pRef = &psPostString         ; }
            if( psReferrer           > nMax ) { nMax = psReferrer           ; pRef = &psReferrer           ; }
            if( psTemplateName       > nMax ) { nMax = psTemplateName       ; pRef = &psTemplateName       ; }
            if( psTemplateRegionName > nMax ) { nMax = psTemplateRegionName ; pRef = &psTemplateRegionName ; }
            if( psJumpMark           > nMax ) { nMax = psJumpMark           ; pRef = &psJumpMark           ; }
            if( psTypeName           > nMax ) { nMax = psTypeName           ; pRef = &psTypeName           ; }
            if( pnVersion            > nMax ) { nMax = pnVersion            ; pRef = &pnVersion            ; }
            if( pnViewId             > nMax ) { nMax = pnViewId             ; pRef = &pnViewId             ; }
            if( pnFilterOptions      > nMax ) { nMax = pnFilterOptions      ; pRef = &pnFilterOptions      ; }
            if( pbAsTemplate         > nMax ) { nMax = pbAsTemplate         ; pRef = &pbAsTemplate         ; }
            if( pbHidden             > nMax ) { nMax = pbHidden             ; pRef = &pbHidden             ; }
            if( pbOpenNewView        > nMax ) { nMax = pbOpenNewView        ; pRef = &pbOpenNewView        ; }
            if( pbReadOnly           > nMax ) { nMax = pbReadOnly           ; pRef = &pbReadOnly           ; }
            if( pbPreview            > nMax ) { nMax = pbPreview            ; pRef = &pbPreview            ; }
            if( pbSilent             > nMax ) { nMax = pbSilent             ; pRef = &pbSilent             ; }
            if( pbMinimized          > nMax ) { nMax = pbMinimized          ; pRef = &pbMinimized          ; }
            if( pbDeepDetection      > nMax ) { nMax = pbDeepDetection      ; pRef = &pbDeepDetection      ; }
            if( paPosSize            > nMax ) { nMax = paPosSize            ; pRef = &paPosSize            ; }
            if( pxInputStream        > nMax ) { nMax = pxInputStream        ; pRef = &pxInputStream        ; }
            if( pxOutputStream       > nMax ) { nMax = pxOutputStream       ; pRef = &pxOutputStream       ; }
            if( pxStatusIndicator    > nMax ) { nMax = pxStatusIndicator    ; pRef = &pxStatusIndicator    ; }
            if( pxInteractionHandler > nMax ) { nMax = pxInteractionHandler ; pRef = &pxInteractionHandler ; }
            if( pnMacroExecutionMode > nMax ) { nMax = pnMacroExecutionMode ; pRef = &pnMacroExecutionMode ; }
            if( pnUpdateDocMode		 > nMax ) { nMax = pnUpdateDocMode 		; pRef = &pnUpdateDocMode      ; }
            if( pbRepairPackage      > nMax ) { nMax = pbRepairPackage      ; pRef = &pbRepairPackage      ; }
            if( psDocumentTitle      > nMax ) { nMax = psDocumentTitle      ; pRef = &psDocumentTitle      ; }

            return pRef;
        }

        inline void forgetIt()
        {
            psCharacterSet       = ARGUMENT_NOT_EXIST;
            psMediaType          = ARGUMENT_NOT_EXIST;
            psDetectService      = ARGUMENT_NOT_EXIST;
            psExtension          = ARGUMENT_NOT_EXIST;
            psURL                = ARGUMENT_NOT_EXIST;
            psFilterName         = ARGUMENT_NOT_EXIST;
            psFormat             = ARGUMENT_NOT_EXIST;
            psFrameName          = ARGUMENT_NOT_EXIST;
            psPattern            = ARGUMENT_NOT_EXIST;
            pxPostData           = ARGUMENT_NOT_EXIST;
            psPostString         = ARGUMENT_NOT_EXIST;
            psReferrer           = ARGUMENT_NOT_EXIST;
            psTemplateName       = ARGUMENT_NOT_EXIST;
            psTemplateRegionName = ARGUMENT_NOT_EXIST;
            psJumpMark           = ARGUMENT_NOT_EXIST;
            psTypeName           = ARGUMENT_NOT_EXIST;
            pnVersion            = ARGUMENT_NOT_EXIST;
            pnViewId             = ARGUMENT_NOT_EXIST;
            pnFilterOptions      = ARGUMENT_NOT_EXIST;
            pbAsTemplate         = ARGUMENT_NOT_EXIST;
            pbHidden             = ARGUMENT_NOT_EXIST;
            pbOpenNewView        = ARGUMENT_NOT_EXIST;
            pbReadOnly           = ARGUMENT_NOT_EXIST;
            pbPreview            = ARGUMENT_NOT_EXIST;
            pbSilent             = ARGUMENT_NOT_EXIST;
            pbMinimized          = ARGUMENT_NOT_EXIST;
            pbDeepDetection      = ARGUMENT_NOT_EXIST;
            paPosSize            = ARGUMENT_NOT_EXIST;
            pxInputStream        = ARGUMENT_NOT_EXIST;
            pxOutputStream       = ARGUMENT_NOT_EXIST;
            pxStatusIndicator    = ARGUMENT_NOT_EXIST;
            pxInteractionHandler = ARGUMENT_NOT_EXIST;
            pnMacroExecutionMode = ARGUMENT_NOT_EXIST;
            pnUpdateDocMode      = ARGUMENT_NOT_EXIST;
            pbRepairPackage      = ARGUMENT_NOT_EXIST;
            psDocumentTitle      = ARGUMENT_NOT_EXIST;
        }

    public:
        sal_Int32    psCharacterSet           ;
        sal_Int32    psMediaType              ;
        sal_Int32    psDetectService          ;
        sal_Int32    psExtension              ;
        sal_Int32    psURL                    ;
        sal_Int32    psFilterName             ;
        sal_Int32    psFormat                 ;
        sal_Int32    psFrameName              ;
        sal_Int32    psPattern                ;
        sal_Int32    pxPostData               ;
        sal_Int32    psPostString             ;
        sal_Int32    psReferrer               ;
        sal_Int32    psTemplateName           ;
        sal_Int32    psTemplateRegionName     ;
        sal_Int32    psJumpMark               ;
        sal_Int32    psTypeName               ;
        sal_Int32    pnVersion                ;
        sal_Int32    pnViewId                 ;
        sal_Int32    pnFilterOptions          ;
        sal_Int32    pbAsTemplate             ;
        sal_Int32    pbHidden                 ;
        sal_Int32    pbOpenNewView            ;
        sal_Int32    pbReadOnly               ;
        sal_Int32    pbPreview                ;
        sal_Int32    pbSilent                 ;
        sal_Int32    pbMinimized              ;
        sal_Int32    pbDeepDetection          ;
        sal_Int32    paPosSize                ;
        sal_Int32    pxInputStream            ;
        sal_Int32    pxOutputStream           ;
        sal_Int32    pxStatusIndicator        ;
        sal_Int32    pxInteractionHandler     ;
        sal_Int32    pnMacroExecutionMode     ;
        sal_Int32    pnUpdateDocMode	      ;
        sal_Int32    pbRepairPackage          ;
        sal_Int32    psDocumentTitle          ;
};

/*-************************************************************************************************************//**
	@short			helper class to analyze/set/get sequences of PropertyValues
	@descr			For all framework dispatches we need a argument list as sequence of property values.
					But it's to expensive to parse given list, analyze it, set or get values at every position of using.
					That's the reason of this class.

	@implements		-
	@base			-

	@devstatus		ready to use
    @threadsafe     no
*//*-*************************************************************************************************************/
class ArgumentAnalyzer
{
	//-------------------------------------------------------------------------------------------------------------
	//	public methods
	//-------------------------------------------------------------------------------------------------------------
	public:

		//---------------------------------------------------------------------------------------------------------
		//	constructor / destructor
		//---------------------------------------------------------------------------------------------------------
               ArgumentAnalyzer(                                                                               );
               ArgumentAnalyzer( const css::uno::Sequence< css::beans::PropertyValue >& rArguments             ,
                                       sal_Bool                                         bReadOnly  = sal_False );
              ~ArgumentAnalyzer(                                                                               );

		//---------------------------------------------------------------------------------------------------------
		//	interface
		//---------------------------------------------------------------------------------------------------------
        virtual void setArguments( const css::uno::Sequence< css::beans::PropertyValue >& rArguments             ,
                                         sal_Bool                                         bReadOnly  = sal_False );

        virtual const css::uno::Sequence< css::beans::PropertyValue >& getArgumentsConst   () const;
        virtual       css::uno::Sequence< css::beans::PropertyValue >  getArgumentsAndReset();

        virtual void     deleteArgument(       EArgument       eArgument );
        virtual void     deleteAll     (                                 );
        virtual sal_Bool existArgument (       EArgument       eArgument ) const;
        virtual sal_Bool isStillRequest(                                 ) const;
        virtual sal_Bool isValid       (                                 ) const;

        sal_Bool getArgument   ( EArgument eArgument, ::rtl::OUString&                                              sValue );
        sal_Bool getArgument   ( EArgument eArgument, sal_Int16&                                                    nValue );
        sal_Bool getArgument   ( EArgument eArgument, sal_Int32&                                                    nValue );
        sal_Bool getArgument   ( EArgument eArgument, sal_Bool&                                                     bValue );
        sal_Bool getArgument   ( EArgument eArgument, css::awt::Rectangle&                                          aValue );
        sal_Bool getArgument   ( EArgument eArgument, css::uno::Reference< css::io::XInputStream >&                 xValue );
        sal_Bool getArgument   ( EArgument eArgument, css::uno::Reference< css::io::XOutputStream >&                xValue );
        sal_Bool getArgument   ( EArgument eArgument, css::uno::Reference< css::task::XStatusIndicator >&           xValue );
        sal_Bool getArgument   ( EArgument eArgument, css::uno::Reference< css::task::XInteractionHandler >&        xValue );
        sal_Bool getArgument   ( EArgument eArgument, css::util::URL&                                               aValue );

        void     setArgument   ( EArgument eArgument, const ::rtl::OUString&                                        sValue );
        void     setArgument   ( EArgument eArgument, sal_Int16                                                     nValue );
        void     setArgument   ( EArgument eArgument, sal_Int32                                                     nValue );
        void     setArgument   ( EArgument eArgument, sal_Bool                                                      bValue );
        void     setArgument   ( EArgument eArgument, const css::awt::Rectangle&                                    aValue );
        void     setArgument   ( EArgument eArgument, const css::uno::Reference< css::io::XInputStream >&           xValue );
        void     setArgument   ( EArgument eArgument, const css::uno::Reference< css::io::XOutputStream >&          xValue );
        void     setArgument   ( EArgument eArgument, const css::uno::Reference< css::task::XStatusIndicator >&     xValue );
        void     setArgument   ( EArgument eArgument, const css::uno::Reference< css::task::XInteractionHandler >&  xValue );
        void     setArgument   ( EArgument eArgument, const css::util::URL&                                         aValue );

		//---------------------------------------------------------------------------------------------------------
		//	private methods
		//---------------------------------------------------------------------------------------------------------
		private:

        sal_Bool impl_getArgument        (       EArgument                                        eArgument  ,
                                                 void*                                            pValue     ) const;
        void     impl_setArgument        (       EArgument                                        eArgument  ,
                                           const void*                                            pValue     );
        void     impl_analyzeIt          (                                                                   );
        void     impl_addOrChangeArgument(       sal_Int32*                                       pPosition  ,
                                           const ::rtl::OUString&                                 sName      ,
                                           const css::uno::Any&                                   aValue     );
        void     impl_deleteArgument     (       sal_Int32*                                       pPosition  ,
                                                 sal_Int32*                                       pLast      );
        void     impl_correctOldFormat   (                                                                   );

        //---------------------------------------------------------------------------------------------------------
        //  debug methods
        //---------------------------------------------------------------------------------------------------------
        #ifdef ENABLE_COMPONENT_SELF_CHECK
        public:
            static void impldbg_checkIt( const css::uno::Reference< css::lang::XMultiServiceFactory >& xSMGR    ,
                                         const css::uno::Reference< css::uno::XInterface >&            xContext );

        private:
            sal_Bool impldbg_getArgument  (const ::rtl::OUString&                             sName      ,
                                                 ::rtl::OUString*                             pString    ,
                                                 sal_Int16*                                   pShort     ,
                                                 sal_Int32*                                   pLong      ,
                                                 sal_Bool*                                    pBool      ,
                                                 css::uno::Reference< css::uno::XInterface >* pInterface );

            void     impldbg_dumpArguments(const char*                                        pMessage   ,
                                                 ::rtl::OUStringBuffer*                       pBuffer    );
        #endif

		//---------------------------------------------------------------------------------------------------------
		//	member
		//	should private every way!
		//---------------------------------------------------------------------------------------------------------
		private:

            ArgumentReferences                                  m_aAnalyzed     ;
            css::uno::Sequence< css::beans::PropertyValue >     m_lArgs         ;
            sal_Bool                                            m_bReadOnly     ;
            sal_Bool                                            m_bValid        ;

};		//	class ArgumentAnalyzer

}		//	namespace framework

#endif	//	#ifndef __FRAMEWORK_CLASSES_ARGUMENTANALYZER_HXX_
