/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: axisgrid.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:40:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef _SCH_AXISGRID_HXX
#define _SCH_AXISGRID_HXX

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif


#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif

#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif

#ifndef _SV_WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif


#ifndef _SFXITEMSET_HXX //autogen
#include <svtools/itemset.hxx>
#endif


#include "axisgrid.hrc"

/*************************************************************************
|*
|* Axes dialogue
|*
\************************************************************************/
class SchAxisDlg : public ModalDialog
{
private:
	FixedLine			aFlPrimary;
	CheckBox			aCbPrimaryX;
	CheckBox			aCbPrimaryY;
	CheckBox			aCbPrimaryZ;
	
	FixedLine			aFlSecondary;
	CheckBox			aCbSecondaryX;
	CheckBox			aCbSecondaryY;
	
	OKButton			aPbOK;
	CancelButton		aPbCancel;
	HelpButton	 		aPbHelp;

	BOOL				bOldShowX;
	BOOL				bOldShowY;
	BOOL				bOldShowZ;
	BOOL				bOldShow2X;
	BOOL				bOldShow2Y;

	const SfxItemSet&	rOutAttrs;

	void Reset();

public:
	SchAxisDlg( Window* pParent, const SfxItemSet& rInAttrs,
					BOOL b3D, BOOL bNet,
					BOOL bSecondaryX, BOOL bSecondaryY );
	virtual ~SchAxisDlg();

	void GetAttr( SfxItemSet& rOutAttrs );
};


/*************************************************************************
|*
|* Grid dialogue
|*
\************************************************************************/
class SchGridDlg : public ModalDialog
{
private:
	FixedLine			aFlMain;
	CheckBox			aCbMainX;
	CheckBox			aCbMainY;
	CheckBox			aCbMainZ;

	FixedLine			aFlHelp;
	CheckBox			aCbHelpX;
	CheckBox			aCbHelpY;
	CheckBox			aCbHelpZ;

	OKButton			aPbOK;
	CancelButton		aPbCancel;
	HelpButton			aPbHelp;

	const SfxItemSet&	rOutAttrs;

	void Reset();

public:
	SchGridDlg( Window* pParent, const SfxItemSet& rInAttrs,
				BOOL b3D, BOOL bNet,
				BOOL bSecondaryX, BOOL bSecondaryY );
	virtual ~SchGridDlg();

	void GetAttr( SfxItemSet& rOutAttr );
};


#endif // _SCH_AXISGRID_HXX

