/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: GraphicObjectBar.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: obo $ $Date: 2006/03/21 17:36:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "GraphicObjectBar.hxx"

#include <limits.h>
#include <vcl/msgbox.hxx>
#include <svtools/whiter.hxx>
#include <svtools/itempool.hxx>
#ifndef _SFXAPP_HXX
#include <sfx2/app.hxx>
#endif
#ifndef _SFX_SHELL_HXX //autogen
#include <sfx2/shell.hxx>
#endif
#ifndef _SVXIDS_HRC
#include <svx/svxids.hrc>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
#ifndef _BASEDLGS_HXX
#include <sfx2/basedlgs.hxx>
#endif
#ifndef _SVDOPATH_HXX //autogen
#include <svx/svdograf.hxx>
#endif
#ifndef _SVX_GRFFLT_HXX //autogen
#include <svx/grfflt.hxx>
#endif
#ifndef _AEITEM_HXX //autogen
#include <svtools/aeitem.hxx>
#endif
#ifndef _SVX_GRAFCTRL_HXX
#include <svx/grafctrl.hxx>
#endif

#pragma hdrstop

#include <sfx2/objface.hxx>

#include "app.hrc"
#include "res_bmp.hrc"
#include "glob.hrc"
#include "strings.hrc"
#include "DrawDocShell.hxx"
#ifndef SD_VIEW_SHELL_HXX
#include "ViewShell.hxx"
#endif
#ifndef SD_WINDOW_HXX
#include "Window.hxx"
#endif
#ifndef SD_DRAW_VIEW_HXX
#include "drawview.hxx"
#endif
#include "sdresid.hxx"
#include "drawdoc.hxx"

using namespace sd;
#define GraphicObjectBar
#include "sdslots.hxx"

namespace sd {


SFX_DECL_TYPE( 13 );


// -----------------------
// - GraphicObjectBar -
// -----------------------

SFX_IMPL_INTERFACE( GraphicObjectBar, SfxShell, SdResId( STR_GRAFOBJECTBARSHELL ) )
{
}

// -----------------------------------------------------------------------------

TYPEINIT1( GraphicObjectBar, SfxShell );

// -----------------------------------------------------------------------------

GraphicObjectBar::GraphicObjectBar (
    ViewShell* pSdViewShell,
    ::sd::View* pSdView )
    : SfxShell (pSdViewShell->GetViewShell()),
      pView	 ( pSdView ),
      pViewSh ( pSdViewShell ),
      nMappedSlotFilter ( SID_GRFFILTER_INVERT )
{
	DrawDocShell* pDocShell = pViewSh->GetDocSh();

	SetPool( &pDocShell->GetPool() );
	SetUndoManager( pDocShell->GetUndoManager() );
	SetRepeatTarget( pView );
	SetHelpId( SD_IF_SDDRAWGRAFOBJECTBAR );
	SetName( String( RTL_CONSTASCII_USTRINGPARAM( "Graphic objectbar" )));
}

// -----------------------------------------------------------------------------

GraphicObjectBar::~GraphicObjectBar()
{
	SetRepeatTarget( NULL );
}

// -----------------------------------------------------------------------------

void GraphicObjectBar::GetAttrState( SfxItemSet& rSet )
{
	if( pView )
		SvxGrafAttrHelper::GetGrafAttrState( rSet, *pView );
}

// -----------------------------------------------------------------------------

void GraphicObjectBar::Execute( SfxRequest& rReq )
{
	if( pView )
	{
		SvxGrafAttrHelper::ExecuteGrafAttr( rReq, *pView );
		Invalidate();
	}
}

// -----------------------------------------------------------------------------

void GraphicObjectBar::GetFilterState( SfxItemSet& rSet )
{
	const SdrMarkList&	rMarkList = pView->GetMarkedObjectList();
	BOOL				bEnable = FALSE;

	if( rMarkList.GetMarkCount() == 1 )
	{
		SdrObject* pObj = rMarkList.GetMark( 0 )->GetObj();

		if( pObj && pObj->ISA( SdrGrafObj ) && ( ( (SdrGrafObj*) pObj )->GetGraphicType() == GRAPHIC_BITMAP ) )
			bEnable = TRUE;
	}

	if( !bEnable )
		SvxGraphicFilter::DisableGraphicFilterSlots( rSet );
}

// -----------------------------------------------------------------------------

void GraphicObjectBar::ExecuteFilter( SfxRequest& rReq )
{
	const SdrMarkList& rMarkList = pView->GetMarkedObjectList();

	if( rMarkList.GetMarkCount() == 1 )
	{
		SdrObject* pObj = rMarkList.GetMark( 0 )->GetObj();

		if( pObj && pObj->ISA( SdrGrafObj ) && ( (SdrGrafObj*) pObj )->GetGraphicType() == GRAPHIC_BITMAP )
		{
			GraphicObject aFilterObj( ( (SdrGrafObj*) pObj )->GetGraphicObject() );

			if( SVX_GRAPHICFILTER_ERRCODE_NONE == 
				SvxGraphicFilter::ExecuteGrfFilterSlot( rReq, aFilterObj ) )
			{
				SdrPageView* pPageView = pView->GetPageViewPvNum( 0 );

				if( pPageView )
				{
					SdrGrafObj*	pFilteredObj = (SdrGrafObj*) pObj->Clone();
					String		aStr( pView->GetDescriptionOfMarkedObjects() );

					aStr.Append( sal_Unicode(' ') );
					aStr.Append( String( SdResId( STR_UNDO_GRAFFILTER ) ) );
					pView->BegUndo( aStr );
					pFilteredObj->SetGraphicObject( aFilterObj );
					pView->ReplaceObject( pObj, *pPageView, pFilteredObj );
					pView->EndUndo();
				}
			}
		}
	}

	Invalidate();
}

} // end of namespace sd
