/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: MemMgr.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:07:14 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// -----------------------------------------------------------------------

#define MEMBLOCK_MINSIZE    sizeof(FreeBlock)
#define MEMBLOCK_ISLARGE    512
#define MEMBLOCK_LAST       0xFFFF
#define MEMBLOCK_SYSBLOCK   0xFFFF
#define MEMBLOCK_NOTFREE    0x8000

// -----------------------------------------------------------------------

#pragma pack( 1 )

// ! MemBlock muss in gleicher Form am Anfang von FreeBlock stehen !

struct MemBlock
{
    USHORT      nSize;      // Groesse des Blocks
    USHORT      nPrev;      // Offset zum vorherigen Block
};

struct FreeBlock
{
    USHORT      nSize;      // Groesse des Blocks
    USHORT      nPrev;      // Offset zum vorherigen Block
    FreeBlock*  pNext;      // Pointer auf naechsten freien Block
    FreeBlock*  pPrev;      // Pointer auf vorherigen freien Block
};

#pragma pack()

// -----------------------------------------------------------------------

void* MemAlloc( ULONG nAlloc );

// -----------------------------------------------------------------------

#ifdef DBG_UTIL

#define DBG_INIT_SIGNATURE                  0x77
#define DBG_BOUND_SIGNATURE                 0x55
#define DBG_FREE_SIGNATURE                  0x33

#define DBG_MEMERR_OVERWRITE_BEFOR          1
#define DBG_MEMERR_OVERWRITE_BEHIND         2
#define DBG_MEMERR_OVERWRITE_FREE           3
#define DBG_MEMERR_UNKNOWN_PTR              4
#ifdef MAC
	#define DBG_MEMERR_ODD_PTR 		            5
	#define DBG_MEMERR_NOTINHEAP_PTR            6
#endif

// -----------------------------------------------------------------------

#include <debug.hxx>

void* DbgMemAlloc( ULONG nAlloc );
void* DbgMemFree( void* p );


#define DBG_MEM_ALLOC( n )                                              \
    DbgMemAlloc( n )

#define DBG_MEM_FREE( p )                                               \
    p = DbgMemFree( p );                                                \
    if ( !p )                                                           \
        return;

#define DBG_MEM_FREESET( p, n )                                         \
    DbgData* pData = DbgGetData();                                      \
    if ( pData )                                                        \
    {                                                                   \
        if ( pData->nTestFlags &                                        \
             (DBG_TEST_MEM_INIT | DBG_TEST_MEM_OVERWRITEFREE) )         \
            memset( p, DBG_FREE_SIGNATURE, n );                         \
    }

// -----------------------------------------------------------------------
#else

#define DBG_MEM_ALLOC( n )          MemAlloc( n )
#define DBG_MEM_FREE( p )
#define DBG_MEM_FREESET( p, n )

#endif
