#*************************************************************************
#
#   $RCSfile: check.pl,v $
#
#   $Revision: 1.14 $
#
#   last change: $Author: rt $ $Date: 2005/11/11 10:52:54 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************

#
# check - a perl script to check some files and directories if they exists
# A first simple check if the SDK was built completely.
#
#use IO::File;

$return = 0;

$StartDir = "$ARGV[0]";
$OperatingSystem = "$ARGV[1]";
#$ExePrefix = "$ARGV[2]";

print "Check for $OperatingSystem\n";

if (-d "$StartDir") {
    # packaging files
    print "check packaging files: ";
    if (! -e "$StartDir/index.html") {
	print "\nERROR: \"$StartDir/index.html\" is missing\n";
	$return++;
    }
    if (-d "$StartDir/docs") {
	my @filelist = ( "install.html","DevelopersGuide_intro.html",
			 "notsupported.html","sdk_styles.css","tools.html",
			 "images/arrow-1.gif", "images/arrow-3.gif",
			 "images/bg_table.gif","images/bg_table2.gif",
			 "images/bg_table3.gif", "images/nav_down.png",
			 "images/nav_home.png","images/nav_left.png",
			 "images/nav_right.png","images/nav_up.png",
			 "images/sdk_head-1.gif", "images/sdk_head-2.gif",
			 "images/sdk_head-3.gif", "images/sdk_line-1.gif",
			 "images/sdk_line-2.gif", "common/ref/idl.css" );

	foreach $i (@filelist)
	{
	    if (! -e "$StartDir/docs/$i") {
		$return++;
		print "\nERROR: \"$StartDir/docs/$i\" is missing\n";
	    } else {
		print "+";
	    }
	}
    } else {
	$return++;
    }
    print "\n";

    # check DevGuide
    print "check DevGuide: ";
    if (! -e "$StartDir/docs/DevelopersGuide/DevelopersGuide.pdf") {
	print "\nERROR: \"$StartDir/docs/DevelopersGuide/DevelopersGuide.pdf\" is missing\n";
	$return++;
    }
    if (! -e "$StartDir/docs/DevelopersGuide/DevelopersGuide.xhtml") {
	print "\nERROR: \"$StartDir/docs/DevelopersGuide/DevelopersGuide.xhtml\" is missing\n";
	$return++;
    }
    print "\n";

    #check setting files
    print "check setting files: ";
    if (-d "$StartDir/settings") {
	if (! -e "$StartDir/settings/dk.mk") {
	    print "\nERROR: \"$StartDir/settings/dk.mk\" is missing\n";
	    $return++;
	}
    } else {
	$return++;
    }
    print "\n";

    #check idl docu, it is only a first and simple check
    # improvement required
    print "check idl docu: ";
    if (-d "$StartDir/docs/common/ref") {
	if (! -e "$StartDir/docs/common/ref/module-ix.html") {
	    print "\nERROR: \"$StartDir/docs/common/ref/module-ix.html\" is missing\n";
	    $return++;
	}
	if (! -d "$StartDir/docs/common/ref/index-files") {
	    print "\nERROR: \"$StartDir/docs/common/ref/index-files\" is missing\n";
	    $return++;
	}
	if (! -e "$StartDir/docs/common/ref/index-files/index-10.html") {
	    print "\nERROR: \"$StartDir/docs/common/ref/index-files/index-10.html\" is missing\n";
	    $return++;
	}

	my @idl_dirlist = ( "io","ui","ui/dialogs","awt","sdb","svg","ucb","uno","xml","xml/sax",
			    "auth","i18n","form","form/control","form/component","java","lang","ldap",
			    "sdbc","task","test","test/bridge","test/performance","text","text/FieldMaster",
			    "text/textfield","text/textfield/docinfo","sync","view","util","util/logging",
			    "beans","chart","frame","image","presentation","sdbcx","setup","sheet","table",
			    "style","sync2","resource","packages","packages/zip","packages/manifest",
			    "linguistic2","scanner","drawing","accessibility","container","installation",
			    "bridge","configuration","configuration/backend","configuration/backend/xml",
			    "configuration/bootstrap","formula","mozilla","connection","security","loader",
			    "reflection","plugin","script","system","datatransfer","datatransfer/dnd",
			    "datatransfer/clipboard","document","registry" );
	foreach $i (@idl_dirlist)
	{
	    if (! -d "$StartDir/docs/common/ref/com/sun/star/$i") {
		$return++;
		print "\nERROR: \"$StartDir/docs/common/ref/com/sun/star/$i\" is missing\n";
	    } else {
		print "+";
	    }
	}
    } else {
	$return++;
    }
    print "\n";

} else {
    $return++;
}

if( $return != 0 )
{
    print "ERROR\n";
    unlink "$ARGV[3]";
} else {
    print "OK\n";
}

exit $return;
