/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tbinsert.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:52:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// System - Includes -----------------------------------------------------

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

// auto strip #include <tools/shl.hxx>
#include <svtools/intitem.hxx>
// auto strip #include <bf_sfx2/dispatch.hxx>
#include <bf_sfx2/dispatch.hxx>

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "tbinsert.hxx"
#include "tbinsert.hrc"
// auto strip #include "global.hxx"
#include "scmod.hxx"
// auto strip #include "scresid.hxx"
#include "bf_sc.hrc"
namespace binfilter {

// -----------------------------------------------------------------------

/*N*/ SFX_IMPL_TOOLBOX_CONTROL( ScTbxInsertCtrl, SfxUInt16Item);

//------------------------------------------------------------------
//
//	ToolBox - Controller
//
//------------------------------------------------------------------

/*N*/ ScTbxInsertCtrl::ScTbxInsertCtrl( USHORT nId, ToolBox& rTbx, SfxBindings& rBind ) :
/*N*/ 		SfxToolBoxControl( nId, rTbx, rBind ),
/*N*/ 		nLastSlotId(0)
/*N*/ {
/*N*/ }

/*N*/ __EXPORT ScTbxInsertCtrl::~ScTbxInsertCtrl()
/*N*/ {
/*N*/ }

/*N*/ void __EXPORT ScTbxInsertCtrl::StateChanged( USHORT nSID, SfxItemState eState,
/*N*/ 											  const SfxPoolItem* pState )
/*N*/ {
/*N*/ 	GetToolBox().EnableItem( GetId(), (GetItemState(pState) != SFX_ITEM_DISABLED) );
/*N*/ 
/*N*/ 	if( eState == SFX_ITEM_AVAILABLE )
/*N*/ 	{
/*N*/ 		const SfxUInt16Item* pItem = PTR_CAST( SfxUInt16Item, pState );
/*N*/ 		if(pItem)
/*N*/ 		{
/*N*/ 			nLastSlotId = pItem->GetValue();
/*N*/ 			USHORT nImageId = nLastSlotId ? nLastSlotId : GetId();
/*N*/             Image aImage = GetBindings().GetImageManager()->GetImage( nImageId,
/*N*/ 		           		GetToolBox().GetDisplayBackground().GetColor().IsDark(),
/*N*/ 		           		SC_MOD() );
/*N*/ 			GetToolBox().SetItemImage(GetId(), aImage);
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//STRIP001 SfxPopupWindow* __EXPORT ScTbxInsertCtrl::CreatePopupWindow()
//STRIP001 {
//STRIP001 	USHORT nWinResId, nTbxResId;
//STRIP001 	USHORT nSlotId = GetId();
//STRIP001 	if (nSlotId == SID_TBXCTL_INSERT)
//STRIP001 	{
//STRIP001 		nWinResId = RID_TBXCTL_INSERT;
//STRIP001 		nTbxResId = RID_TOOLBOX_INSERT;
//STRIP001 	}
//STRIP001 	else if (nSlotId == SID_TBXCTL_INSCELLS)
//STRIP001 	{
//STRIP001 		nWinResId = RID_TBXCTL_INSCELLS;
//STRIP001 		nTbxResId = RID_TOOLBOX_INSCELLS;
//STRIP001 	}
//STRIP001 	else /* SID_TBXCTL_INSOBJ */
//STRIP001 	{
//STRIP001 		nWinResId = RID_TBXCTL_INSOBJ;
//STRIP001 		nTbxResId = RID_TOOLBOX_INSOBJ;
//STRIP001 	}
//STRIP001 
//STRIP001 	WindowAlign eNewAlign = ( GetToolBox().IsHorizontal() ) ? WINDOWALIGN_LEFT : WINDOWALIGN_TOP;
//STRIP001 	ScTbxInsertPopup *pWin = new ScTbxInsertPopup( nSlotId, eNewAlign,
//STRIP001 									ScResId(nWinResId), ScResId(nTbxResId), GetBindings() );
//STRIP001 	pWin->StartPopupMode(&GetToolBox(), TRUE);
//STRIP001 	pWin->StartSelection();
//STRIP001 	pWin->Show();
//STRIP001 	return pWin;
//STRIP001 }

//STRIP001 SfxPopupWindowType __EXPORT ScTbxInsertCtrl::GetPopupWindowType() const
//STRIP001 {
//STRIP001 	return nLastSlotId ? SFX_POPUPWINDOW_ONTIMEOUT : SFX_POPUPWINDOW_ONCLICK;
//STRIP001 }

//STRIP001 void __EXPORT ScTbxInsertCtrl::Select( BOOL bMod1 )
//STRIP001 {
//STRIP001 	if (nLastSlotId)
//STRIP001 		GetBindings().GetDispatcher()->Execute(nLastSlotId);
//STRIP001 }

//------------------------------------------------------------------
//
//	Popup - Window
//
//------------------------------------------------------------------

//STRIP001 ScTbxInsertPopup::ScTbxInsertPopup( USHORT nId, WindowAlign eNewAlign,
//STRIP001 						const ResId& rRIdWin, const ResId& rRIdTbx,
//STRIP001 						SfxBindings& rBindings ) :
//STRIP001 				SfxPopupWindow	( nId, rRIdWin, rBindings),
//STRIP001 				aTbx			( this, GetBindings(), rRIdTbx ),
//STRIP001 				aRIdWinTemp(rRIdWin),
//STRIP001 				aRIdTbxTemp(rRIdTbx)
//STRIP001 {
//STRIP001 	aTbx.UseDefault();
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	aTbx.GetToolBox().SetAlign( eNewAlign );
//STRIP001 	if (eNewAlign == WINDOWALIGN_LEFT || eNewAlign == WINDOWALIGN_RIGHT)
//STRIP001 		SetText( EMPTY_STRING );
//STRIP001 
//STRIP001 	Size aSize = aTbx.CalcWindowSizePixel();
//STRIP001 	aTbx.SetPosSizePixel( Point(), aSize );
//STRIP001 	SetOutputSizePixel( aSize );
//STRIP001 	aTbx.GetToolBox().SetSelectHdl(	LINK(this, ScTbxInsertPopup, TbxSelectHdl));
//STRIP001 	aTbxClickHdl = aTbx.GetToolBox().GetClickHdl();
//STRIP001 	aTbx.GetToolBox().SetClickHdl(	LINK(this, ScTbxInsertPopup, TbxClickHdl));
//STRIP001 }

//STRIP001 ScTbxInsertPopup::~ScTbxInsertPopup()
//STRIP001 {
//STRIP001 }

//STRIP001 SfxPopupWindow* __EXPORT ScTbxInsertPopup::Clone() const
//STRIP001 {
//STRIP001 	return new ScTbxInsertPopup( GetId(), aTbx.GetToolBox().GetAlign(),
//STRIP001 									aRIdWinTemp, aRIdTbxTemp,
//STRIP001 									(SfxBindings&) GetBindings() );
//STRIP001 }

//STRIP001 void ScTbxInsertPopup::StartSelection()
//STRIP001 {
//STRIP001 	aTbx.GetToolBox().StartSelection();
//STRIP001 }

//STRIP001 IMPL_LINK(ScTbxInsertPopup, TbxSelectHdl, ToolBox*, pBox)
//STRIP001 {
//STRIP001 	EndPopupMode();
//STRIP001 
//STRIP001 	USHORT nLastSlotId = pBox->GetCurItemId();
//STRIP001 	SfxUInt16Item aItem( GetId(), nLastSlotId );
//STRIP001 	SfxDispatcher* pDisp = GetBindings().GetDispatcher();
//STRIP001 	pDisp->Execute( GetId(), SFX_CALLMODE_SYNCHRON, &aItem, 0L );
//STRIP001 	pDisp->Execute( nLastSlotId, SFX_CALLMODE_ASYNCHRON );
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 IMPL_LINK(ScTbxInsertPopup, TbxClickHdl, ToolBox*, pBox)
//STRIP001 {
//STRIP001 	USHORT nLastSlotId = pBox->GetCurItemId();
//STRIP001 	SfxUInt16Item aItem( GetId(), nLastSlotId );
//STRIP001 	GetBindings().GetDispatcher()->Execute( GetId(), SFX_CALLMODE_SYNCHRON, &aItem, 0L );
//STRIP001 	if(aTbxClickHdl.IsSet())
//STRIP001 		aTbxClickHdl.Call(pBox);
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 void __EXPORT ScTbxInsertPopup::PopupModeEnd()
//STRIP001 {
//STRIP001 	aTbx.GetToolBox().EndSelection();
//STRIP001 	SfxPopupWindow::PopupModeEnd();
//STRIP001 }



}
