/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_foptmgr.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:59:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// System - Includes ---------------------------------------------------------

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif


// INCLUDE -------------------------------------------------------------------

// auto strip #include <vcl/morebtn.hxx>
// auto strip #include <svtools/stdctrl.hxx>

// auto strip #include "anyrefdg.hxx"
// auto strip #include "rangeutl.hxx"
// auto strip #include "dbcolect.hxx"
// auto strip #include "viewdata.hxx"
// auto strip #include "document.hxx"

#define _FOPTMGR_CXX
// auto strip #include "foptmgr.hxx"
#undef _FOPTMGR_CXX
namespace binfilter {

//----------------------------------------------------------------------------

//STRIP001 ScFilterOptionsMgr::ScFilterOptionsMgr(
//STRIP001 								Dialog*				ptrDlg,
//STRIP001 								ScViewData*			ptrViewData,
//STRIP001 								const ScQueryParam&	refQueryData,
//STRIP001 								MoreButton&			refBtnMore,
//STRIP001 								CheckBox&			refBtnCase,
//STRIP001 								CheckBox&			refBtnRegExp,
//STRIP001 								CheckBox&			refBtnHeader,
//STRIP001 								CheckBox&			refBtnUnique,
//STRIP001 								CheckBox&			refBtnCopyResult,
//STRIP001 								CheckBox&			refBtnDestPers,
//STRIP001 								ListBox&			refLbCopyArea,
//STRIP001 								Edit&				refEdCopyArea,
//STRIP001 								ScRefButton&		refRbCopyArea,
//STRIP001 								FixedText&			refFtDbAreaLabel,
//STRIP001 								FixedInfo&			refFtDbArea,
//STRIP001                                 FixedLine&          refFlOptions,
//STRIP001 								const String&		refStrNoName,
//STRIP001 								const String&		refStrUndefined )
//STRIP001 
//STRIP001 	:	pDlg			( ptrDlg ),
//STRIP001 		pViewData		( ptrViewData ),
//STRIP001 		pDoc			( ptrViewData ? ptrViewData->GetDocument() : NULL ),
//STRIP001 		rQueryData		( refQueryData ),
//STRIP001 		rBtnMore		( refBtnMore ),
//STRIP001 		rBtnCase		( refBtnCase ),
//STRIP001 		rBtnRegExp		( refBtnRegExp ),
//STRIP001 		rBtnHeader		( refBtnHeader ),
//STRIP001 		rBtnUnique		( refBtnUnique ),
//STRIP001 		rBtnCopyResult	( refBtnCopyResult ),
//STRIP001 		rBtnDestPers	( refBtnDestPers ),
//STRIP001 		rLbCopyPos		( refLbCopyArea ),
//STRIP001 		rEdCopyPos		( refEdCopyArea ),
//STRIP001 		rRbCopyPos		( refRbCopyArea ),
//STRIP001 		rFtDbAreaLabel	( refFtDbAreaLabel ),
//STRIP001 		rFtDbArea		( refFtDbArea ),
//STRIP001         rFlOptions      ( refFlOptions ),
//STRIP001 		rStrNoName		( refStrNoName ),
//STRIP001 		rStrUndefined	( refStrUndefined )
//STRIP001 {
//STRIP001 	Init();
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 ScFilterOptionsMgr::~ScFilterOptionsMgr()
//STRIP001 {
//STRIP001 	USHORT nEntries = rLbCopyPos.GetEntryCount();
//STRIP001 	USHORT i;
//STRIP001 
//STRIP001 	for ( i=2; i<nEntries; i++ )
//STRIP001 		delete (String*)rLbCopyPos.GetEntryData( i );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScFilterOptionsMgr::Init()
//STRIP001 {
//STRIP001 	DBG_ASSERT( pViewData && pDoc, "Init failed :-/" );
//STRIP001 
//STRIP001 	rLbCopyPos.SetSelectHdl	 ( LINK( this, ScFilterOptionsMgr, LbPosSelHdl ) );
//STRIP001 	rEdCopyPos.SetModifyHdl	 ( LINK( this, ScFilterOptionsMgr, EdPosModifyHdl ) );
//STRIP001 	rBtnCopyResult.SetClickHdl( LINK( this, ScFilterOptionsMgr, BtnCopyResultHdl ) );
//STRIP001 
//STRIP001 	rBtnMore.AddWindow( &rBtnCase );
//STRIP001 	rBtnMore.AddWindow( &rBtnRegExp );
//STRIP001 	rBtnMore.AddWindow( &rBtnHeader );
//STRIP001 	rBtnMore.AddWindow( &rBtnUnique );
//STRIP001 	rBtnMore.AddWindow( &rBtnCopyResult );
//STRIP001 	rBtnMore.AddWindow( &rBtnDestPers );
//STRIP001 	rBtnMore.AddWindow( &rLbCopyPos );
//STRIP001 	rBtnMore.AddWindow( &rEdCopyPos );
//STRIP001 	rBtnMore.AddWindow( &rRbCopyPos );
//STRIP001 	rBtnMore.AddWindow( &rFtDbAreaLabel );
//STRIP001 	rBtnMore.AddWindow( &rFtDbArea );
//STRIP001     rBtnMore.AddWindow( &rFlOptions );
//STRIP001 
//STRIP001 	rBtnCase	.Check( rQueryData.bCaseSens );
//STRIP001 	rBtnHeader	.Check( rQueryData.bHasHeader );
//STRIP001 	rBtnRegExp	.Check( rQueryData.bRegExp );
//STRIP001 	rBtnUnique	.Check( !rQueryData.bDuplicate );
//STRIP001 
//STRIP001 	if ( pViewData && pDoc )
//STRIP001 	{
//STRIP001 		String			theAreaStr;
//STRIP001 		ScRange			theCurArea ( ScAddress( rQueryData.nCol1,
//STRIP001 												rQueryData.nRow1,
//STRIP001 												pViewData->GetTabNo() ),
//STRIP001 									 ScAddress( rQueryData.nCol2,
//STRIP001 												rQueryData.nRow2,
//STRIP001 												pViewData->GetTabNo() ) );
//STRIP001 		ScDBCollection*	pDBColl		= pDoc->GetDBCollection();
//STRIP001 		String			theDbArea;
//STRIP001 		String			theDbName	= rStrNoName;
//STRIP001 
//STRIP001 		theCurArea.Format( theAreaStr, SCR_ABS_3D, pDoc );
//STRIP001 
//STRIP001 		// Zielbereichsliste fuellen
//STRIP001 
//STRIP001 		rLbCopyPos.Clear();
//STRIP001 		rLbCopyPos.InsertEntry( rStrUndefined, 0 );
//STRIP001 
//STRIP001 		ScAreaNameIterator aIter( pDoc );
//STRIP001 		String aName;
//STRIP001 		ScRange aRange;
//STRIP001 		String aRefStr;
//STRIP001 		while ( aIter.Next( aName, aRange ) )
//STRIP001 		{
//STRIP001 			USHORT nInsert = rLbCopyPos.InsertEntry( aName );
//STRIP001 
//STRIP001 			aRange.aStart.Format( aRefStr, SCA_ABS_3D, pDoc );
//STRIP001 			rLbCopyPos.SetEntryData( nInsert, new String( aRefStr ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		rBtnDestPers.Check( TRUE );			// beim Aufruf immer an
//STRIP001 		rLbCopyPos.SelectEntryPos( 0 );
//STRIP001 		rEdCopyPos.SetText( EMPTY_STRING );
//STRIP001 
//STRIP001 		/*
//STRIP001 		 * Ueberpruefen, ob es sich bei dem uebergebenen
//STRIP001 		 * Bereich um einen Datenbankbereich handelt:
//STRIP001 		 */
//STRIP001 
//STRIP001 		theDbArea = theAreaStr;
//STRIP001 
//STRIP001 		if ( pDBColl )
//STRIP001 		{
//STRIP001 			ScAddress&	rStart	= theCurArea.aStart;
//STRIP001 			ScAddress&	rEnd	= theCurArea.aEnd;
//STRIP001 			ScDBData*	pDBData = pDBColl->GetDBAtArea(	rStart.Tab(),
//STRIP001 														rStart.Col(), rStart.Row(),
//STRIP001 														rEnd.Col(),   rEnd.Row() );
//STRIP001 			if ( pDBData )
//STRIP001 			{
//STRIP001 				rBtnHeader.Check( pDBData->HasHeader() );
//STRIP001 				pDBData->GetName( theDbName );
//STRIP001 
//STRIP001 				if ( theDbName != rStrNoName )
//STRIP001 				{
//STRIP001 					rBtnHeader.Disable();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		theDbArea.AppendAscii(RTL_CONSTASCII_STRINGPARAM(" ("));
//STRIP001 		theDbArea += theDbName;
//STRIP001 		theDbArea += ')';
//STRIP001 		rFtDbArea.SetText( theDbArea );
//STRIP001 
//STRIP001 		//------------------------------------------------------
//STRIP001 		// Kopierposition:
//STRIP001 
//STRIP001 		if ( !rQueryData.bInplace )
//STRIP001 		{
//STRIP001 			String aString;
//STRIP001 
//STRIP001 			ScAddress( rQueryData.nDestCol,
//STRIP001 					   rQueryData.nDestRow,
//STRIP001 					   rQueryData.nDestTab
//STRIP001 					 ).Format( aString, SCA_ABS_3D, pDoc );
//STRIP001 
//STRIP001 			rBtnCopyResult.Check( TRUE );
//STRIP001 			rEdCopyPos.SetText( aString );
//STRIP001 			EdPosModifyHdl( &rEdCopyPos );
//STRIP001 			rLbCopyPos.Enable();
//STRIP001 			rEdCopyPos.Enable();
//STRIP001 			rRbCopyPos.Enable();
//STRIP001 			rBtnDestPers.Enable();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rBtnCopyResult.Check( FALSE );
//STRIP001 			rEdCopyPos.SetText( EMPTY_STRING );
//STRIP001 			rLbCopyPos.Disable();
//STRIP001 			rEdCopyPos.Disable();
//STRIP001 			rRbCopyPos.Disable();
//STRIP001 			rBtnDestPers.Disable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rEdCopyPos.SetText( EMPTY_STRING );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL ScFilterOptionsMgr::VerifyPosStr( const String& rPosStr ) const
//STRIP001 {
//STRIP001 	String aPosStr( rPosStr );
//STRIP001 	xub_StrLen nColonPos = aPosStr.Search( ':' );
//STRIP001 
//STRIP001 	if ( STRING_NOTFOUND != nColonPos )
//STRIP001 		aPosStr.Erase( nColonPos );
//STRIP001 
//STRIP001 	USHORT nResult = ScAddress().Parse( aPosStr, pDoc );
//STRIP001 
//STRIP001 	return ( SCA_VALID == (nResult & SCA_VALID) );
//STRIP001 }


//----------------------------------------------------------------------------
// Handler:

//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScFilterOptionsMgr, LbPosSelHdl, ListBox*, pLb )
//STRIP001 {
//STRIP001 	if ( pLb == &rLbCopyPos )
//STRIP001 	{
//STRIP001 		String aString;
//STRIP001 		USHORT nSelPos = rLbCopyPos.GetSelectEntryPos();
//STRIP001 
//STRIP001 		if ( nSelPos > 0 )
//STRIP001 			aString = *(String*)rLbCopyPos.GetEntryData( nSelPos );
//STRIP001 
//STRIP001 		rEdCopyPos.SetText( aString );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScFilterOptionsMgr, EdPosModifyHdl, Edit*, pEd )
//STRIP001 {
//STRIP001 	if ( pEd == &rEdCopyPos )
//STRIP001 	{
//STRIP001 		String	theCurPosStr = pEd->GetText();
//STRIP001 		USHORT	nResult = ScAddress().Parse( theCurPosStr, pDoc );
//STRIP001 
//STRIP001 		if ( SCA_VALID == (nResult & SCA_VALID) )
//STRIP001 		{
//STRIP001 			String*	pStr	= NULL;
//STRIP001 			BOOL	bFound	= FALSE;
//STRIP001 			USHORT	i		= 0;
//STRIP001 			USHORT	nCount	= rLbCopyPos.GetEntryCount();
//STRIP001 
//STRIP001 			for ( i=2; i<nCount && !bFound; i++ )
//STRIP001 			{
//STRIP001 				pStr = (String*)rLbCopyPos.GetEntryData( i );
//STRIP001 				bFound = (theCurPosStr == *pStr);
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( bFound )
//STRIP001 				rLbCopyPos.SelectEntryPos( --i );
//STRIP001 			else
//STRIP001 				rLbCopyPos.SelectEntryPos( 0 );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			rLbCopyPos.SelectEntryPos( 0 );
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScFilterOptionsMgr, BtnCopyResultHdl, CheckBox*, pBox )
//STRIP001 {
//STRIP001 	if ( pBox == &rBtnCopyResult )
//STRIP001 	{
//STRIP001 		if ( pBox->IsChecked() )
//STRIP001 		{
//STRIP001 			rBtnDestPers.Enable();
//STRIP001 			rLbCopyPos.Enable();
//STRIP001 			rEdCopyPos.Enable();
//STRIP001 			rRbCopyPos.Enable();
//STRIP001 			rEdCopyPos.GrabFocus();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rBtnDestPers.Disable();
//STRIP001 			rLbCopyPos.Disable();
//STRIP001 			rEdCopyPos.Disable();
//STRIP001 			rRbCopyPos.Disable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
}
