/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: crnrdlg.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:38:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SC_CRNRDLG_HXX
#define SC_CRNRDLG_HXX

#ifndef SC_ANYREFDG_HXX
#include "anyrefdg.hxx"
#endif

#ifndef SC_RANGELST_HXX
#include "rangelst.hxx"
#endif

#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

#ifndef _SV_LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif
namespace binfilter {


class ScViewData;
class ScDocument;


//============================================================================

class ScColRowNameRangesDlg : public ScAnyRefDlg
{
public:
					ScColRowNameRangesDlg( SfxBindings* pB, SfxChildWindow* pCW, Window* pParent,
								 ScViewData*	ptrViewData );
					~ScColRowNameRangesDlg();

	virtual void	SetReference( const ScRange& rRef, ScDocument* pDoc );

	virtual BOOL	IsRefInputMode() const;
	virtual void	SetActive();
	virtual BOOL	Close();

private:
    FixedLine       aFlAssign;
	ListBox			aLbRange;

	ScRefEdit		aEdAssign;
	ScRefButton		aRbAssign;
	RadioButton		aBtnColHead;
	RadioButton		aBtnRowHead;
	FixedText		aFtAssign2;
	ScRefEdit		aEdAssign2;
	ScRefButton		aRbAssign2;

	OKButton		aBtnOk;
	CancelButton	aBtnCancel;
	HelpButton		aBtnHelp;
	PushButton		aBtnAdd;
	PushButton		aBtnRemove;

	ScRange			theCurArea;
	ScRange			theCurData;

	ScRangePairListRef	xColNameRanges;
	ScRangePairListRef	xRowNameRanges;

	ScViewData*		pViewData;
	ScDocument*		pDoc;
	ScRefEdit*		pEdActive;
	BOOL			bDlgLostFocus;

#ifdef _CRNRDLG_CXX
private:
	void Init				();
	void UpdateNames		();
	void UpdateRangeData	( const String& rStrName, BOOL bColName );
	void SetColRowData( const ScRange& rLabelRange,BOOL bRef=FALSE);
	void AdjustColRowData( const ScRange& rDataRange,BOOL bRef=FALSE);
	DECL_LINK( CancelBtnHdl, void * );
	DECL_LINK( OkBtnHdl, void * );
	DECL_LINK( AddBtnHdl, void * );
	DECL_LINK( RemoveBtnHdl, void * );
	DECL_LINK( Range1SelectHdl, void * );
	DECL_LINK( Range1DataModifyHdl, void * );
	DECL_LINK( ColClickHdl, void * );
	DECL_LINK( RowClickHdl, void * );
	DECL_LINK( Range2DataModifyHdl, void * );
    DECL_LINK( GetFocusHdl, Control* );
    DECL_LINK( LoseFocusHdl, Control* );
#endif
};



} //namespace binfilter
#endif // SC_CRNRDLG_HXX

