/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_intfrm.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:51:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _SFXENUMITEM_HXX
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTRITEM_HXX //autogen
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXINTITEM_HXX //autogen
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif
#pragma hdrstop

#include "intfrm.hxx"
#include "sfxtypes.hxx"
// auto strip #include "minarray.hxx"
// auto strip #include "bitset.hxx"
// auto strip #include "objsh.hxx"
// auto strip #include "docfac.hxx"
// auto strip #include "viewfac.hxx"
// auto strip #include "viewsh.hxx"
// auto strip #include "bindings.hxx"
#include "dispatch.hxx"
// auto strip #include "request.hxx"
#include "sfxresid.hxx"
// auto strip #include "docfile.hxx"
// auto strip #include "fsetvwsh.hxx"
// auto strip #include "urlframe.hxx"
// auto strip #include "objitem.hxx"
// auto strip #include "splitwin.hxx"
// auto strip #include "topfrm.hxx"
// auto strip #include "contenv.hxx"
// auto strip #include <objshimp.hxx>

#include "sfx.hrc"

// STATIC DATA -----------------------------------------------------------

//STRIP001 DECL_PTRARRAY( SfxInternalFrameArray_Impl, SfxInternalFrame *, 2, 1)//STRIP008 ;

#define SfxInternalFrame
namespace binfilter {
#include "sfxslots.hxx"

//STRIP001 DBG_NAME(SfxInternalFrame)

class SfxInternalWin_Impl : public Window
{
friend class SfxInternalFrame;

	BOOL				bActive;
	SfxInternalFrame*	pFrame;

public:
						SfxInternalWin_Impl( SfxInternalFrame* p,
								Window *pParent, WinBits nBits=0 ) :
							Window( pParent, nBits | WB_BORDER | WB_CLIPCHILDREN ),
							pFrame( p ),
							bActive( FALSE )
						{
							SetBorderStyle( WINDOW_BORDER_NOBORDER );
						}

//STRIP001 	virtual void		Resize();
};

//--------------------------------------------------------------------
//STRIP001 void SfxInternalWin_Impl::Resize()
//STRIP001 {
//STRIP001     pFrame->Resize();
//STRIP001 }

//--------------------------------------------------------------------
//STRIP001 TYPEINIT1(SfxInternalFrame,SfxViewFrame);

/*N*/ SFX_IMPL_INTERFACE(SfxInternalFrame,SfxViewFrame,SfxResId(0))
/*N*/ {
/*N*/ }

//--------------------------------------------------------------------
/*N*/ void SfxInternalFrame::Exec_Impl(SfxRequest &rReq)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_CHKTHIS(SfxInternalFrame, 0);
//STRIP001 	switch ( rReq.GetSlot() )
//STRIP001 	{
//STRIP001 		case SID_CLOSEWIN:
//STRIP001 		{
//STRIP001 			GetFrame()->DoClose();
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_ACTIVATE:
//STRIP001 		{
//STRIP001 			if ( GetObjectShell() )
//STRIP001 			{
//STRIP001                 MakeActive_Impl( TRUE );
//STRIP001                 rReq.SetReturnValue( SfxObjectItem( 0, this ) );
//STRIP001 			}
//STRIP001 
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_FRAME_NAME:
//STRIP001 		case SID_FRAME_CONTENT:
//STRIP001 		{
//STRIP001 			rReq.AppendItem( SfxUInt16Item( SID_MODIFY_FRAME, GetFrame()->GetFrameId_Impl() ) );
//STRIP001 			GetParentViewFrame()->GetViewShell()->ExecuteSlot( rReq );
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_NEWWINDOW:
//STRIP001 		{
//STRIP001 			if ( GetParentViewFrame() &&
//STRIP001                 ( GetParentViewFrame()->GetViewShell()->IsImplementedAsFrameset_Impl() ||
//STRIP001                     GetParentViewFrame()->GetFrame()->HasComponent() ) )
//STRIP001 			{
//STRIP001 				GetParentViewFrame()->ExecuteSlot( rReq );
//STRIP001 				break;
//STRIP001 			}
//STRIP001 
//STRIP001 			SfxFrame *pFrame = GetFrame();
//STRIP001 			SfxFrameDescriptor *pDescriptor = GetFrame()->GetDescriptor();
//STRIP001 
//STRIP001 			// Gew"unschtes Dokument
//STRIP001 			String aFileName( pDescriptor->GetActualURL().GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 			if ( !aFileName.Len() )
//STRIP001 				break;
//STRIP001 
//STRIP001 			SfxStringItem aName( SID_FILE_NAME, aFileName );
//STRIP001 			SfxBoolItem aReadOnly( SID_DOC_READONLY, TRUE );
//STRIP001 			SfxBoolItem aEdit( SID_EDITDOC, pDescriptor->IsEditable() );
//STRIP001 			SfxAllItemSet aSet( SFX_APP()->GetPool() );
//STRIP001 			SfxItemSet* pSet = pDescriptor->GetArgs();
//STRIP001 
//STRIP001 			// Itemset des Descriptors kopieren
//STRIP001 			aSet.Put( *pSet );
//STRIP001 
//STRIP001 			// Readonly nur, wenn explizit gesetzt
//STRIP001 			if ( aReadOnly.GetValue() )
//STRIP001 				aSet.Put( aReadOnly );
//STRIP001 
//STRIP001 			// Editable nur, wenn explizit ausgeschlossen
//STRIP001 			if ( !aEdit.GetValue() )
//STRIP001 				aSet.Put( aEdit );
//STRIP001 
//STRIP001 			// und eigene Parameter hinzuf"ugen
//STRIP001 			aSet.Put( aName, aName.Which() );
//STRIP001 
//STRIP001 			// Falls noch kein Referer gesetzt: das Frameset nehmen
//STRIP001 			SfxObjectShell *pParentDoc = pFrame->GetParentFrame()->GetCurrentDocument();
//STRIP001 			SFX_ITEMSET_ARG( &aSet, pRefererItem, SfxStringItem,
//STRIP001 							 SID_REFERER, FALSE );
//STRIP001 			if ( !pRefererItem || !pRefererItem->GetValue().Len() )
//STRIP001 				aSet.Put( SfxStringItem( SID_REFERER,
//STRIP001 				pParentDoc->GetMedium()->GetName() ) );
//STRIP001 
//STRIP001 			GetDispatcher()->Execute(
//STRIP001 					SID_OPENDOC, SFX_CALLMODE_ASYNCHRON, aSet );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		
//STRIP001 		case SID_NEWDOCDIRECT:
//STRIP001 		{
//STRIP001 			if ( GetParentViewFrame() )
//STRIP001 				GetParentViewFrame()->ExecuteSlot( rReq );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
/*N*/ }

//--------------------------------------------------------------------
/*N*/ void SfxInternalFrame::GetState_Impl(SfxItemSet &rSet)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_CHKTHIS(SfxInternalFrame, 0);
//STRIP001 
//STRIP001 	const USHORT *pRanges = rSet.GetRanges();
//STRIP001 	DBG_ASSERT(pRanges, "Set ohne Bereich");
//STRIP001 	while ( *pRanges )
//STRIP001 	{
//STRIP001 		for ( USHORT nWhich = *pRanges++; nWhich <= *pRanges; ++nWhich )
//STRIP001 		{
//STRIP001 			switch(nWhich)
//STRIP001 			{
//STRIP001 				case SID_WIN_FULLSCREEN:
//STRIP001 					rSet.DisableItem( SID_WIN_FULLSCREEN );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case SID_FRAME_NAME:
//STRIP001 					rSet.Put( SfxStringItem( SID_FRAME_NAME, GetFrame()->GetFrameName() ) );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case SID_FRAME_CONTENT:
//STRIP001 					if ( GetObjectShell() )
//STRIP001 						rSet.Put( SfxStringItem( SID_FRAME_CONTENT, GetObjectShell()->GetMedium()->GetName() ) );
//STRIP001 					else
//STRIP001 						rSet.Put( SfxStringItem( SID_FRAME_CONTENT, String() ) );
//STRIP001 					break;
//STRIP001 				case SID_NEWWINDOW:
//STRIP001 					if ( GetParentViewFrame() &&
//STRIP001 						GetParentViewFrame()->GetViewShell()->IsImplementedAsFrameset_Impl() )
//STRIP001 						GetParentViewFrame()->GetSlotState( nWhich, 0, &rSet );
//STRIP001 					break;
//STRIP001 
//STRIP001 				case SID_NEWDOCDIRECT:
//STRIP001 					if ( GetParentViewFrame() )
//STRIP001 						GetParentViewFrame()->GetSlotState( nWhich, 0, &rSet );
//STRIP001 					break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
/*N*/ }

//--------------------------------------------------------------------
//STRIP001 void SfxInternalFrame::INetExecute_Impl(SfxRequest &rReq)
//STRIP001 {
//STRIP001 	DBG_CHKTHIS(SfxInternalFrame, 0);
//STRIP001 }

//--------------------------------------------------------------------
//STRIP001 void SfxInternalFrame::INetState_Impl(SfxItemSet &rSet)
//STRIP001 {
//STRIP001 	DBG_CHKTHIS(SfxInternalFrame, 0);
//STRIP001 }

//--------------------------------------------------------------------
/*N*/ void SfxInternalFrame::SetZoomFactor( const Fraction &rZoomX,
/*N*/ 									 const Fraction &rZoomY )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	GetViewShell()->SetZoomFactor( rZoomX, rZoomY );
/*N*/ }

//--------------------------------------------------------------------
//STRIP001 String SfxInternalFrame::UpdateTitle()

/*	[Beschreibung]

	SfxInternalFrames haben einen fest zugeordneten Namen und bekommen
	NICHT den des Dokuments mit angeh"angter Nummer. Daher wird die
	Basismethode <SfxViewFrame::UpdataeTitle()> abgefangen.
*/

//STRIP001 {
//STRIP001 	String aSbxName;
//STRIP001 	if ( GetFrame() )
//STRIP001 		aSbxName = String( GetFrame()->GetFrameName() );
//STRIP001 
//STRIP001 	String aRet;
//STRIP001 	if ( GetObjectShell() )
//STRIP001 	{
//STRIP001 		aRet = SfxViewFrame::UpdateTitle();
//STRIP001 		if ( aSbxName.Len() )
//STRIP001 			SetName( aSbxName );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( aSbxName.Len() )
//STRIP001 			SetName( aSbxName );
//STRIP001 		else if ( GetParentViewFrame() )
//STRIP001 		{
//STRIP001 			String aParentName( GetParentViewFrame()->GetName() );
//STRIP001 			aParentName += '/';
//STRIP001 			aParentName += String::CreateFromInt32( GetFrame()->GetFrameId_Impl() );
//STRIP001 			SetName( aParentName );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aSbxName.Len() )
//STRIP001 		return aSbxName;
//STRIP001 	else
//STRIP001 		return aRet;
//STRIP001 }

//--------------------------------------------------------------------
//STRIP001 BOOL SfxInternalFrame::Close()
//STRIP001 {
//STRIP001 	{DBG_CHKTHIS(SfxInternalFrame, 0);}
//STRIP001 
//STRIP001 	if ( !SfxViewFrame::Close() )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	// Da das Fenster selbst hier nicht geclosed wird, mu\s das Deactivate
//STRIP001 	// selbst erzeugt werden
//STRIP001     SfxViewFrame* pParent = GetParentViewFrame();
//STRIP001 
//STRIP001 	// Wieso nicht bei FloatingFrames ?? Wird nicht der active frame
//STRIP001 	// zur"uckgesetzt, -> GPF in Draw bei Ende der Presentation, wenn Focus
//STRIP001 	// im Frame war!
//STRIP001 	if ( /* ( pTop->GetFrameType() & SFXFRAME_FRAMESET ) && */
//STRIP001         pParent->GetActiveChildFrame_Impl() == this )
//STRIP001         pParent->SetActiveChildFrame_Impl( NULL );
//STRIP001 
//STRIP001 	SfxApplication *pSfxApp = SFX_APP();
//STRIP001 	if ( pSfxApp->GetViewFrame() == this )
//STRIP001 	{
//STRIP001         if ( pParent->GetFrame()->IsClosing_Impl() )
//STRIP001             // ParentFrame auch aktivieren, wenn der gerade in SwitchToViewShell ist, sonst droht GPF
//STRIP001 			// sollte ja auch kein Problem sein, denn w"ahrend SwitchToViewShell ist ein aktiver
//STRIP001 			// ViewFrame ohne ViewShell ja v"ollig normal
//STRIP001 			SFX_APP()->SetViewFrame( NULL );
//STRIP001 		else
//STRIP001             pParent->MakeActive_Impl( pWin->HasChildPathFocus( TRUE ) );
//STRIP001 	}
//STRIP001 	delete this;
//STRIP001 	return TRUE;
//STRIP001 }

//--------------------------------------------------------------------
//STRIP001 void SfxInternalFrame::Activate( BOOL bMDI )
//STRIP001 {
//STRIP001 	DBG_CHKTHIS(SfxInternalFrame, 0);
//STRIP001 	DBG_ASSERT(GetViewShell(), "Keine Shell");
//STRIP001 	if ( bMDI && !pWin->bActive )
//STRIP001 		pWin->bActive = TRUE;
//STRIP001 }

//--------------------------------------------------------------------
//STRIP001 void SfxInternalFrame::Deactivate( BOOL bMDI )
//STRIP001 {
//STRIP001 	DBG_CHKTHIS(SfxInternalFrame, 0);
//STRIP001 	pWin->bActive = FALSE;
//STRIP001 }

// CTOR / DTOR -----------------------------------------------------------
/*N*/ SfxInternalFrame::SfxInternalFrame( Window *pWindow, SfxFrame *pFrame,
/*N*/ 		SfxInternalFrameData_Impl *pData, SfxObjectShell *pDoc )
/*N*/ 	: SfxViewFrame( pData->bHasToolSpace ? *(new SfxBindings) :
/*N*/ 		pFrame->GetParentFrame()->GetCurrentViewFrame()->GetBindings(),
/*N*/ 		pFrame, pDoc )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_CTOR(SfxInternalFrame, 0);
//STRIP001 
//STRIP001 	if ( pData->bHasToolSpace )
//STRIP001 	{
//STRIP001 		GetFrame()->SetOwnsBindings_Impl(TRUE);
//STRIP001 		GetFrame()->CreateWorkWindow_Impl();
//STRIP001 	}
//STRIP001 
//STRIP001 	GetFrame()->SetFrameType_Impl( GetFrameType() | SFXFRAME_INTERNAL | SFXFRAME_OWNSDOCUMENT );
//STRIP001 	SetMargin_Impl( pData->aMargin );
//STRIP001 
//STRIP001 	// Internes Window erh"alt "ubergebenen parent
//STRIP001 	pWin = new SfxInternalWin_Impl( this, pWindow /*, pData->bHasToolSpace ? WB_BORDER : 0 */ );
//STRIP001 	SetWindow_Impl( pWin );
//STRIP001 	pWin->SetPosPixel( pData->aWinPos );
//STRIP001 	pWin->bActive = FALSE;
//STRIP001 
//STRIP001 	// Nicht die Gr"o\se direkt abholen, denn pWindow malt seinen Border selbst!
//STRIP001 	pWindow->Resize();
//STRIP001 	Show();
//STRIP001 
//STRIP001 	// View laden bzw. erzeugen
//STRIP001 	if ( pDoc )
//STRIP001 	{
//STRIP001 		CreateView_Impl( pData->nViewId, pData );
//STRIP001 
//STRIP001 		if ( pData->eScrollingMode != SCROLLING_DEFAULT )
//STRIP001 		{
//STRIP001 			DoAdjustPosSizePixel(GetViewShell(), Point(),
//STRIP001 				GetWindow().GetOutputSizePixel());
//STRIP001 		}
//STRIP001 
//STRIP001 		// Name setzen (l"ost Broadcast SFX_HINT_TITLE_CHANGED aus)
//STRIP001 		pDoc->SetNamedVisibility_Impl();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pData->bHasToolSpace )
//STRIP001 		GetBindings().SetDispatcher( GetDispatcher() );
//STRIP001 
//STRIP001 	if ( !pData->bHasUI )
//STRIP001 		GetDispatcher()->HideUI( TRUE );
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ SfxInternalFrame::~SfxInternalFrame()
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_DTOR(SfxInternalFrame, 0);
//STRIP001 
//STRIP001 	if ( GetObjectShell() )
//STRIP001 		SfxViewFrame::ReleaseObjectShell_Impl();
//STRIP001 	delete pWin;
/*N*/ }

//--------------------------------------------------------------------
//STRIP001 SfxViewShell* SfxInternalFrame::CreateView_Impl( USHORT nViewId,
//STRIP001 	SfxInternalFrameData_Impl *pData )

/*	[Beschreibung]

	Erzeugt eine (die erste und einzige) SfxViewShell f"ur diesen
	SfxInternalFrame.
*/

//STRIP001 {
//STRIP001 	// per Factory erzeugen
//STRIP001 	DBG_ASSERT( GetObjectShell(), "Kein Dokument!" );
//STRIP001 
//STRIP001 	SwitchToViewShell_Impl( nViewId );
//STRIP001 	SfxViewShell *pViewShell = GetViewShell();
//STRIP001 	pViewShell->SetScrollingMode( pData->eScrollingMode );
//STRIP001 	return pViewShell;
//STRIP001 }

//------------------------------------------------------------------------
/*N*/ void SfxInternalFrame::InvalidateBorderImpl( const SfxViewShell* pViewSh )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( pViewSh && GetWindow().IsVisible() )
//STRIP001 		DoAdjustPosSizePixel( (SfxViewShell*)pViewSh, Point(), GetWindow().GetOutputSizePixel() );
/*N*/ }

//------------------------------------------------------------------------
//STRIP001 BOOL SfxInternalFrame::SetBorderPixelImpl( const SfxViewShell *pSh, const SvBorder &rBorder )
//STRIP001 {
//STRIP001 	if( SfxViewFrame::SetBorderPixelImpl( pSh, rBorder ) )
//STRIP001 	{
//STRIP001 		Point aDefPoint;
//STRIP001 		Rectangle aEditArea( aDefPoint, GetWindow().GetOutputSizePixel() );
//STRIP001 		aEditArea.Left() += rBorder.Left();
//STRIP001 		aEditArea.Right() -= rBorder.Right();
//STRIP001 		aEditArea.Top() += rBorder.Top();
//STRIP001 		aEditArea.Bottom() -= rBorder.Bottom();
//STRIP001 		pSh->GetWindow()->SetPosSizePixel( aEditArea.TopLeft(), aEditArea.GetSize() );
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }

//--------------------------------------------------------------------
//STRIP001 void SfxInternalFrame::Resize()
//STRIP001 {
//STRIP001 	SfxViewShell *pViewShell = GetViewShell();
//STRIP001 	if ( pViewShell )
//STRIP001 	{
//STRIP001 		if ( pViewShell->UseObjectSize() )
//STRIP001 			ForceOuterResize_Impl(TRUE);
//STRIP001 		DoAdjustPosSizePixel( pViewShell, Point(),
//STRIP001 							GetWindow().GetOutputSizePixel() );
//STRIP001 		if ( pViewShell->UseObjectSize() )
//STRIP001 			ForceOuterResize_Impl(FALSE);
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------
//STRIP001 void SfxInternalFrame::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
//STRIP001 {
//STRIP001 	// we know only SimpleHints
//STRIP001 	BOOL bHandled = FALSE;
//STRIP001 	if ( rHint.IsA(TYPE(SfxSimpleHint)) )
//STRIP001 	{
//STRIP001 		switch( ( (SfxSimpleHint&) rHint ).GetId() )
//STRIP001 		{
//STRIP001             case SFX_HINT_DEINITIALIZING:
//STRIP001 				// on all other changes force repaint
//STRIP001 				GetFrame()->DoClose();
//STRIP001 				bHandled = TRUE;
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bHandled )
//STRIP001 		SfxViewFrame::Notify( rBC, rHint );
//STRIP001 }

//--------------------------------------------------------------------
//STRIP001 void SfxInternalFrame::TakeFrameData_Impl( SfxInternalFrameData_Impl *pData )
//STRIP001 {
//STRIP001 	SfxViewShell *pOldSh = GetViewShell();
//STRIP001 	SfxInternalWin_Impl *pOldWin = pWin;
//STRIP001 
//STRIP001 	DBG_ASSERT( pOldWin, "Das Fenster ist weg!" );
//STRIP001 
//STRIP001 	if ( !pOldSh )
//STRIP001 	{
//STRIP001 		if ( GetObjectShell() )
//STRIP001 		{
//STRIP001 			// Neues Fenster und neue ViewShell erzeugen
//STRIP001 			pWin = new SfxInternalWin_Impl( this, pOldWin->GetParent() );
//STRIP001 			pWin->bActive = pOldWin->bActive;
//STRIP001 			pWin->SetSizePixel( pOldWin->GetSizePixel() );
//STRIP001 			Show();
//STRIP001 			CreateView_Impl( pData->nViewId, pData );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Kein neues Fenster, also Parameter einzeln checken
//STRIP001 		BOOL bScrollingModeChanged =
//STRIP001 			( pOldSh->GetScrollingMode() != pData->eScrollingMode );
//STRIP001 		BOOL bMarginChanged =
//STRIP001 			( pOldSh->GetMargin() != pData->aMargin );
//STRIP001 		if ( bScrollingModeChanged )
//STRIP001 		{
//STRIP001 			GetViewShell()->SetScrollingMode( pData->eScrollingMode );
//STRIP001 			DoAdjustPosSizePixel(GetViewShell(), Point(),
//STRIP001 				GetWindow().GetOutputSizePixel());
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bMarginChanged )
//STRIP001 		{
//STRIP001 			SetMargin_Impl( pData->aMargin );
//STRIP001 			GetViewShell()->SetMargin( pData->aMargin );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	GetDispatcher()->HideUI( !pData->bHasUI );
//STRIP001 
//STRIP001 	// Altes Window l"oschen
//STRIP001 	if ( pWin != pOldWin )
//STRIP001 	{
//STRIP001 		pOldWin->Hide();
//STRIP001 		delete pOldWin;
//STRIP001 	}
//STRIP001 }


}
