/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_srchitem.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:19:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef __SBX_SBXVARIABLE_HXX
#include <basic/sbxvar.hxx>
#endif
#pragma hdrstop

#define _SVX_SRCHITEM_CXX

#include "svxitems.hrc"

#define ITEMID_SEARCH	0
#include "srchitem.hxx"
#include "itemtype.hxx"
#include "dialmgr.hxx"
#include <svtools/memberid.hrc>
#include "svxids.hrc"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------

//STRIP001 TYPEINIT1_AUTOFACTORY(SvxSearchItem, SfxPoolItem);
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxSearchItem::SvxSearchItem( const sal_uInt16 nId ) :
//STRIP001 
//STRIP001 	SfxPoolItem( nId ),
//STRIP001 
//STRIP001 	nCommand		( 0 ),
//STRIP001 	aSearchString	() ,
//STRIP001 	aReplaceString	(),
//STRIP001 	bWordOnly		( sal_False ),
//STRIP001 	bExact			( sal_False ),
//STRIP001 	bBackward		( sal_False ),
//STRIP001 	bSelection		( sal_False ),
//STRIP001 	bRegExp			( sal_False ),
//STRIP001 	bPattern		( sal_False ),
//STRIP001 	bContent		( sal_False ),
//STRIP001 	eFamily			( SFX_STYLE_FAMILY_PARA ),
//STRIP001 	bRowDirection	( sal_True ),
//STRIP001 	bAllTables		( sal_False ),
//STRIP001 	nCellType		( SVX_SEARCHIN_FORMULA ),
//STRIP001 	nAppFlag		( SVX_SEARCHAPP_WRITER ),
//STRIP001 	bLevenshtein	( sal_False ),
//STRIP001 	bLEVRelaxed		( sal_True ),
//STRIP001 	nLEVOther		( 2 ),
//STRIP001 	nLEVShorter   	( 2 ),
//STRIP001 	nLEVLonger    	( 2 )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxSearchItem::SvxSearchItem( const SvxSearchItem& rItem ) :
//STRIP001 
//STRIP001 	SfxPoolItem	( rItem ),
//STRIP001 
//STRIP001 	nCommand		( rItem.nCommand ),
//STRIP001 	aSearchString	( rItem.aSearchString ),
//STRIP001 	aReplaceString	( rItem.aReplaceString ),
//STRIP001 	bWordOnly		( rItem.bWordOnly ),
//STRIP001 	bExact			( rItem.bExact ),
//STRIP001 	bBackward		( rItem.bBackward ),
//STRIP001 	bSelection		( rItem.bSelection ),
//STRIP001 	bRegExp			( rItem.bRegExp ),
//STRIP001 	bPattern		( rItem.bPattern ),
//STRIP001 	bContent		( rItem.bContent ),
//STRIP001 	eFamily			( rItem.eFamily ),
//STRIP001 	bRowDirection	( rItem.bRowDirection ),
//STRIP001 	bAllTables		( rItem.bAllTables ),
//STRIP001 	nCellType		( rItem.nCellType ),
//STRIP001 	nAppFlag		( rItem.nAppFlag ),
//STRIP001 	bLevenshtein	( rItem.bLevenshtein  ),
//STRIP001 	bLEVRelaxed		( rItem.bLEVRelaxed  ),
//STRIP001 	nLEVOther		( rItem.nLEVOther	  ),
//STRIP001 	nLEVShorter   	( rItem.nLEVShorter ),
//STRIP001 	nLEVLonger    	( rItem.nLEVLonger )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxSearchItem::operator==( const SfxPoolItem& rItem ) const
//STRIP001 {
//STRIP001 	DBG_ASSERT( SfxPoolItem::operator==( rItem ), "unequal which or type" );
//STRIP001 
//STRIP001 	return ( nCommand 		== ( (SvxSearchItem&)rItem ).nCommand ) 	  &&
//STRIP001 		   ( aSearchString  == ( (SvxSearchItem&)rItem ).aSearchString )  &&
//STRIP001 		   ( aReplaceString == ( (SvxSearchItem&)rItem ).aReplaceString ) &&
//STRIP001 		   ( bWordOnly 		== ( (SvxSearchItem&)rItem ).bWordOnly ) 	  &&
//STRIP001 		   ( bExact 		== ( (SvxSearchItem&)rItem ).bExact )  		  &&
//STRIP001 		   ( bBackward 		== ( (SvxSearchItem&)rItem ).bBackward ) 	  &&
//STRIP001 		   ( bSelection 	== ( (SvxSearchItem&)rItem ).bSelection ) 	  &&
//STRIP001 		   ( bRegExp 		== ( (SvxSearchItem&)rItem ).bRegExp ) 		  &&
//STRIP001 		   ( bPattern 		== ( (SvxSearchItem&)rItem ).bPattern ) 	  &&
//STRIP001 		   ( bContent 		== ( (SvxSearchItem&)rItem ).bContent ) 	  &&
//STRIP001 		   ( eFamily 		== ( (SvxSearchItem&)rItem ).eFamily ) 		  &&
//STRIP001 		   ( bRowDirection 	== ( (SvxSearchItem&)rItem ).bRowDirection )  &&
//STRIP001 		   ( bAllTables 	== ( (SvxSearchItem&)rItem ).bAllTables )	  &&
//STRIP001 		   ( nCellType 		== ( (SvxSearchItem&)rItem ).nCellType ) 	  &&
//STRIP001 		   ( nAppFlag 		== ( (SvxSearchItem&)rItem ).nAppFlag )		  &&
//STRIP001 		   ( bLevenshtein	== ( (SvxSearchItem&)rItem ).bLevenshtein  )  &&
//STRIP001 		   ( bLEVRelaxed	== ( (SvxSearchItem&)rItem ).bLEVRelaxed  )   &&
//STRIP001 		   ( nLEVOther		== ( (SvxSearchItem&)rItem ).nLEVOther   )    &&
//STRIP001 		   ( nLEVShorter 	== ( (SvxSearchItem&)rItem ).nLEVShorter )    &&
//STRIP001 		   ( nLEVLonger   	== ( (SvxSearchItem&)rItem ).nLEVLonger  );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxItemPresentation SvxSearchItem::GetPresentation
//STRIP001 (
//STRIP001 	SfxItemPresentation ePres,
//STRIP001 	SfxMapUnit			eCoreUnit,
//STRIP001 	SfxMapUnit			ePresUnit,
//STRIP001     XubString&          rText, const IntlWrapper *
//STRIP001 )	const
//STRIP001 {
//STRIP001 	switch ( ePres )
//STRIP001 	{
//STRIP001 		case SFX_ITEM_PRESENTATION_NONE:
//STRIP001 			rText.Erase();
//STRIP001 			return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 		case SFX_ITEM_PRESENTATION_NAMELESS:
//STRIP001 		case SFX_ITEM_PRESENTATION_COMPLETE:
//STRIP001 		{
//STRIP001 			rText = SVX_RESSTR(RID_SVXITEMS_SEARCHCMD_BEGIN + nCommand);
//STRIP001 			rText += cpDelim;
//STRIP001 			rText += aSearchString;
//STRIP001 			rText += cpDelim;
//STRIP001 			rText += aReplaceString;
//STRIP001 			rText += cpDelim;
//STRIP001 			rText += ::GetBoolString( bWordOnly );
//STRIP001 			rText += cpDelim;
//STRIP001 			rText += ::GetBoolString( bExact );
//STRIP001 			rText += cpDelim;
//STRIP001 			rText += ::GetBoolString( bBackward );
//STRIP001 			rText += cpDelim;
//STRIP001 			rText += ::GetBoolString( bSelection );
//STRIP001 			rText += cpDelim;
//STRIP001 			rText += ::GetBoolString( bRegExp );
//STRIP001 			rText += cpDelim;
//STRIP001 			rText += ::GetBoolString( bPattern );
//STRIP001 			rText += cpDelim;
//STRIP001 			rText += ::GetBoolString( bContent );
//STRIP001 			rText += cpDelim;
//STRIP001 			rText += SVX_RESSTR(RID_SVXITEMS_SEARCHSTYLE_BEGIN + (sal_uInt16)eFamily );
//STRIP001 			rText += cpDelim;
//STRIP001 			rText += ::GetBoolString( bRowDirection );
//STRIP001 			rText += cpDelim;
//STRIP001 			rText += ::GetBoolString( bAllTables );
//STRIP001 			rText += cpDelim;
//STRIP001 			rText += SVX_RESSTR(RID_SVXITEMS_SEARCHIN_BEGIN + nCellType);
//STRIP001 			rText += cpDelim;
//STRIP001 			rText += SVX_RESSTR(RID_SVXITEMS_SEARCHAPP_BEGIN + nAppFlag);
//STRIP001 			return ePres;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return SFX_ITEM_PRESENTATION_NONE;
//STRIP001 
//STRIP001 }


}
