/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_unattr.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 02:43:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#define _SVSTDARR_USHORTS
#define _SVSTDARR_USHORTSSORT

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

// auto strip #ifndef _SVDMODEL_HXX //autogen
// auto strip #include <bf_svx/svdmodel.hxx>
// auto strip #endif
#ifndef _SVX_TSTPITEM_HXX //autogen
#include <bf_svx/tstpitem.hxx>
#endif
// auto strip #ifndef _SVDPAGE_HXX //autogen
// auto strip #include <bf_svx/svdpage.hxx>
// auto strip #endif
#ifndef _SFXITEMITER_HXX //autogen
#include <svtools/itemiter.hxx>
#endif


// auto strip #ifndef _FMTFLCNT_HXX //autogen
// auto strip #include <fmtflcnt.hxx>
// auto strip #endif
#ifndef _TXTFTN_HXX //autogen
#include <txtftn.hxx>
#endif
#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif
// auto strip #ifndef _FMTORNT_HXX //autogen
// auto strip #include <fmtornt.hxx>
// auto strip #endif
#ifndef _FMTANCHR_HXX //autogen
#include <fmtanchr.hxx>
#endif
#ifndef _FMTFSIZE_HXX //autogen
#include <fmtfsize.hxx>
#endif
// auto strip #ifndef _FRMFMT_HXX //autogen
// auto strip #include <frmfmt.hxx>
// auto strip #endif
#ifndef _FMTCNTNT_HXX //autogen
#include <fmtcntnt.hxx>
#endif
// auto strip #ifndef _FTNIDX_HXX
// auto strip #include <ftnidx.hxx>
// auto strip #endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif
#ifndef _DOCARY_HXX
#include <docary.hxx>
#endif
#ifndef _SWUNDO_HXX
#include <swundo.hxx>			// fuer die UndoIds
#endif
// auto strip #ifndef _PAM_HXX
// auto strip #include <pam.hxx>
// auto strip #endif
// auto strip #ifndef _NDTXT_HXX
// auto strip #include <ndtxt.hxx>
// auto strip #endif
#ifndef _HINTS_HXX
#include <hints.hxx>
#endif
// auto strip #ifndef _SWATRSET_HXX
// auto strip #include <swatrset.hxx>
// auto strip #endif
#ifndef _SWTABLE_HXX
#include <swtable.hxx>
#endif
#ifndef _UNDOBJ_HXX
#include <undobj.hxx>
#endif
#ifndef _ROLBCK_HXX
#include <rolbck.hxx>
#endif
// auto strip #ifndef _NDNOTXT_HXX
// auto strip #include <ndnotxt.hxx>
// auto strip #endif
#ifndef _DCONTACT_HXX
#include <dcontact.hxx>
#endif
// auto strip #ifndef _FTNINFO_HXX
// auto strip #include <ftninfo.hxx>
// auto strip #endif
#ifndef _REDLINE_HXX
#include <redline.hxx>
#endif
#ifndef _SECTION_HXX
#include <section.hxx>
#endif
namespace binfilter {

//STRIP001 inline SwDoc& SwUndoIter::GetDoc() const
//STRIP001 { return *pAktPam->GetDoc(); }

// -----------------------------------------------------

/*?*/ _UndoFmtAttr::_UndoFmtAttr( SwFmt& rFmt, BOOL bSvDrwPt )
/*?*/ 	: SwClient( &rFmt ), pUndo( 0 ), bSaveDrawPt( bSvDrwPt )
/*?*/ {
/*?*/ }

/*?*/ void _UndoFmtAttr::Modify( SfxPoolItem* pOld, SfxPoolItem* pNew )
/*?*/ {
/*?*/ 	if( pOld && pNew )
/*?*/ 	{
/*?*/ 		if( POOLATTR_END >= pOld->Which() )
/*?*/ 		{
/*?*/ 			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if( pUndo )
//STRIP001 /*?*/ 				pUndo->PutAttr( *pOld );
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 				pUndo = new SwUndoFmtAttr( *pOld, *(SwFmt*)pRegisteredIn,
//STRIP001 /*?*/ 											bSaveDrawPt );
/*?*/ 		}
/*?*/ 		else if( RES_ATTRSET_CHG == pOld->Which() )
/*?*/ 		{
/*?*/ 			if( pUndo )
/*?*/ 			{
/*?*/ 				SfxItemIter aIter( *((SwAttrSetChg*)pOld)->GetChgSet() );
/*?*/ 				const SfxPoolItem* pItem = aIter.GetCurItem();
/*?*/ 				while( pItem )
/*?*/ 				{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	pUndo->PutAttr( *pItem );
//STRIP001 /*?*/ 					if( aIter.IsAtEnd() )
//STRIP001 /*?*/ 						break;
//STRIP001 /*?*/ 					pItem = aIter.NextItem();
/*?*/ 				}
/*?*/ 			}
/*?*/ 			else
/*?*/ 				pUndo = new SwUndoFmtAttr( *((SwAttrSetChg*)pOld)->GetChgSet(),
/*?*/ 										*(SwFmt*)pRegisteredIn, bSaveDrawPt );
/*?*/ 		}
/*?*/ 		else
/*?*/ 			SwClient::Modify( pOld, pNew );
/*?*/ 	}
/*?*/ 	else
/*?*/ 		SwClient::Modify( pOld, pNew );
/*?*/ }

/*N*/ SwUndoFmtAttr::SwUndoFmtAttr( const SfxItemSet& rSet, SwFmt& rChgFmt,
/*N*/ 								BOOL bSvDrwPt )
/*N*/ 	: SwUndo( UNDO_INSFMTATTR ), pFmt( &rChgFmt ),
/*N*/ 	nFmtWhich( rChgFmt.Which() ), nNode( 0 ), bSaveDrawPt( bSvDrwPt )
/*N*/ {
/*N*/ 	pOldSet = new SfxItemSet( rSet );
/*N*/ 	Init();
/*N*/ }

/*?*/ SwUndoFmtAttr::SwUndoFmtAttr( const SfxPoolItem& rItem, SwFmt& rChgFmt,
/*?*/ 								BOOL bSvDrwPt )
/*?*/ 	: SwUndo( UNDO_INSFMTATTR ), pFmt( &rChgFmt ),
/*?*/ 	nFmtWhich( rChgFmt.Which() ), nNode( 0 ), bSaveDrawPt( bSvDrwPt )
/*?*/ {
/*?*/ 	pOldSet = pFmt->GetAttrSet().Clone( FALSE );
/*?*/ 	pOldSet->Put( rItem );
/*?*/ 	Init();
/*?*/ }

/*N*/ void SwUndoFmtAttr::Init()
/*N*/ {
/*N*/ 	// Ankerwechsel gesondert behandeln
/*N*/ 	if( SFX_ITEM_SET == pOldSet->GetItemState( RES_ANCHOR, FALSE ))
/*N*/ 		SaveFlyAnchor( bSaveDrawPt );
/*N*/ 	else if( RES_FRMFMT == nFmtWhich )
/*N*/ 	{
/*?*/ 		SwDoc* pDoc = pFmt->GetDoc();
/*?*/ 		if( USHRT_MAX !=
/*?*/ 			pDoc->GetTblFrmFmts()->GetPos( (const SwFrmFmtPtr)pFmt ))
/*?*/ 		{
/*?*/ 			// TabellenFormat -> Tabellen Index Position merken, TabellenFormate
/*?*/ 			// 						sind fluechtig!
/*?*/ 			SwClient* pTbl = SwClientIter( *pFmt ).First( TYPE( SwTable ));
/*?*/ 			if( pTbl )
/*?*/ 				nNode = ((SwTable*)pTbl)->GetTabSortBoxes()[ 0 ]->
/*?*/ 							GetSttNd()->FindTableNode()->GetIndex();
/*?*/ 		}
/*?*/ 		else if( USHRT_MAX !=
/*?*/ 			pDoc->GetSections().GetPos( (const SwSectionFmtPtr)pFmt ))
/*?*/ 			nNode = pFmt->GetCntnt().GetCntntIdx()->GetIndex();
/*N*/ 	}
/*N*/ }

/*N*/ SwUndoFmtAttr::~SwUndoFmtAttr()
/*N*/ {
/*N*/ 	delete pOldSet;
/*N*/ }

//STRIP001 void SwUndoFmtAttr::Undo( SwUndoIter& rUndoIter)
//STRIP001 {
//STRIP001 	if( !pOldSet || !pFmt || !IsFmtInDoc( &rUndoIter.GetDoc() ))
//STRIP001 		return;
//STRIP001 
//STRIP001 	if( SFX_ITEM_SET == pOldSet->GetItemState( RES_ANCHOR, FALSE ))
//STRIP001 	{
//STRIP001 		RestoreFlyAnchor( rUndoIter );
//STRIP001 		SaveFlyAnchor();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		_UndoFmtAttr aTmp( *pFmt, bSaveDrawPt );
//STRIP001 		pFmt->SetAttr( *pOldSet );
//STRIP001 		if( aTmp.pUndo )
//STRIP001 		{
//STRIP001 			delete pOldSet;
//STRIP001 			pOldSet = aTmp.pUndo->pOldSet;
//STRIP001 			aTmp.pUndo->pOldSet = 0;    // den Pointer auf 0 setzen (nicht
//STRIP001 										// doppelt loeschen) !!
//STRIP001 			delete aTmp.pUndo;          // Undo-Object wieder loeschen
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pOldSet->ClearItem();
//STRIP001 
//STRIP001 		if( RES_FLYFRMFMT == nFmtWhich || RES_DRAWFRMFMT == nFmtWhich )
//STRIP001 			rUndoIter.pSelFmt = (SwFrmFmt*)pFmt;
//STRIP001 	}
//STRIP001 }

//STRIP001 int SwUndoFmtAttr::IsFmtInDoc( SwDoc* pDoc )
//STRIP001 {
//STRIP001 	// suche im Dokument nach dem Format. Ist es nicht mehr vorhanden
//STRIP001 	// so wird das Attribut nicht mehr gesetzt !
//STRIP001 	USHORT nPos = USHRT_MAX;
//STRIP001 	switch( nFmtWhich )
//STRIP001 	{
//STRIP001 	case RES_TXTFMTCOLL:
//STRIP001 		nPos = pDoc->GetTxtFmtColls()->GetPos(
//STRIP001 										(const SwTxtFmtCollPtr)pFmt );
//STRIP001 		break;
//STRIP001 
//STRIP001 	case RES_GRFFMTCOLL:
//STRIP001 		nPos = pDoc->GetGrfFmtColls()->GetPos(
//STRIP001 										(const SwGrfFmtCollPtr)pFmt );
//STRIP001 		break;
//STRIP001 	case RES_CHRFMT:
//STRIP001 		nPos = pDoc->GetCharFmts()->GetPos(
//STRIP001 									(const SwCharFmtPtr)pFmt );
//STRIP001 		break;
//STRIP001 
//STRIP001 	case RES_FRMFMT:
//STRIP001 		if( nNode && nNode < pDoc->GetNodes().Count() )
//STRIP001 		{
//STRIP001 			SwNode* pNd = pDoc->GetNodes()[ nNode ];
//STRIP001 			if( pNd->IsTableNode() )
//STRIP001 			{
//STRIP001 				pFmt = ((SwTableNode*)pNd)->GetTable().GetFrmFmt();
//STRIP001 				nPos = 0;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 			else if( pNd->IsSectionNode() )
//STRIP001 			{
//STRIP001 				pFmt = ((SwSectionNode*)pNd)->GetSection().GetFmt();
//STRIP001 				nPos = 0;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		// kein break!
//STRIP001 	case RES_DRAWFRMFMT:
//STRIP001 	case RES_FLYFRMFMT:
//STRIP001 		if( USHRT_MAX == ( nPos = pDoc->GetSpzFrmFmts()->GetPos(
//STRIP001 							(const SwFrmFmtPtr)pFmt )) )
//STRIP001 			nPos = pDoc->GetFrmFmts()->GetPos(
//STRIP001 							(const SwFrmFmtPtr)pFmt );
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Format nicht mehr vorhanden, zurueck
//STRIP001 	if( USHRT_MAX == nPos )
//STRIP001 		pFmt = 0;
//STRIP001 
//STRIP001 	return 0 != pFmt;
//STRIP001 }

// prueft, ob es noch im Doc ist!
//STRIP001 SwFmt* SwUndoFmtAttr::GetFmt( SwDoc& rDoc )
//STRIP001 {
//STRIP001 	return pFmt && IsFmtInDoc( &rDoc ) ? pFmt : 0;
//STRIP001 }

//STRIP001 void SwUndoFmtAttr::Redo( SwUndoIter& rUndoIter)
//STRIP001 {
//STRIP001 	if( !pOldSet || !pFmt || !IsFmtInDoc( &rUndoIter.GetDoc() ))
//STRIP001 		return;
//STRIP001 
//STRIP001 	if( SFX_ITEM_SET == pOldSet->GetItemState( RES_ANCHOR, FALSE ))
//STRIP001 	{
//STRIP001 		RestoreFlyAnchor( rUndoIter );
//STRIP001 		SaveFlyAnchor();
//STRIP001 		return;		// der Rest passierte schon im RestoreFlyAnchor !!
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		_UndoFmtAttr aTmp( *pFmt, bSaveDrawPt );
//STRIP001 		pFmt->SetAttr( *pOldSet );
//STRIP001 		if( aTmp.pUndo )
//STRIP001 		{
//STRIP001 			delete pOldSet;
//STRIP001 			pOldSet = aTmp.pUndo->pOldSet;
//STRIP001 			aTmp.pUndo->pOldSet = 0;    // den Pointer auf 0 setzen (nicht
//STRIP001 										// doppelt loeschen) !!
//STRIP001 			delete aTmp.pUndo;          // Undo-Object wieder loeschen
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pOldSet->ClearItem();
//STRIP001 
//STRIP001 		if( RES_FLYFRMFMT == nFmtWhich || RES_DRAWFRMFMT == nFmtWhich )
//STRIP001 			rUndoIter.pSelFmt = (SwFrmFmt*)pFmt;
//STRIP001 	}
//STRIP001 }

//STRIP001 void SwUndoFmtAttr::Repeat( SwUndoIter& rUndoIter)
//STRIP001 {
//STRIP001 	if( !pOldSet )
//STRIP001 		return;
//STRIP001 
//STRIP001 	SwUndoFmtAttr* pLast;
//STRIP001 	if( UNDO_INSFMTATTR == rUndoIter.GetLastUndoId() &&
//STRIP001 		( pLast = ((SwUndoFmtAttr*)rUndoIter.pLastUndoObj))->pOldSet &&
//STRIP001 		pLast->pFmt )
//STRIP001 		return;
//STRIP001 
//STRIP001 	switch( nFmtWhich )
//STRIP001 	{
//STRIP001 	case RES_GRFFMTCOLL:
//STRIP001 		{
//STRIP001 			SwNoTxtNode * pNd = rUndoIter.pAktPam->GetNode()->GetNoTxtNode();
//STRIP001 			if( pNd )
//STRIP001 				rUndoIter.GetDoc().SetAttr( pFmt->GetAttrSet(),
//STRIP001 											*pNd->GetFmtColl() );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case RES_TXTFMTCOLL:
//STRIP001 		{
//STRIP001 			SwTxtNode * pNd = rUndoIter.pAktPam->GetNode()->GetTxtNode();
//STRIP001 			if( pNd )
//STRIP001 				rUndoIter.GetDoc().SetAttr( pFmt->GetAttrSet(),
//STRIP001 											*pNd->GetFmtColl() );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 //	case RES_CHRFMT:
//STRIP001 //	case RES_FRMFMT:
//STRIP001 
//STRIP001 	case RES_FLYFRMFMT:
//STRIP001 		{
//STRIP001 			// erstal pruefen, ob der Cursor ueberhaupt in einem fliegenden
//STRIP001 			// Rahmen steht. Der Weg ist: suche in allen FlyFrmFormaten
//STRIP001 			// nach dem FlyCntnt-Attribut und teste ob der Cursor in der
//STRIP001 			// entsprechenden Section liegt.
//STRIP001 			SwFrmFmt* pFly = rUndoIter.pAktPam->GetNode()->GetFlyFmt();
//STRIP001 			if( pFly )
//STRIP001 			{
//STRIP001 				// Bug 43672: es duerfen nicht alle Attribute gesetzt werden!
//STRIP001 				if( SFX_ITEM_SET == pFmt->GetAttrSet().GetItemState( RES_CNTNT ))
//STRIP001 				{
//STRIP001 					SfxItemSet aTmpSet( pFmt->GetAttrSet() );
//STRIP001 					aTmpSet.ClearItem( RES_CNTNT );
//STRIP001 					if( aTmpSet.Count() )
//STRIP001 						rUndoIter.GetDoc().SetAttr( aTmpSet, *pFly );
//STRIP001 				}
//STRIP001 				else
//STRIP001 					rUndoIter.GetDoc().SetAttr( pFmt->GetAttrSet(), *pFly );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	rUndoIter.pLastUndoObj = this;
//STRIP001 }

//STRIP001 void SwUndoFmtAttr::PutAttr( const SfxPoolItem& rItem )
//STRIP001 {
//STRIP001 	pOldSet->Put( rItem );
//STRIP001 	if( RES_ANCHOR == rItem.Which() )
//STRIP001 		SaveFlyAnchor( bSaveDrawPt );
//STRIP001 }

/*N*/ void SwUndoFmtAttr::SaveFlyAnchor( BOOL bSvDrwPt )
/*N*/ {
/*N*/ 	// das Format ist gueltig, sonst wuerde man gar bis hier kommen
/*N*/ 	if( bSvDrwPt )
/*N*/ 	{
/*N*/ 		if( RES_DRAWFRMFMT == pFmt->Which() )
/*N*/ 		{
/*?*/ 			Point aPt( ((SwFrmFmt*)pFmt)->FindSdrObject()->GetRelativePos() );
/*?*/ 			// den alten Wert als zwischenspeichern. Attribut dafuer benutzen,
/*?*/ 			// dadurch bleibt der SwUndoFmtAttr klein.
/*?*/ 			pOldSet->Put( SwFmtFrmSize( ATT_VAR_SIZE, aPt.X(), aPt.Y() ) );
/*N*/ 		}
/*		else
		{
			pOldSet->Put( pFmt->GetVertOrient() );
			pOldSet->Put( pFmt->GetHoriOrient() );
		}
*/	}

/*N*/ 	const SwFmtAnchor& rAnchor = (SwFmtAnchor&)pOldSet->Get(
/*N*/ 												RES_ANCHOR, FALSE );
/*N*/ 	if( !rAnchor.GetCntntAnchor() )
/*N*/ 		return;
/*N*/ 
/*N*/ 	xub_StrLen nCntnt = 0;
/*N*/ 	switch( rAnchor.GetAnchorId() )
/*N*/ 	{
/*N*/ 	case FLY_IN_CNTNT:
/*N*/ 	case FLY_AUTO_CNTNT:
/*N*/ 		nCntnt = rAnchor.GetCntntAnchor()->nContent.GetIndex();
/*N*/ 	case FLY_AT_CNTNT:
/*N*/ 	case FLY_AT_FLY:
/*N*/ 		nNode = rAnchor.GetCntntAnchor()->nNode.GetIndex();
/*N*/ 		break;
/*N*/ 	default:
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	SwFmtAnchor aAnchor( rAnchor.GetAnchorId(), nCntnt );
/*N*/ 	pOldSet->Put( aAnchor );
/*N*/ }

//STRIP001 void SwUndoFmtAttr::RestoreFlyAnchor( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwDoc* pDoc = &rIter.GetDoc();
//STRIP001 	SwFlyFrmFmt* pFrmFmt = (SwFlyFrmFmt*)pFmt;
//STRIP001 	const SwFmtAnchor& rAnchor = (SwFmtAnchor&)pOldSet->Get(
//STRIP001 												RES_ANCHOR, FALSE );
//STRIP001 
//STRIP001 	SwFmtAnchor aNewAnchor( rAnchor.GetAnchorId() );
//STRIP001 	if( FLY_PAGE != rAnchor.GetAnchorId() )
//STRIP001 	{
//STRIP001 		SwNode* pNd = pDoc->GetNodes()[ nNode  ];
//STRIP001 
//STRIP001 		if( FLY_AT_FLY == rAnchor.GetAnchorId() ? ( !pNd->IsStartNode() ||
//STRIP001 			SwFlyStartNode != ((SwStartNode*)pNd)->GetStartNodeType() ) :
//STRIP001 			!pNd->IsTxtNode() )
//STRIP001 			return; 	// ungueltige Position
//STRIP001 
//STRIP001 		SwPosition aPos( *pNd );
//STRIP001 		if( FLY_IN_CNTNT == rAnchor.GetAnchorId() ||
//STRIP001 			FLY_AUTO_CNTNT == rAnchor.GetAnchorId() )
//STRIP001 		{
//STRIP001 			aPos.nContent.Assign( (SwTxtNode*)pNd, rAnchor.GetPageNum() );
//STRIP001 			if( aPos.nContent.GetIndex() > ((SwTxtNode*)pNd)->GetTxt().Len() )
//STRIP001 				return; 	// ungueltige Position
//STRIP001 		}
//STRIP001 		aNewAnchor.SetAnchor( &aPos );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aNewAnchor.SetPageNum( rAnchor.GetPageNum() );
//STRIP001 
//STRIP001 	Point aDrawSavePt, aDrawOldPt;
//STRIP001 	if( pDoc->GetRootFrm() )
//STRIP001 	{
//STRIP001 		if( RES_DRAWFRMFMT == pFrmFmt->Which() )
//STRIP001 		{
//STRIP001 			// den alten zwischengespeicherten Wert herausholen.
//STRIP001 			const SwFmtFrmSize& rOldSize = (const SwFmtFrmSize&)
//STRIP001 											pOldSet->Get( RES_FRM_SIZE );
//STRIP001 			aDrawSavePt.X() = rOldSize.GetWidth();
//STRIP001 			aDrawSavePt.Y() = rOldSize.GetHeight();
//STRIP001 			pOldSet->ClearItem( RES_FRM_SIZE );
//STRIP001 
//STRIP001 			// den akt. wieder zwischenspeichern
//STRIP001 			aDrawOldPt = pFrmFmt->FindSdrObject()->GetRelativePos();
//STRIP001 //JP 08.10.97: ist laut AMA/MA nicht mehr noetig
//STRIP001 //			pCont->DisconnectFromLayout();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pFrmFmt->DelFrms(); 		// Frms vernichten.
//STRIP001 	}
//STRIP001 
//STRIP001 	const SwFmtAnchor &rOldAnch = pFrmFmt->GetAnchor();
//STRIP001 	if( FLY_IN_CNTNT == rOldAnch.GetAnchorId() &&
//STRIP001 		FLY_IN_CNTNT != aNewAnchor.GetAnchorId() )
//STRIP001 	{
//STRIP001 		//Bei InCntnt's wird es spannend: Das TxtAttribut muss vernichtet
//STRIP001 		//werden. Leider reisst dies neben den Frms auch noch das Format mit
//STRIP001 		//in sein Grab. Um dass zu unterbinden loesen wir vorher die
//STRIP001 		//Verbindung zwischen Attribut und Format.
//STRIP001 		const SwPosition *pPos = rOldAnch.GetCntntAnchor();
//STRIP001 		SwTxtNode *pTxtNode = (SwTxtNode*)&pPos->nNode.GetNode();
//STRIP001 		ASSERT( pTxtNode->HasHints(), "Missing FlyInCnt-Hint." );
//STRIP001 		const xub_StrLen nIdx = pPos->nContent.GetIndex();
//STRIP001 		SwTxtAttr * pHnt = pTxtNode->GetTxtAttr( nIdx, RES_TXTATR_FLYCNT );
//STRIP001 #ifndef PRODUCT
//STRIP001 		ASSERT( pHnt && pHnt->Which() == RES_TXTATR_FLYCNT,
//STRIP001 					"Missing FlyInCnt-Hint." );
//STRIP001 		ASSERT( pHnt && pHnt->GetFlyCnt().GetFrmFmt() == pFrmFmt,
//STRIP001 					"Wrong TxtFlyCnt-Hint." );
//STRIP001 #endif
//STRIP001 		((SwFmtFlyCnt&)pHnt->GetFlyCnt()).SetFlyFmt();
//STRIP001 
//STRIP001 		//Die Verbindung ist geloest, jetzt muss noch das Attribut vernichtet
//STRIP001 		//werden.
//STRIP001 		pTxtNode->Delete( RES_TXTATR_FLYCNT, nIdx, nIdx );
//STRIP001 	}
//STRIP001 
//STRIP001 	{
//STRIP001 		pOldSet->Put( aNewAnchor );
//STRIP001 		_UndoFmtAttr aTmp( *pFmt, bSaveDrawPt );
//STRIP001 		pFmt->SetAttr( *pOldSet );
//STRIP001 		if( aTmp.pUndo )
//STRIP001 		{
//STRIP001 			delete pOldSet;
//STRIP001 			nNode = aTmp.pUndo->nNode;
//STRIP001 			pOldSet = aTmp.pUndo->pOldSet;
//STRIP001 			aTmp.pUndo->pOldSet = 0;    // den Pointer auf 0 setzen (nicht
//STRIP001 										// doppelt loeschen) !!
//STRIP001 			delete aTmp.pUndo;          // Undo-Object wieder loeschen
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pOldSet->ClearItem();
//STRIP001 	}
//STRIP001 
//STRIP001 	if( RES_DRAWFRMFMT == pFrmFmt->Which() )
//STRIP001 	{
//STRIP001 		SwDrawContact *pCont = (SwDrawContact*)pFrmFmt->FindContactObj();
//STRIP001 		// das Draw-Model hat auch noch ein Undo-Object fuer die
//STRIP001 		// richtige Position vorbereitet; dieses ist aber relativ.
//STRIP001 		// Darum verhinder hier, das durch setzen des Ankers das
//STRIP001 		// Contact-Object seine Position aendert.
//STRIP001 //JP 08.10.97: ist laut AMA/MA nicht mehr noetig
//STRIP001 //			pCont->ConnectToLayout();
//STRIP001 		SdrObject* pObj = pCont->GetMaster();
//STRIP001 
//STRIP001 		if( pCont->GetAnchor() && !pObj->IsInserted() )
//STRIP001 		{
//STRIP001 			ASSERT( pDoc->GetDrawModel(), "RestoreFlyAnchor without DrawModel" );
//STRIP001 			pDoc->GetDrawModel()->GetPage( 0 )->InsertObject( pObj );
//STRIP001 		}
//STRIP001 		pObj->SetRelativePos( aDrawSavePt );
//STRIP001 
//STRIP001 		// den alten Wert wieder zwischenspeichern.
//STRIP001 		pOldSet->Put( SwFmtFrmSize( ATT_VAR_SIZE, aDrawOldPt.X(), aDrawOldPt.Y() ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( FLY_IN_CNTNT == aNewAnchor.GetAnchorId() )
//STRIP001 	{
//STRIP001 		const SwPosition* pPos = aNewAnchor.GetCntntAnchor();
//STRIP001 		SwTxtNode* pTxtNd = pPos->nNode.GetNode().GetTxtNode();
//STRIP001 		ASSERT( pTxtNd, "Kein Textnode an dieser Position" );
//STRIP001 		pTxtNd->Insert( SwFmtFlyCnt( pFrmFmt ), pPos->nContent.GetIndex(), 0 );
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	if( RES_DRAWFRMFMT != pFrmFmt->Which() )
//STRIP001 		pFrmFmt->MakeFrms();
//STRIP001 
//STRIP001 	rIter.pSelFmt = pFrmFmt;
//STRIP001 }

/*  */

//STRIP001 SwUndoRstAttr::SwUndoRstAttr( const SwPaM& rRange, USHORT nFmt )
//STRIP001 	: SwUndo( UNDO_RESETATTR ), SwUndRng( rRange ), nFmtId( nFmt ),
//STRIP001 	pHistory( new SwHistory )
//STRIP001 {
//STRIP001 #ifdef COMPACT
//STRIP001 	((SwDoc*)rRange.GetDoc())->DelUndoGroups();
//STRIP001 #endif
//STRIP001 }

//STRIP001 SwUndoRstAttr::SwUndoRstAttr( const SwDoc& rDoc, const SwPosition& rPos,
//STRIP001 								USHORT nWhich )
//STRIP001 	: SwUndo( UNDO_RESETATTR ), nFmtId( nWhich ), pHistory( new SwHistory )
//STRIP001 {
//STRIP001 	nSttNode = nEndNode = rPos.nNode.GetIndex();
//STRIP001 	nSttCntnt = nEndCntnt = rPos.nContent.GetIndex();
//STRIP001 }

//STRIP001 SwUndoRstAttr::~SwUndoRstAttr()
//STRIP001 {
//STRIP001 	delete pHistory;
//STRIP001 }

//STRIP001 void SwUndoRstAttr::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	// die alten Werte wieder zurueck
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	pHistory->TmpRollback( &rDoc, 0 );
//STRIP001 	pHistory->SetTmpEnd( pHistory->Count() );
//STRIP001 
//STRIP001 	if( RES_CONDTXTFMTCOLL == nFmtId && nSttNode == nEndNode &&
//STRIP001 		nSttCntnt == nEndCntnt )
//STRIP001 	{
//STRIP001 		SwTxtNode* pTNd = rDoc.GetNodes()[ nSttNode ]->GetTxtNode();
//STRIP001 		if( pTNd )
//STRIP001 		{
//STRIP001 			SwIndex aIdx( pTNd, nSttCntnt );
//STRIP001 			pTNd->DontExpandFmt( aIdx, FALSE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// setze noch den Cursor auf den Undo-Bereich
//STRIP001 	SetPaM( rUndoIter );
//STRIP001 }

//STRIP001 void SwUndoRstAttr::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	// setze Attribut in dem Bereich:
//STRIP001 	SetPaM( rUndoIter );
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	rUndoIter.pLastUndoObj = 0;
//STRIP001 	SvUShortsSort* pIdArr = aIds.Count() ? &aIds : 0;
//STRIP001 
//STRIP001 	switch( nFmtId )
//STRIP001 	{
//STRIP001 	case RES_CHRFMT:
//STRIP001 		rUndoIter.GetDoc().RstTxtAttr( *rUndoIter.pAktPam );
//STRIP001 		break;
//STRIP001 	case RES_TXTFMTCOLL:
//STRIP001 		rUndoIter.GetDoc().ResetAttr( *rUndoIter.pAktPam, FALSE, pIdArr );
//STRIP001 		break;
//STRIP001 	case RES_CONDTXTFMTCOLL:
//STRIP001 		rUndoIter.GetDoc().ResetAttr( *rUndoIter.pAktPam, TRUE, pIdArr );
//STRIP001 
//STRIP001 		break;
//STRIP001 	case RES_TXTATR_TOXMARK:
//STRIP001 		// Sonderbehandlung fuer TOXMarks
//STRIP001 		{
//STRIP001 			SwTOXMarks aArr;
//STRIP001 			SwNodeIndex aIdx( rDoc.GetNodes(), nSttNode );
//STRIP001 			SwPosition aPos( aIdx, SwIndex( aIdx.GetNode().GetCntntNode(),
//STRIP001 																nSttCntnt ));
//STRIP001 
//STRIP001 			USHORT nCnt = rDoc.GetCurTOXMark( aPos, aArr );
//STRIP001 			if( nCnt )
//STRIP001 			{
//STRIP001 				if( 1 < nCnt )
//STRIP001 				{
//STRIP001 					// dann den richtigen suchen
//STRIP001 					SwHstryHint* pHHint = (*GetHistory())[ 0 ];
//STRIP001 					if( pHHint && HSTRY_SETTOXMARKHNT == pHHint->Which() )
//STRIP001 					{
//STRIP001 						while( nCnt )
//STRIP001 							if( ((SwSetTOXMarkHint*)pHHint)->IsEqual(
//STRIP001 									*aArr[ --nCnt ] ) )
//STRIP001 							{
//STRIP001 								++nCnt;
//STRIP001 								break;
//STRIP001 							}
//STRIP001 					}
//STRIP001 					else
//STRIP001 						nCnt = 0;
//STRIP001 				}
//STRIP001 				// gefunden, also loeschen
//STRIP001 				if( nCnt-- )
//STRIP001 					rDoc.Delete( aArr[ nCnt ] );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	rUndoIter.pLastUndoObj = 0;
//STRIP001 }

//STRIP001 void SwUndoRstAttr::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	if( RES_FMT_BEGIN > nFmtId ||
//STRIP001 		( UNDO_RESETATTR == rUndoIter.GetLastUndoId() &&
//STRIP001 		 nFmtId == ((SwUndoRstAttr*)rUndoIter.pLastUndoObj)->nFmtId ))
//STRIP001 		return;
//STRIP001 
//STRIP001 	SvUShortsSort* pIdArr = aIds.Count() ? &aIds : 0;
//STRIP001 	switch( nFmtId )
//STRIP001 	{
//STRIP001 	case RES_CHRFMT:
//STRIP001 		rUndoIter.GetDoc().RstTxtAttr( *rUndoIter.pAktPam );
//STRIP001 		break;
//STRIP001 	case RES_TXTFMTCOLL:
//STRIP001 		rUndoIter.GetDoc().ResetAttr( *rUndoIter.pAktPam, FALSE, pIdArr );
//STRIP001 		break;
//STRIP001 	case RES_CONDTXTFMTCOLL:
//STRIP001 		rUndoIter.GetDoc().ResetAttr( *rUndoIter.pAktPam, TRUE, pIdArr );
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	rUndoIter.pLastUndoObj = this;
//STRIP001 }


//STRIP001 void SwUndoRstAttr::SetAttrs( const SvUShortsSort& rArr )
//STRIP001 {
//STRIP001 	if( aIds.Count() )
//STRIP001 		aIds.Remove( 0, aIds.Count() );
//STRIP001 	aIds.Insert( &rArr );
//STRIP001 }

// -----------------------------------------------------



/*N*/ SwUndoAttr::SwUndoAttr( const SwPaM& rRange, const SfxPoolItem& rAttr,
/*N*/ 						USHORT nFlags )
/*N*/ 	: SwUndo( UNDO_INSATTR ), SwUndRng( rRange ),
/*N*/ 	aSet( rRange.GetDoc()->GetAttrPool(), rAttr.Which(), rAttr.Which() ),
/*N*/ 	nInsFlags( nFlags ), pHistory( new SwHistory ),
/*N*/ 	pRedlData( 0 ), pRedlSaveData( 0 ),
/*N*/ 	nNdIdx( ULONG_MAX )
/*N*/ {
/*N*/ 	aSet.Put( rAttr );
/*N*/ #ifdef COMPACT
/*N*/ 	(SwDoc*)rRange.GetDoc()->DelUndoGroups();
/*N*/ #endif
/*N*/ }

/*N*/ SwUndoAttr::SwUndoAttr( const SwPaM& rRange, const SfxItemSet& rSet,
/*N*/ 						USHORT nFlags )
/*N*/ 	: SwUndo( UNDO_INSATTR ), SwUndRng( rRange ), aSet( rSet ),
/*N*/ 	nInsFlags( nFlags ), pHistory( new SwHistory ),
/*N*/ 	pRedlData( 0 ), pRedlSaveData( 0 ),
/*N*/ 	nNdIdx( ULONG_MAX )
/*N*/ {
/*N*/ #ifdef COMPACT
/*?*/ 	(SwDoc*)rRange.GetDoc()->DelUndoGroups();
/*N*/ #endif
/*N*/ }

/*N*/ SwUndoAttr::~SwUndoAttr()
/*N*/ {
/*N*/ 	delete pHistory;
//STRIP001 /*?*/ 	delete pRedlData;
/*N*/ 	delete pRedlSaveData;
/*N*/ }

//STRIP001 void SwUndoAttr::SaveRedlineData( const SwPaM& rPam, BOOL bIsCntnt )
//STRIP001 {
//STRIP001 	SwDoc* pDoc = rPam.GetDoc();
//STRIP001 	if( pDoc->IsRedlineOn() )
//STRIP001 		pRedlData = new SwRedlineData( bIsCntnt ? REDLINE_INSERT
//STRIP001 												: REDLINE_FORMAT,
//STRIP001 										pDoc->GetRedlineAuthor() );
//STRIP001 
//STRIP001 	pRedlSaveData = new SwRedlineSaveDatas;
//STRIP001 	if( !FillSaveDataForFmt( rPam, *pRedlSaveData ))
//STRIP001 		delete pRedlSaveData, pRedlSaveData = 0;
//STRIP001 
//STRIP001 	SetRedlineMode( pDoc->GetRedlineMode() );
//STRIP001 	if( bIsCntnt )
//STRIP001 		nNdIdx = rPam.GetPoint()->nNode.GetIndex();
//STRIP001 }

//STRIP001 void SwUndoAttr::Undo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwDoc* pDoc = &rUndoIter.GetDoc();
//STRIP001 
//STRIP001 	RemoveIdx( *pDoc );
//STRIP001 
//STRIP001 	if( IsRedlineOn( GetRedlineMode() ) )
//STRIP001 	{
//STRIP001 		SwPaM& rPam = *rUndoIter.pAktPam;
//STRIP001 		if( ULONG_MAX != nNdIdx )
//STRIP001 		{
//STRIP001 			rPam.DeleteMark();
//STRIP001 			rPam.GetPoint()->nNode = nNdIdx;
//STRIP001 			rPam.GetPoint()->nContent.Assign( rPam.GetCntntNode(), nSttCntnt );
//STRIP001 			rPam.SetMark();
//STRIP001 			rPam.GetPoint()->nContent++;
//STRIP001 			pDoc->DeleteRedline( rPam, FALSE );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// alle Format-Redlines entfernen, werden ggfs. neu gesetzt
//STRIP001 			SetPaM( rUndoIter );
//STRIP001 			pDoc->DeleteRedline( rPam, FALSE, REDLINE_FORMAT );
//STRIP001 			if( pRedlSaveData )
//STRIP001 				SetSaveData( *pDoc, *pRedlSaveData );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bToLast = 1 == aSet.Count() &&
//STRIP001 				   RES_TXTATR_FIELD	<= *aSet.GetRanges() &&
//STRIP001 				   *aSet.GetRanges() <= RES_TXTATR_HARDBLANK;
//STRIP001 
//STRIP001 	// die alten Werte wieder zurueck
//STRIP001 	pHistory->TmpRollback( pDoc, 0, !bToLast );
//STRIP001 	pHistory->SetTmpEnd( pHistory->Count() );
//STRIP001 
//STRIP001 	// setze noch den Cursor auf den Undo-Bereich
//STRIP001 	SetPaM( rUndoIter );
//STRIP001 }

//STRIP001 int lcl_HasEqualItems( const SfxItemSet& rSet1, const SfxItemSet& rSet2 )
//STRIP001 {
//STRIP001 	int nRet = -1;
//STRIP001 	SfxItemIter aIter1( rSet1 ), aIter2( rSet2 );
//STRIP001 	const SfxPoolItem *pI1 = aIter1.FirstItem(), *pI2 = aIter2.FirstItem();
//STRIP001 
//STRIP001 	while( pI1 && pI2 )
//STRIP001 	{
//STRIP001 		if( pI1->Which() != pI2->Which() ||
//STRIP001 			aIter1.IsAtEnd() != aIter2.IsAtEnd() )
//STRIP001 		{
//STRIP001 			nRet = 0;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		if( aIter1.IsAtEnd() )
//STRIP001 			break;
//STRIP001 		pI1 = aIter1.NextItem();
//STRIP001 		pI2 = aIter2.NextItem();
//STRIP001 	}
//STRIP001 	return nRet;
//STRIP001 }

//STRIP001 void SwUndoAttr::Repeat( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	SwUndoAttr* pLast;
//STRIP001 	if( UNDO_INSATTR == rUndoIter.GetLastUndoId() &&
//STRIP001 		( pLast = ((SwUndoAttr*)rUndoIter.pLastUndoObj))->aSet.Count() ==
//STRIP001 		aSet.Count() && pLast->nInsFlags == nInsFlags &&
//STRIP001 		lcl_HasEqualItems( aSet, pLast->aSet ))
//STRIP001 		return;
//STRIP001 
//STRIP001 
//STRIP001 	// RefMarks sind nicht repeatfaehig
//STRIP001 	if( SFX_ITEM_SET != aSet.GetItemState( RES_TXTATR_REFMARK, FALSE ) )
//STRIP001 		rUndoIter.GetDoc().Insert( *rUndoIter.pAktPam, aSet, nInsFlags );
//STRIP001 	else if( 1 < aSet.Count() )
//STRIP001 	{
//STRIP001 		SfxItemSet aTmpSet( aSet );
//STRIP001 		aTmpSet.ClearItem( RES_TXTATR_REFMARK );
//STRIP001 		rUndoIter.GetDoc().Insert( *rUndoIter.pAktPam, aTmpSet, nInsFlags );
//STRIP001 	}
//STRIP001 	rUndoIter.pLastUndoObj = this;
//STRIP001 }

//STRIP001 void SwUndoAttr::Redo( SwUndoIter& rUndoIter )
//STRIP001 {
//STRIP001 	// setze Attribut in dem Bereich:
//STRIP001 	SetPaM( rUndoIter );
//STRIP001 	SwPaM& rPam = *rUndoIter.pAktPam;
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 
//STRIP001 	if( pRedlData && IsRedlineOn( GetRedlineMode() ) )
//STRIP001 	{
//STRIP001 		SwRedlineMode eOld = rDoc.GetRedlineMode();
//STRIP001 		rDoc.SetRedlineMode_intern( eOld & ~REDLINE_IGNORE );
//STRIP001 		rDoc.Insert( rPam, aSet, nInsFlags );
//STRIP001 
//STRIP001 		if( ULONG_MAX != nNdIdx )
//STRIP001 		{
//STRIP001 			rPam.SetMark();
//STRIP001 			if( rPam.Move( fnMoveBackward ) )
//STRIP001 				rDoc.AppendRedline( new SwRedline( *pRedlData, rPam ));
//STRIP001 			rPam.DeleteMark();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			rDoc.AppendRedline( new SwRedline( *pRedlData, rPam ));
//STRIP001 
//STRIP001 		rDoc.SetRedlineMode_intern( eOld );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		rDoc.Insert( rPam, aSet, nInsFlags );
//STRIP001 
//STRIP001 	rUndoIter.pLastUndoObj = 0;
//STRIP001 }


//STRIP001 void SwUndoAttr::RemoveIdx( SwDoc& rDoc )
//STRIP001 {
//STRIP001 	if( SFX_ITEM_SET != aSet.GetItemState( RES_TXTATR_FTN, FALSE ))
//STRIP001 		return ;
//STRIP001 
//STRIP001 	SwHstryHint* pHstHnt;
//STRIP001 	SwNodes& rNds = rDoc.GetNodes();
//STRIP001 	for( USHORT n = 0; n < pHistory->Count(); ++n )
//STRIP001 	{
//STRIP001 		xub_StrLen nCntnt;
//STRIP001 		ULONG nNode = 0;
//STRIP001 		switch( ( pHstHnt = (*pHistory)[ n ] )->Which() )
//STRIP001 		{
//STRIP001 		case HSTRY_RESETTXTHNT:
//STRIP001 			if( RES_TXTATR_FTN == ((SwResetTxtHint*)pHstHnt)->GetWhich() )
//STRIP001 			{
//STRIP001 				nNode = ((SwResetTxtHint*)pHstHnt)->GetNode();
//STRIP001 				nCntnt = ((SwResetTxtHint*)pHstHnt)->GetCntnt();
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case HSTRY_RESETATTRSET:
//STRIP001 			if( STRING_MAXLEN != ( nCntnt =
//STRIP001 								((SwHstryResetAttrSet*)pHstHnt)->GetCntnt() ))
//STRIP001 			{
//STRIP001 				const SvUShorts& rArr = ((SwHstryResetAttrSet*)pHstHnt)->GetArr();
//STRIP001 				for( USHORT i = rArr.Count(); i; )
//STRIP001 					if( RES_TXTATR_FTN == rArr[ --i ] )
//STRIP001 					{
//STRIP001 						nNode = ((SwHstryResetAttrSet*)pHstHnt)->GetNode();
//STRIP001 						break;
//STRIP001 					}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( nNode )
//STRIP001 		{
//STRIP001 			SwTxtNode* pTxtNd = rNds[ nNode ]->GetTxtNode();
//STRIP001 			if( pTxtNd )
//STRIP001 			{
//STRIP001 				SwIndex aIdx( pTxtNd, nCntnt );
//STRIP001 				SwTxtAttr * pTxtHt = pTxtNd->GetTxtAttr( aIdx, RES_TXTATR_FTN );
//STRIP001 				if( pTxtHt )
//STRIP001 				{
//STRIP001 					// ok, dann hole mal die Werte
//STRIP001 					SwTxtFtn* pFtn = (SwTxtFtn*)pTxtHt;
//STRIP001 					RemoveIdxFromSection( rDoc, pFtn->GetStartNode()->GetIndex() );
//STRIP001 					return ;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*  */

/*N*/ SwUndoDefaultAttr::SwUndoDefaultAttr( const SfxItemSet& rSet )
/*N*/ 	: SwUndo( UNDO_SETDEFTATTR ), pOldSet( 0 ), pTabStop( 0 )
/*N*/ {
/*N*/ 	const SfxPoolItem* pItem;
/*N*/ 	if( rSet.GetItemState( RES_PARATR_TABSTOP, FALSE, &pItem ) )
/*N*/ 	{
/*N*/ 		pTabStop = (SvxTabStopItem*)pItem->Clone();		// gesondert merken, aendert sich !!!
/*N*/ 		if( 1 != rSet.Count() )			// gibts noch mehr Attribute ?
/*?*/ 			pOldSet = new SfxItemSet( rSet );
/*N*/ 	}
/*N*/ 	else
/*N*/ 		pOldSet = new SfxItemSet( rSet );
/*N*/ }

/*N*/ SwUndoDefaultAttr::~SwUndoDefaultAttr()
/*N*/ {
/*N*/ 	if( pOldSet )
/*N*/ 		delete pOldSet;
/*N*/ 	if( pTabStop )
/*N*/ 		delete pTabStop;
/*N*/ }

//STRIP001 void SwUndoDefaultAttr::Undo( SwUndoIter& rUndoIter)
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rUndoIter.GetDoc();
//STRIP001 	if( pOldSet )
//STRIP001 	{
//STRIP001 		_UndoFmtAttr aTmp( *(SwTxtFmtColl*)rDoc.GetDfltTxtFmtColl() );
//STRIP001 		rDoc.SetDefault( *pOldSet );
//STRIP001 		delete pOldSet;
//STRIP001 		if( aTmp.pUndo )
//STRIP001 		{
//STRIP001 			pOldSet = aTmp.pUndo->pOldSet;
//STRIP001 			aTmp.pUndo->pOldSet = 0;    // den Pointer auf 0 setzen (nicht
//STRIP001 										// doppelt loeschen) !!
//STRIP001 			delete aTmp.pUndo;          // Undo-Object wieder loeschen
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pOldSet = 0;
//STRIP001 	}
//STRIP001 	if( pTabStop )
//STRIP001 	{
//STRIP001 		SvxTabStopItem* pOld = (SvxTabStopItem*)rDoc.GetDefault(
//STRIP001 												RES_PARATR_TABSTOP ).Clone();
//STRIP001 		rDoc.SetDefault( *pTabStop );
//STRIP001 		delete pTabStop;
//STRIP001 		pTabStop = pOld;
//STRIP001 	}
//STRIP001 }

//STRIP001 void SwUndoDefaultAttr::Redo( SwUndoIter& rUndoIter)
//STRIP001 {
//STRIP001 	Undo( rUndoIter );
//STRIP001 }

/*  */

//STRIP001 SwUndoMoveLeftMargin::SwUndoMoveLeftMargin( const SwPaM& rPam, BOOL bFlag,
//STRIP001 											BOOL bMod )
//STRIP001 	: SwUndo( bFlag ? UNDO_INC_LEFTMARGIN : UNDO_DEC_LEFTMARGIN ),
//STRIP001 	SwUndRng( rPam ), bModulus( bMod )
//STRIP001 {
//STRIP001 	pHistory = new SwHistory;
//STRIP001 }

//STRIP001 SwUndoMoveLeftMargin::~SwUndoMoveLeftMargin()
//STRIP001 {
//STRIP001 	delete pHistory;
//STRIP001 }

//STRIP001 void SwUndoMoveLeftMargin::Undo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwDoc* pDoc = &rIter.GetDoc();
//STRIP001 	BOOL bUndo = pDoc->DoesUndo();
//STRIP001 	pDoc->DoUndo( FALSE );
//STRIP001 
//STRIP001 	// die alten Werte wieder zurueck
//STRIP001 	pHistory->TmpRollback( pDoc, 0 );
//STRIP001 	pHistory->SetTmpEnd( pHistory->Count() );
//STRIP001 
//STRIP001 	pDoc->DoUndo( bUndo );
//STRIP001 	SetPaM( rIter );
//STRIP001 }

//STRIP001 void SwUndoMoveLeftMargin::Redo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwDoc* pDoc = &rIter.GetDoc();
//STRIP001 	SetPaM( rIter );
//STRIP001 	pDoc->MoveLeftMargin( *rIter.pAktPam, GetId() == UNDO_INC_LEFTMARGIN, bModulus );
//STRIP001 }

//STRIP001 void SwUndoMoveLeftMargin::Repeat( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwDoc* pDoc = &rIter.GetDoc();
//STRIP001 	pDoc->MoveLeftMargin( *rIter.pAktPam, GetId() == UNDO_INC_LEFTMARGIN, bModulus );
//STRIP001 	rIter.pLastUndoObj = this;
//STRIP001 }

/*  */

/*N*/ SwUndoChgFtn::SwUndoChgFtn( const SwPaM& rRange, const String& rTxt,
/*N*/ 							USHORT nNum, BOOL bIsEndNote )
/*N*/ 	: SwUndo( UNDO_CHGFTN ), SwUndRng( rRange ),
/*N*/ 	sTxt( rTxt ), nNo( nNum ), bEndNote( bIsEndNote ),
/*N*/ 	pHistory( new SwHistory() )
/*N*/ {
/*N*/ }

/*N*/ SwUndoChgFtn::~SwUndoChgFtn()
/*N*/ {
/*N*/ 	delete pHistory;
/*N*/ }

//STRIP001 void SwUndoChgFtn::Undo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rIter.GetDoc();
//STRIP001 	SetPaM( rIter );
//STRIP001 
//STRIP001 	BOOL bUndo = rDoc.DoesUndo();
//STRIP001 	rDoc.DoUndo( FALSE );
//STRIP001 
//STRIP001 	pHistory->TmpRollback( &rDoc, 0 );
//STRIP001 	pHistory->SetTmpEnd( pHistory->Count() );
//STRIP001 
//STRIP001 	rDoc.GetFtnIdxs().UpdateAllFtn();
//STRIP001 
//STRIP001 	SetPaM( rIter );
//STRIP001 	rDoc.DoUndo( bUndo );
//STRIP001 }

//STRIP001 void SwUndoChgFtn::Redo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SetPaM( rIter );
//STRIP001 	rIter.GetDoc().SetCurFtn( *rIter.pAktPam, sTxt, nNo, bEndNote );
//STRIP001 	SetPaM( rIter );
//STRIP001 }

//STRIP001 void SwUndoChgFtn::Repeat( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwDoc& rDoc = rIter.GetDoc();
//STRIP001 	rDoc.SetCurFtn( *rIter.pAktPam, sTxt, nNo, bEndNote );
//STRIP001 	rIter.pLastUndoObj = this;
//STRIP001 }


/*  */


//STRIP001 SwUndoFtnInfo::SwUndoFtnInfo( const SwFtnInfo &rInfo ) :
//STRIP001 	SwUndo( UNDO_FTNINFO ),
//STRIP001 	pFtnInfo( new SwFtnInfo( rInfo ) )
//STRIP001 {
//STRIP001 }

//STRIP001 SwUndoFtnInfo::~SwUndoFtnInfo()
//STRIP001 {
//STRIP001 	delete pFtnInfo;
//STRIP001 }

//STRIP001 void SwUndoFtnInfo::Undo( SwUndoIter &rIter )
//STRIP001 {
//STRIP001 	SwDoc &rDoc = rIter.GetDoc();
//STRIP001 	SwFtnInfo *pInf = new SwFtnInfo( rDoc.GetFtnInfo() );
//STRIP001 	rDoc.SetFtnInfo( *pFtnInfo );
//STRIP001 	delete pFtnInfo;
//STRIP001 	pFtnInfo = pInf;
//STRIP001 }

//STRIP001 void SwUndoFtnInfo::Redo( SwUndoIter &rIter )
//STRIP001 {
//STRIP001 	SwDoc &rDoc = rIter.GetDoc();
//STRIP001 	SwFtnInfo *pInf = new SwFtnInfo( rDoc.GetFtnInfo() );
//STRIP001 	rDoc.SetFtnInfo( *pFtnInfo );
//STRIP001 	delete pFtnInfo;
//STRIP001 	pFtnInfo = pInf;
//STRIP001 }

/*  */

//STRIP001 SwUndoEndNoteInfo::SwUndoEndNoteInfo( const SwEndNoteInfo &rInfo ) :
//STRIP001 	SwUndo( UNDO_FTNINFO ),
//STRIP001 	pEndNoteInfo( new SwEndNoteInfo( rInfo ) )
//STRIP001 {
//STRIP001 }

//STRIP001 SwUndoEndNoteInfo::~SwUndoEndNoteInfo()
//STRIP001 {
//STRIP001 	delete pEndNoteInfo;
//STRIP001 }

//STRIP001 void SwUndoEndNoteInfo::Undo( SwUndoIter &rIter )
//STRIP001 {
//STRIP001 	SwDoc &rDoc = rIter.GetDoc();
//STRIP001 	SwEndNoteInfo *pInf = new SwEndNoteInfo( rDoc.GetEndNoteInfo() );
//STRIP001 	rDoc.SetEndNoteInfo( *pEndNoteInfo );
//STRIP001 	delete pEndNoteInfo;
//STRIP001 	pEndNoteInfo = pInf;
//STRIP001 }

//STRIP001 void SwUndoEndNoteInfo::Redo( SwUndoIter &rIter )
//STRIP001 {
//STRIP001 	SwDoc &rDoc = rIter.GetDoc();
//STRIP001 	SwEndNoteInfo *pInf = new SwEndNoteInfo( rDoc.GetEndNoteInfo() );
//STRIP001 	rDoc.SetEndNoteInfo( *pEndNoteInfo );
//STRIP001 	delete pEndNoteInfo;
//STRIP001 	pEndNoteInfo = pInf;
//STRIP001 }

/*  */

//STRIP001 SwUndoDontExpandFmt::SwUndoDontExpandFmt( const SwPosition& rPos )
//STRIP001 	: SwUndo( UNDO_DONTEXPAND ),
//STRIP001 	nNode( rPos.nNode.GetIndex() ), nCntnt( rPos.nContent.GetIndex() )
//STRIP001 {
//STRIP001 }

//STRIP001 void SwUndoDontExpandFmt::Undo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwPaM* pPam = rIter.pAktPam;
//STRIP001 	SwDoc* pDoc = pPam->GetDoc();
//STRIP001 
//STRIP001 	SwPosition& rPos = *pPam->GetPoint();
//STRIP001 	rPos.nNode = nNode;
//STRIP001 	rPos.nContent.Assign( rPos.nNode.GetNode().GetCntntNode(), nCntnt );
//STRIP001 	pDoc->DontExpandFmt( rPos, FALSE );
//STRIP001 }


//STRIP001 void SwUndoDontExpandFmt::Redo( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwPaM* pPam = rIter.pAktPam;
//STRIP001 	SwDoc* pDoc = pPam->GetDoc();
//STRIP001 
//STRIP001 	SwPosition& rPos = *pPam->GetPoint();
//STRIP001 	rPos.nNode = nNode;
//STRIP001 	rPos.nContent.Assign( rPos.nNode.GetNode().GetCntntNode(), nCntnt );
//STRIP001 	pDoc->DontExpandFmt( rPos );
//STRIP001 }

//STRIP001 void SwUndoDontExpandFmt::Repeat( SwUndoIter& rIter )
//STRIP001 {
//STRIP001 	SwPaM* pPam = rIter.pAktPam;
//STRIP001 	SwDoc* pDoc = pPam->GetDoc();
//STRIP001 	pDoc->DontExpandFmt( *pPam->GetPoint() );
//STRIP001 }



}
