/*
 * Example low-level D-Bus code.
 * Written by Matthew Johnson <dbus@matthew.ath.cx>
 *
 * This code has been released into the Public Domain.
 * You may do whatever you like with it.
 */
#include <dbus/dbus.h>
#include <stdbool.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include <acpi-queue.h>

/**
 * Listens for signals on the bus
 */
void receive()
{
	DBusMessage *msg;
	DBusConnection *conn;
	DBusError err;
	int ret;
	char *sigvalue;

	printf("Listening for signals\n");

	// initialise the errors
	dbus_error_init(&err);

	// connect to the bus and check for errors
	conn = dbus_bus_get(DBUS_BUS_SYSTEM, &err);
	if (dbus_error_is_set(&err)) {
		fprintf(stderr, "Connection Error (%s)\n", err.message);
		dbus_error_free(&err);
	}
	if (NULL == conn) {
		exit(1);
	}
	// request our name on the bus and check for errors
//	ret = dbus_bus_request_name(conn, "org.kernel.client", DBUS_NAME_FLAG_REPLACE_EXISTING, &err);
//	if (dbus_error_is_set(&err)) {
//		fprintf(stderr, "Name Error (%s)\n", err.message);
//		dbus_error_free(&err);
//	}
//	if (DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER != ret) {
//		exit(1);
//	}
	// add a rule for which messages we want to see
	dbus_bus_add_match(conn, "sender='org.kernel.acpi'", &err);	// see messages from the given sender
	dbus_connection_flush(conn);
	if (dbus_error_is_set(&err)) {
		fprintf(stderr, "Match Error (%s)\n", err.message);
		exit(1);
	}
	printf("Match rule sent\n");

	// loop listening for signals being emmitted
	while (true) {

		// non blocking read of the next available message
		dbus_connection_read_write_dispatch(conn, -1);
		msg = dbus_connection_pop_message(conn);

		// loop again if we haven't read a message
		if (NULL == msg) {
			continue;
		}

		printf("got message, %s.%s\n", dbus_message_get_interface(msg), dbus_message_get_member(msg));

		// check if the message is a signal from the correct interface and with the correct name
		if (dbus_message_is_signal(msg, "org.kernel.acpi.Event", "Broadcast")) {
			dbus_error_init(&err);
			// read the parameters

			char *hid;
			dbus_uint32_t event, data;
			if (!dbus_message_get_args(msg, &err, DBUS_TYPE_STRING, &hid, DBUS_TYPE_UINT32, &event, DBUS_TYPE_UINT32, &data, DBUS_TYPE_INVALID)) {
				fprintf(stderr, "Message parsing error: %s\n", err.message);
			} else {
				printf("Got Signal: %s %08x %08x\n", hid, event, data);
			}
		}
		// free the message
		dbus_message_unref(msg);
	}
}

int main(int argc, char **argv)
{
	receive();
	return 0;
}

