// cmdline_do_action.cc
//
//  Copyright 2004 Daniel Burrows

#include "cmdline_do_action.h"

#include "cmdline_action.h"
#include "cmdline_common.h"
#include "cmdline_prompt.h"
#include "cmdline_show_broken.h"
#include "cmdline_simulate.h"
#include "cmdline_util.h"

#include <generic/apt.h>
#include <generic/config_signal.h>

#include <aptitude.h>
#include <download.h>

#include <apt-pkg/algorithms.h>
#include <apt-pkg/error.h>
#include <apt-pkg/progress.h>

// TODO: add an option to obey sticky states even if it wasn't
//      explicitly requested.
//
// TODO: perhaps when trying to find a list of possible candidates for
// installation, we should use a formatted display?
int cmdline_do_action(int argc, char *argv[],
		      const char *status_fname, bool simulate,
		      bool assume_yes, bool download_only, bool fix_broken,
		      bool showvers, bool showdeps, bool showsize,
		      bool visual_preview, bool always_prompt, int verbose)
{
  _error->DumpErrors();

  cmdline_pkgaction_type default_action=cmdline_install;
  bool dist_upgrade=false;

  // Parse the action.
  if(!strcasecmp(argv[0], "install"))
    default_action=cmdline_install;
  else if(!strcasecmp(argv[0], "reinstall"))
    default_action=cmdline_reinstall;
  else if(!strcasecmp(argv[0], "dist-upgrade"))
    {
      default_action=cmdline_install;
      dist_upgrade=true;
    }
  else if(!strcasecmp(argv[0], "remove"))
    default_action=cmdline_remove;
  else if(!strcasecmp(argv[0], "purge"))
    default_action=cmdline_purge;
  else if(!strcasecmp(argv[0], "hold"))
    default_action=cmdline_hold;
  else if(!strcasecmp(argv[0], "unhold"))
    default_action=cmdline_unhold;
  else if(!strcasecmp(argv[0], "markauto"))
    default_action=cmdline_markauto;
  else if(!strcasecmp(argv[0], "unmarkauto"))
    default_action=cmdline_unmarkauto;
  else if(!strcasecmp(argv[0], "forbid-version"))
    default_action=cmdline_forbid_version;
  else
    {
      // Should never happen.
      _error->Error(_("Invalid operation %s"), argv[0]);
      _error->DumpErrors();
      return -1;
    }

  OpTextProgress progress;

  aptcfg->SetNoUser(PACKAGE "::Auto-Upgrade", "false");

  // If there are no arguments and the default action is "install", act
  // on stickies.
  //
  // This way, "aptitude install" will just perform any pending
  // installations.
  apt_init(&progress, (argc==1 && default_action==cmdline_install &&
		       !dist_upgrade), status_fname);

  if(_error->PendingError())
    {
      _error->DumpErrors();
      return -1;
    }

  // In case we aren't root.
  if(!simulate)
    apt_cache_file->GainLock();
  else
    apt_cache_file->ReleaseLock();

  if(_error->PendingError())
    {
      _error->DumpErrors();
      return -1;
    }

  pkgset to_install, to_hold, to_remove, to_purge;

  if(dist_upgrade)
    {
      // Build to_install to avoid a big printout
      for(pkgCache::PkgIterator i=(*apt_cache_file)->PkgBegin(); !i.end(); ++i)
	{
	  pkgDepCache::StateCache &state=(*apt_cache_file)[i];

	  if(!i.CurrentVer().end() &&
	     state.Upgradable() && !(*apt_cache_file)->is_held(i))
	    to_install.insert(i);

	}

      (*apt_cache_file)->mark_all_upgradable(true, NULL);
    }
  else if(argc==1 && default_action==cmdline_install)
    {
      // FIXME: Build to_install to avoid a big printout
      for(pkgCache::PkgIterator i=(*apt_cache_file)->PkgBegin(); !i.end(); ++i)
	{

	}
    }

  // TODO: look for filenames and call dpkg directly if that's the case.

  pkgProblemResolver fixer(*apt_cache_file);
  // Used when doing only a local optimization (ie, we aren't trying to
  // do a dist-upgrade)

  (*apt_cache_file)->begin_action_group();
  // Mark packages 'n stuff.
  for(int i=1; i<argc; ++i)
    {
      cmdline_pkgaction_type action=default_action;
      int tmp=strlen(argv[i])-1;

      // HACK: disable interpreting of escapes if it's an existing
      //      package name.
      if((*apt_cache_file)->FindPkg(argv[i]).end())
	switch(argv[i][tmp])
	  {
	  case '-':
	    action=cmdline_remove;
	    argv[i][tmp]=0;
	    break;
	  case '=':
	    action=cmdline_hold;
	    argv[i][tmp]=0;
	    break;
	  case '+':
	    action=cmdline_install;
	    argv[i][tmp]=0;
	    break;
	  case '_':
	    action=cmdline_purge;
	    argv[i][tmp]=0;
	    break;
	  }

      cmdline_applyaction(argv[i], action, fixer,
			  to_install, to_hold, to_remove, to_purge,
			  verbose);
    }
  (*apt_cache_file)->end_action_group(NULL);

  if(dist_upgrade ||
     (fix_broken && argc==1 && default_action==cmdline_install))
    {
      if(!(*apt_cache_file)->try_fix_broken(NULL))
	{
	  _error->DumpErrors();
	  return -1;
	}
    }
  else
    {
      if(!(*apt_cache_file)->try_fix_broken(fixer, NULL))
	_error->Error("Unable to resolve some dependencies!");
    }

  _error->DumpErrors();

  if(!show_broken())
    return -1;

  if(visual_preview)
    {
      ui_preview();
      return 0;
    }
  else if(simulate)
    return cmdline_simulate(dist_upgrade, to_install, to_hold, to_remove, to_purge,
			    showvers, showdeps, showsize,
			    always_prompt, verbose, assume_yes);
  else
    {
      if(!cmdline_do_prompt(dist_upgrade,
			    to_install, to_hold, to_remove, to_purge,
			    showvers, showdeps, showsize,
			    always_prompt, verbose, assume_yes))
	{
	  printf(_("Abort.\n"));
	  return 0;
	}

      int rval=do_install_run(&progress, true, download_only)?0:-1;

      if(_error->PendingError())
	rval=-1;

      _error->DumpErrors();

      return rval;
    }
}
