// menu_redirect.h                                 -*-c++-*-
//
//   Copyright 2004 Daniel Burrows
//
// This class allows some signals to be "redirected" from the menu to
// appropriate widgets.

#ifndef MENU_REDIRECT_H
#define MENU_REDIRECT_H

#include <sigc++/object.h>

class menu_redirect:virtual public SigC::Object
{
public:
  /** \return \b true iff the package commands should be enabled. */
  virtual bool package_enabled()=0;

  /** Install the selected package (if any).
   *
   *  \return \b true to stop emission of the signal.
   */
  virtual bool package_install()=0;

  /** Remove the selected package (if any). */
  virtual bool package_remove()=0;

  /** Purge the selected package (if any). */
  virtual bool package_purge()=0;

  /** Hold the selected package (if any). */
  virtual bool package_hold()=0;

  /** Keep the selected package (if any). */
  virtual bool package_keep()=0;

  /** Set the "automatic" flag on the selected package (if any). */
  virtual bool package_mark_auto()=0;

  /** Clear the "automatic" flag on the selected package (if any). */
  virtual bool package_unmark_auto()=0;

  /** \return \b true if the selected item can be 'forbidden'. */
  virtual bool package_forbid_enabled()=0;

  /** 'Forbid' the selected item: either forbid the candidate
   *  version of a package, or forbid the selected version.
   */
  virtual bool package_forbid()=0;

  /** \return \b true if the selected item has information to view. */
  virtual bool package_information_enabled()=0;

  /** View a package's information.  Only works on a real package or a
   *  package version.
   */
  virtual bool package_information()=0;

  /** \return \b true if the selected item has a changelog. */
  virtual bool package_changelog_enabled()=0;

  /** View the changelog of the selected package. */
  virtual bool package_changelog()=0;

  /** \return \b true if this view knows how to search. */
  virtual bool find_search_enabled()=0;

  /** Execute the 'search' menu command. */
  virtual bool find_search()=0;

  /** \return \b true if this view knows how to search and there is
   *  a "previous search".
   */
  virtual bool find_research_enabled()=0;

  /** Execute the 're-search' menu command. */
  virtual bool find_research()=0;

  /** \return \b true if this view knows how to set a display limit. */
  virtual bool find_limit_enabled()=0;

  /** Execute the 'limit' menu command. */
  virtual bool find_limit()=0;

  /** \return \b true if this view knows how to clear a display limit. */
  virtual bool find_reset_limit_enabled()=0;

  /** Execute the 'reset limit' menu command. */
  virtual bool find_reset_limit()=0;

  /** \return \b true if this view knows how to find broken packages. */
  virtual bool find_broken_enabled()=0;

  /** Execute the 'find broken' menu command. */
  virtual bool find_broken()=0;

  virtual ~menu_redirect() {}
};

#endif
