// slotarg.h			-*-c++-*-
//
//  Copyright 2000 Daniel Burrows
//
//  Provides a mechanism for nicely passing in optional slots to a function.
// (you can pass either a reference to one or a pointer (which can be NULL)
//
//  Eg: some_slot_function(SlotArg, SlotArg, SlotArg) can be called as:
// some_slot_function(slota, NULL, slotb) to omit the second slot.

#ifndef SLOTARG_H
#define SLOTARG_H

#include <sigc++/slot.h>

template<class T>
class SlotArg
{
  bool hasslot;
  T theslot;
public:
  SlotArg(const T *slot)
  {
    if(slot)
      {
	theslot=*slot;
	hasslot=true;
      }
    else
      hasslot=false;
  }
  SlotArg(const T &slot)
    :hasslot(true), theslot(slot)
  {
  }

  operator bool() {return hasslot;}
  operator T &() {return theslot;}
};

typedef SlotArg<SigC::Slot0<void> > Slot0Arg;

#endif
