// vs_size_box.cc
//
// Copyright 2004 Daniel Burrows

#include "vs_size_box.h"

#include <sigc++/object_slot.h>

#include <utility>

using namespace std;

vs_size_box::vs_size_box(size s, vscreen_widget *w):min_size(s)
{
  set_subwidget(w);
  set_bg(-1); // Make the background 'invisible'.

  do_layout.connect(slot(*this, &vs_size_box::layout_me));
}

size vs_size_box::size_request()
{
  vscreen_widget *child=get_subwidget();
  size child_req=child?child->size_request():size(0,0);

  return size(max(min_size.w, child_req.w), max(min_size.h, child_req.h));
}

void vs_size_box::layout_me()
{
  if(get_subwidget())
    {
      if(get_subwidget()->get_visible())
	get_subwidget()->alloc_size(0, 0, getmaxx(), getmaxy());
      else
	get_subwidget()->alloc_size(0, 0, 0, 0);
    }
}
