// vs_stacked.cc

#include "vscreen.h"
#include "vs_stacked.h"

#include <sigc++/bind.h>
#include <sigc++/object_slot.h>

vs_stacked::vs_stacked(int w, int h)
  :req_w(w), req_h(h)
{
  do_layout.connect(slot(*this, &vs_stacked::layout_me));
}

void vs_stacked::add_widget(vscreen_widget *w)
{
  SigC::Connection shown_conn=w->shown_sig.connect(bind(slot(*this, &vs_stacked::raise_widget), w));
  SigC::Connection hidden_conn=w->hidden_sig.connect(slot(*this, &vs_stacked::hide_widget));

  defocus();

  children.push_back(child_info(w, shown_conn, hidden_conn));

  w->set_owner(this);

  refocus();

  if(w->get_visible())
    vscreen_update();
}

void vs_stacked::hide_widget()
{
  vscreen_update();
}

void vs_stacked::rem_widget(vscreen_widget *w)
{
  for(childlist::iterator i=children.begin();
      i!=children.end();
      i++)
    {
      if(i->w==w)
	{
	  i->shown_conn.disconnect();
	  i->hidden_conn.disconnect();

	  children.erase(i);
	  w->set_owner(NULL);
	  if(w->get_visible())
	    vscreen_update();

	  w->unfocussed();
	  refocus();

	  return;
	}
    }
}

void vs_stacked::raise_widget(vscreen_widget *w)
{
  for(childlist::iterator i=children.begin();
      i!=children.end();
      i++)
    if(i->w==w)
      {
	defocus();

	children.push_front(*i);
	children.erase(i);

	refocus();

	vscreen_update();
	return;
      }
}

void vs_stacked::lower_widget(vscreen_widget *w)
{
  for(childlist::iterator i=children.begin();
      i!=children.end();
      i++)
    if(i->w==w)
      {
	defocus();

	children.push_back(*i);
	children.erase(i);

	refocus();

	vscreen_update();
	return;
      }
}

void vs_stacked::paint()
{
  // Go through the children back-to-front (reverse order)
  for(childlist::reverse_iterator i=children.rbegin();
      i!=children.rend();
      i++)
    if(i->w->get_visible())
      i->w->display();
}

void vs_stacked::dispatch_mouse(short id, int x, int y, int z, mmask_t bstate)
{
  for(childlist::iterator i=children.begin();
      i!=children.end();
      ++i)
    if(i->w->get_visible() && i->w->enclose(y, x))
      {
	i->w->dispatch_mouse(id, x-i->w->get_startx(), y-i->w->get_starty(),
			     z, bstate);
	return;
      }
}

vscreen_widget *vs_stacked::get_focus()
{
  for(childlist::iterator i=children.begin();
      i!=children.end();
      i++)
    if(i->w->get_visible() && i->w->focus_me())
      return i->w;
    else
      return NULL;

  return NULL;
}

void vs_stacked::show_all()
{
  defocus();

  for(childlist::iterator i=children.begin();
      i!=children.end();
      i++)
    {
      i->shown_conn.disconnect();

      i->w->show_all();

      i->shown_conn=i->w->shown_sig.connect(bind(slot(*this, &vs_stacked::raise_widget), i->w));
    }

  refocus();
}

size vs_stacked::size_request()
{
  return size(req_w, req_h);
}

void vs_stacked::layout_me()
{
  for(childlist::iterator i=children.begin(); i!=children.end(); i++)
    i->w->alloc_size(0, 0, getmaxx(), getmaxy());
}
