// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2004  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                           


#ifndef __AGxxConfig_h__
#define __AGxxConfig_h__

#include "OptionVec.h"

// PUMA includes 
#include "Puma/OptsParser.h"
#include "Puma/ErrorStream.h"
using namespace Puma;

// stdc++ includes
#include <string>
#include <list>
using namespace std;


class AGxxConfig{

public:
	typedef list<string> FileCont;


private:
	
	ErrorStream &_err;
	int _argc;
	char** _argv; 

	// list of .ah files passed with -a option
	FileCont _ah_files;
	
	// path to project directory
	FileCont _proj_path;

	// output file name
	string _output_file;

	// name of puma config file
	string _puma_config;
	
	// path to aspectc++ compiler
	string _acc_bin;

	// path to c++ compiler
	string _cc_bin;

	// Option Vector
	OptionVec _optvec;

	// path to destination directory
	string _dest_path;
	
	// command, which is executed to get the information about 
	// compiler, include paths, defines.
	// default is: <compiler_name> <compiler options> -E -dM -v -x c++ /dev/null
	string _config_command;
	
	// number of files to be processed
	int _nr_files;
	
	// verbose
	int _verbose;
	
	// generate include files
	bool _gen_incl;

	// indicate wether a config file should be generated
	bool _gen_pumaconfig;
	
	// indicate wether weaving should be done
	bool _weave;
	
	// indicate wether compiling should be done
	bool _compile;
	
	// indicate wether dependency information should be printed out
	bool _make_dep;
	
	// indicate wether linking should be done
	bool _link;
	
	// keep weaved source code  files
	bool _keep_acc;
	
	// if include files are generated
	bool _gen_includes;

	// assign all following options to the compiler
	bool _x_compiler;
	
	// list of gcc options which need a argument
	static  string _gcc_option_arg[];
	
	
	
public:
	AGxxConfig(ErrorStream &e,int argc,char **argv):_err(e),_argc(argc),_argv(argv){}
	
	~AGxxConfig(){}
		
	enum {
		AGOPT_COMPILE_ONLY=1,AGOPT_WEAVE,AGOPT_GEN_CFG,AGOPT_OUTPUT,AGOPT_ACC,AGOPT_CC,
		AGOPT_HELP,AGOPT_KEEP_ACC, AGOPT_CONFIG_COMMAND,AGOPT_X_COMPILER,AGOPT_X_WEAVER,
		AGOPT_VERBOSE, AGOPT_VERSION, 
		// Ac++ options
		ACOPT, // default handling for AspectC++ options
		ACOPT_INCLUDE_FILES,ACOPT_ASPECT_HEADER,
		ACOPT_PROJ_PATH, ACOPT_PROJ_DESTINATION, ACOPT_CFG_FILE,
		ACOPT_PRE_INCLUDE, ACOPT_PRE_DEFINE, ACOPT_PRE_UNDEFINE,
		ACOPT_ALWAYS_INCLUDE
	};
	  

	
	
	// anaylze the arguments
	bool analyze();
	
	// print Options
	void printOptions();
	
	// anaylze g++ options
	bool analyzeGccOpt(OptsParser&);
	
	//print a usage message
  	void usage() const;
	
	//
	// Methods for accesing private data
	//
	
	const bool gen_pumaconfig(){return _gen_pumaconfig;}
	void gen_pumaconfig(const bool b){_gen_pumaconfig = b;}

	const bool weave(){return _weave;}

	const bool compile(){return _compile;}
	
	const bool make_dep(){return _make_dep;}
	
	const bool link(){return _link;}
	
	const bool keep_acc(){return _keep_acc;}
	
	const bool gen_includes(){return _gen_includes;}
	
	const int nr_files(){return _nr_files;}
	
	const int verbose(){return _verbose;}
	
	OptionVec& optvec(){return _optvec;}
	
	FileCont& ah_files(){return _ah_files;}
	
	FileCont& proj_paths(){return _proj_path;}

	const string& puma_config(){return _puma_config;}
	void puma_config(const string& s){_puma_config=s;}

	const string& output_file(){return _output_file;}
	void output_file(const string& s){_output_file=s;}
	
	const string& acc_bin(){return _acc_bin;}
	
	const string& cc_bin(){return _cc_bin;}

	const string& dest_path(){return _dest_path;}
	
	string& config_command(){return _config_command;}
	
	
};	


#endif //__AGxxConfig_h__

