// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Introducer_h__
#define __Introducer_h__

// Class that is used for introductions during a parser run.
// The semantics object has a reference to an Introducer and uses
// the interface at some well defined (join) points.

#include "Puma/ACIntroducer.h"
using namespace Puma;

namespace Puma {
  class CT_ClassDef;
  class CCParser;
  class PreprocessorParser;
  class CClassInfo;
}

class CodeWeaver;
class JPP_Class;
class Plan;

class Introducer : public ACIntroducer {
  CodeWeaver &_code_weaver;
  CCParser &_parser;
  Plan &_plan;
  int _intro_level;
  PreprocessorParser *_cpp;
  
public:
  // Contructor: every Introducer knows the parser
  Introducer (CodeWeaver &cw, CCParser &p, Plan &pl) :
    _code_weaver (cw), _parser (p), _plan (pl), _intro_level (0), _cpp (0) {}
  
  // called when a new class/union/struct/aspect is created, current scope
  // is the global scope
  virtual void class_before (CT_ClassDef*);

  // called when a new class/union/struct/aspect is created
  virtual void class_begin (CT_ClassDef*);

  // called when a new class/union/struct/aspect definition ends
  // (still in the class scope)
  virtual void class_end (CT_ClassDef*, CTree*);
  
private:

  // check in the plan if the current class needs an introduction
  JPP_Class *plan_lookup (CClassInfo *ci);

  // manage the intro nesting level and the _cpp pointer
  void enter ();
  void leave ();
};

#endif /* __Introducer_h__ */
