// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __sb_whole_file_h__
#define __sb_whole_file_h__

#include "Puma/SB_String.h"
#include "Puma/ErrorStream.h"
#include "Puma/Source.h"

namespace Puma {


class SB_WholeFile : public SB_String {
  char* buffer;
  bool error;

public:
  SB_WholeFile () : SB_String (), buffer (0) {}
  virtual ~SB_WholeFile () { if (buffer) delete[] buffer; }

  void init (ErrorSink &err, Source &src) { 
    if (buffer) delete[] buffer;

    error = false;
    int buffer_size = src.size ();
    if (buffer_size < 0) {
      err << sev_error << "can't determine size of input file" 
          << endMessage;
      error = true;
      return;
    }

    buffer = new char[buffer_size];
    if (! buffer) { // Help, this should not happen, but why not checking
      err << sev_error << "Out of memory" << endMessage;
      error = true;
      return;
    }
         
    if (src.read (buffer, src.size ()) != src.size ()) {
      err << sev_error << "can't load input file" << endMessage;
      error = true;
      return;
    }

    SB_String::init (buffer, buffer_size);
  }

  State state () const { return error ? STATE_ERROR : SB_String::state (); }
};


} // namespace Puma

#endif /* __sb_whole_file_h__ */
