// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __unit_h__
#define __unit_h__

#include "Puma/List.h"
#include "Puma/Printable.h"
#include "Puma/UnitState.h"

namespace Puma {


class Unit : public List, public Printable {
  char *_name;
  UnitState _state;

public:
  Unit () : List (), _name ((char*)0) {}
  Unit (const List &list) : List (list), _name ((char*)0) {}
  virtual ~Unit ();
  virtual void name (const char *);
  char *name () const { return _name; }
  virtual void print (ostream &os) const;
  virtual bool isFile () const { return false; }
  virtual bool isMacroExp () const { return false; }
  UnitState &state () { return _state; }
};


} // namespace Puma

#endif /* __unit_h__ */
