#ifndef __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_Config_h__

#ifndef __ac_h_
#define __ac_h_
namespace AC {
  typedef const char* Type;
  enum JPType { CALL = 0x0004, EXECUTION = 0x0008, CONSTRUCTION = 0x0010, DESTRUCTION = 0x0020 };
  struct Action {
    void **_args; void *_result; void *_target; void *_that; void *_fptr;
    void (*_wrapper)(Action &);
    inline void trigger () { _wrapper (*this); }
  };
  struct AnyResultBuffer {};
  template <typename T> struct ResultBuffer : public AnyResultBuffer {
    char _data[sizeof (T)];
    ~ResultBuffer () { ((T*)_data)->T::~T(); }
    operator T& () const { return *(T*)_data; }
  };
  template <class Aspect, int Index>
  struct CFlow {
    static int &instance () {
      static int counter = 0;
      return counter;
    }
    CFlow () { instance ()++; }
    ~CFlow () { instance ()--; }
    static bool active () { return instance () > 0; }
  };
}
inline void * operator new (__SIZE_TYPE__, AC::AnyResultBuffer *p) { return p; }
inline void operator delete (void *, AC::AnyResultBuffer *) { } // for VC++
#endif // __ac_h_
#endif // __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Config_h__
#define __Config_h__

// Class Config provides evaluation of configuration 
// information from file or command line.

#include "Puma/Flags.h"
#include "Puma/ConfOption.h"
#include "Puma/ErrorStream.h"
#include "Puma/OptsParser.h"
#include <string>
using namespace std;

namespace Puma {


} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class Config {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Flags _flags;
  ErrorStream &_err;
  Array<const ConfOption *> _options;
  
public:
  enum OPTIONS {
    PRE_ASSERT = 1,
    PRE_DEFINE, 
    PRE_UNDEFINE, 
    PRE_LOCK_MACRO,
    PRE_INCLUDE,
    CFG_FILE, 
    PROJ_PATH, 
    PROJ_DESTINATION,
    SET_SUFFIX, 
    SET_EXTENSION, 
    SET_WRITE_PROTECTED,
    SET_OPTION, 
    SET_OPTION_ARG
  };
   
public:
  Config (ErrorStream &);
  Config (const Config &);
  ~Config ();
  
  // read config file
  Config (ErrorStream &, const char *);
  // read command line
  Config (ErrorStream &, int &, char **&);
  // read config file and command line
  Config (ErrorStream &, const char *, int &, char **&);
        
  // join with another configuration
  void Join (const Config &);

  // evaluate file, if file not given read from $PUMA_CONFIG
  // or /etc/puma.config
  void Read (const char * = (const char *)0);
  // evaluate command line
  void Read (int &, char **&);

  // add options to configuration
  void Add (const ConfOption *);
  void Add (const char *);
  void Add (const char *, const char *);
  void Add (const char *, const char *, const char *);

  // get options
  unsigned Options () const;
  const ConfOption *Option (unsigned) const;
  const ConfOption *Option (const char *) const;

  Flags FlagTable () const;
  
private:
  bool Valid (const char *, const char * = (const char *)0) const;

  bool Process (OptsParser&);
  bool ProcessAssert (const string&);
  bool ProcessDefine (const string&);
  bool ProcessLockMacro (const string&);
  bool ProcessUndefine (const string&);
  bool ProcessConfigFile (const string&,const string&);
  bool ProcessArgument (const string&,const string&);
  bool ProcessPathArgument (const string&,const string&);

};

inline Config::Config (ErrorStream &e) : _err (e)
 {}
inline Config::Config (const Config &c) : _err (c._err)
 { Join (c); }
  
inline Config::Config (ErrorStream &e, const char *file) : _err (e)
 { Read (file); }
inline Config::Config (ErrorStream &e, int &argc, char **&argv) : _err (e)
 { Read (argc, argv); }
inline Config::Config (ErrorStream &e, const char *file, int &argc, char **&argv) : _err (e)
 { Read (file); Read (argc, argv); }

inline Config::~Config  ()
 { for (unsigned i = 0; i < Options (); i++)
     delete (ConfOption *) Option (i);
 }

inline void Config::Add (const ConfOption *o) 
 { _options.append (o); }
inline void Config::Add (const char *n)
 { Add (new ConfOption (n)); }
inline void Config::Add (const char *n, const char *a1)
 { Add (new ConfOption (n, a1)); }
inline void Config::Add (const char *n, const char *a1, const char *a2)
 { Add (new ConfOption (n, a1, a2)); }

inline unsigned Config::Options () const
 { return _options.length (); }
inline const ConfOption *Config::Option (unsigned i) const
 { return _options.lookup (i); }

inline Flags Config::FlagTable () const
 { return _flags; }


} // namespace Puma

#endif /* __Config_h__ */

#ifdef __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_Config_h__
/*** begin of aspect includes ***/
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__
#include "WinIfExists.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__
#include "WinImportHandler.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__
#include "WinMacros.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__
#include "CMatchSyntax.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__
#include "ExtGnu.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__
#include "ExtAC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__
#include "ExtACBuilderH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__
#include "ExtACBuilderCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__
#include "ExtACSyntaxH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__
#include "ExtACSyntaxCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__
#include "ExtACTree.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#include "ExtACKeywords.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__
#include "TraceSyntax.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__
#include "WinAsm.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__
#include "WinDeclSpecs.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__
#include "WinMemberExplSpec.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__
#include "WinTypeKeywords.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__
#include "PragmaOnceUnitState.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#include "PragmaOnce.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__
#include "CCExprResolveH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__
#include "CCExprResolveCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__
#include "CExprResolveH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__
#include "CExprResolveCC.ah"
#endif
/*** end of aspect includes ***/
#undef __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#undef __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_Config_h__
#endif // __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_Config_h__
