// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __ACPointCutInfo_h__
#define __ACPointCutInfo_h__

#include "Puma/CFunctionInfo.h"

namespace Puma {


class ACAspectInfo;
class CT_PointcutDecl;

/** \file 
 *  Representation of an AspectC++ 'pointcut'.
 *  \see Puma::ACPointcutInfo */

/** \class ACPointcutInfo ACPointcutInfo.h Puma/infos/acinfos/ACPointcutInfo.h
 *  An ACPointcutInfo object represents an AspectC++ 'pointcut' declaration. 
 *  A pointcut declaration is syntactically equal to a function 
 *  declaration and also parsed like a function. */
class ACPointcutInfo {
  CFunctionInfo   *_function;
  ACAspectInfo    *_aspect;
  CT_PointcutDecl *_def_node;
      
public:
  /** Construct a pointcut info object.
   *  \param f The function info of the pointcut declaration. */
  ACPointcutInfo (CFunctionInfo *f) :
    _function (f), _aspect ((ACAspectInfo*)0),
    _def_node ((CT_PointcutDecl *)0) {}

  /** Get the name of the pointcut. */
  const char *name () { return _function->Name (); }
  /** Get the function info of the pointcut declaration. */
  CFunctionInfo *function () { return _function; }
  /** Set the aspect in which the pointcut is declared. 
   *  \param ai The aspect info of the corresponding aspect. */
  void Aspect (ACAspectInfo *ai) { _aspect = ai; }
  /** Get the aspect in which the pointcut is declared. */
  ACAspectInfo *Aspect () { return _aspect; }

  /** Return \e true if the pointcut is virtual. */
  bool is_virtual () { return (_function->isVirtual ()); }
  //bool is_pure () { return _function->isPureVirtual (); }

  /** Set the pointcut definition syntax tree node.
   *  \param pcd The pointcut syntax tree node. */
  void def_node (CT_PointcutDecl *pcd) { _def_node = pcd; }
  /** Get the syntax tree node of the pointcut definition. */
  CT_PointcutDecl *def_node () { return _def_node; }
};


} // namespace Puma

#endif /* __PointCutInfo_h__ */
