// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __sb_sequential_h__
#define __sb_sequential_h__

#include "Puma/ScanBuffer.h"
#include "Puma/Source.h"
#include <string.h>

namespace Puma {


class SB_Sequential : public ScanBuffer {
  char TokenBuffer[1024]; // Maximum token size!
  int  BuffPos;
  int  BuffSize;
  Source *source;
  State _state;

  void fetch ();

public:
  void init (Source &src) { source = &src; }
  char next () {
    char character = TokenBuffer[BuffPos++];
    if (BuffPos == BuffSize)
      fetch ();
    return character;
  }

  char *token () { return TokenBuffer; }
  int len () const { return BuffPos; }
  void reset () { BuffPos = 0; BuffSize = 0; fetch (); }
  void retry () { BuffPos = 0; }
  void accept (int len) {
    BuffSize -= len; BuffPos = 0;
    memcpy (TokenBuffer, TokenBuffer + len, BuffSize);
  }
  void more (int len) { BuffPos = len; }
  State state () const { return (BuffPos < BuffSize) ? STATE_OK : _state; }
};


} // namespace Puma

#endif /* __sb_sequential_h__ */
