<?php

require_once("../inc/util.inc");
require_once("../project/project.inc");

$config = get_config();
$master_url = parse_config($config, "<master_url>");

// Determine if phpmailer is installed and to be used (defined in project.inc)
if (isset($USE_PHPMAILER)) {
    if ($USE_PHPMAILER) {
        require_once("../inc/phpmailer/class.phpmailer.php");
    }
} else {
    $USE_PHPMAILER = false;
}

// Function sends an email, either using PHPMailer or not.
//
function send_email($user, $subject, $body, $body_html=null) {
    global $USE_PHPMAILER;
    global $PHPMAILER_HOST;
    global $PHPMAILER_MAILER;

    if ($USE_PHPMAILER) {
        $mail = new PHPMailer();
        $mail->AddAddress($user->email_addr, $user->name);
        $mail->Subject = $subject;
        if ($body_html) {
            $mail->AltBody = $body;
            $mail->Body = $body_html;
        } else {
            $mail->Body = $body;
        }
        $mail->From = EMAIL_FROM;
        $mail->FromName = EMAIL_FROM_NAME;
        $mail->Host = $PHPMAILER_HOST;
        $mail->Mailer = $PHPMAILER_MAILER;
        return $mail->Send();
    } else {
        if (defined('EMAIL_FROM')) {
            $headers = "From: ". EMAIL_FROM;
        } else {
            $headers ="";
        }
        return mail($user->email_addr, $subject, $body, $headers);
    }
}

// Send an email describing an account to the user.
// There are a few scenarios:
//
// 1) the account was created by user via web.
//    In this case they're currently looking at the "validate account" page
//    (account_created.php), although they might have strayed
//    so we need to give them a link.
// 2) the account was created administratively
// 3) the user requested account key for existing account
//
function send_auth_email($user, $is_new) {
    global $master_url;
    $body = "";

    if ($is_new) {
        $subject = PROJECT." account confirmation for $user->name";
        $body = "Welcome to ".PROJECT.".

This email confirms your account with ".PROJECT.":
    Project URL:         $master_url
    User name:           $user->name
    E-mail:              $user->email_addr
    Account Key:         $user->authenticator
    (use this to log in if you forget your password)
";
    } else {
        $subject = PROJECT." information for $user->name";
        $body = "Your ".PROJECT." account information is:

    Project URL:         $master_url
    User name:           $user->name
    E-mail:              $user->email_addr
    Account Key:         $user->authenticator
    (use this to log in if you forget your password)
";
    }

$body .= "

For further information and assistance with ".PROJECT." go to
$master_url
";
    return send_email($user, $subject, $body);
}

// Function simply outputs some text letting the user know
// their authenticator was emailed to them.
//
function email_sent_message($email_addr) {
    if (defined('EMAIL_FROM')) {
        $email_from = EMAIL_FROM;
    } else {
        $email_from = URL_BASE;
    }

    echo "
        Your Account Key has been emailed to $email_addr.
        <p>
        If the email doesn't arrive in a few minutes,
        your ISP may be blocking it as spam.
        In this case please contact your ISP and
        ask them to not block email from $email_from.
    ";
}

// a valid email address is of the form A@B.C
// where A, B, C are nonempty,
// A and B don't contain @ or .,
// and C doesn't contain @ and is at least 2 chars
//
function is_valid_email_addr($addr) {
    $pattern = '/^([^@]+)@([^@\.]+)\.([^@]{2,})$/';
    $match = preg_match($pattern, $addr);
    return (bool) $match;
}


// If a user's host is identified as causing problems, this email is sent
// to the owner to let them know.
//
function send_problem_email($user, $host) {
    global $master_url;
    $body = "";
        
    $host_content = "ID: ".$host->id."
    Created: ".time_str($host->create_time)."
    Venue: ".$host->venue."
    Total credit: ".$host->total_credit."
    Average credit: ".$host->expavg_credit."
    Average update time: ".time_str($host->expavg_time)."
    IP address: $host->last_ip_addr (same the last $host->nsame_ip_addr times)
    Domain name: " . $host->domain_name;
    $x = $host->timezone/3600;
    if ($x >= 0) $x="+$x";
    $host_content.="
    Local Time = UTC $x hours
    Number of CPUs: " . $host->p_ncpus."
    CPU: $host->p_vendor $host->p_model
    FP ops/sec: ".$host->p_fpops."
    Int ops/sec: ".$host->p_iops."
    memory bandwidth: ".$host->p_membw."
    Operating System: $host->os_name $host->os_version";
    $x = $host->m_nbytes/(1024*1024);
    $y = round($x, 2);
    $host_content.="
    Memory: $y MB";
    $x = $host->m_cache/1024;
    $y = round($x, 2);
    $host_content.="
    Cache: $y KB";
    $x = $host->m_swap/(1024*1024);
    $y = round($x, 2);
    $host_content.="
    Swap Space: $y MB";
    $x = $host->d_total/(1024*1024*1024);
    $y = round($x, 2);
    $host_content.="
    Total Disk Space: $y GB";
    $x = $host->d_free/(1024*1024*1024);
    $y = round($x, 2);
    $host_content.="
    Free Disk Space: $y GB
    Avg network bandwidth (upstream): $host->n_bwup bytes/sec
    Avg network bandwidth (downstream): $host->n_bwdown bytes/sec";
    $x = $host->avg_turnaround/86400;
    $host_content.="
    Average turnaround: ".round($x, 2)." days
    Number of RPCs: $host->rpc_seqno
    Last RPC: ".time_str($host->rpc_time)."
    % of time client on: ". 100*$host->on_frac." %
    % of time host connected: " . 100*$host->connected_frac." %
    % of time user active: " . 100*$host->active_frac." %
    # of results today: " . $host->nresults_today;
    
    $subject = PROJECT." notice for $user->name";
    $body = PROJECT." notification:

Dear $user->name
Your machine (host # $host->id) described below appears to have a misconfigured BOINC
installation.  Could you please have a look at it?

Sincerely,
        The ". PROJECT." team
";
$body .= "

This is the content of our database:
" . $host_content."

For further information and assistance with ".PROJECT." go to $master_url";
    echo nl2br($body) . "<br><br>"; 
    return send_email($user, $subject, $body);

}

function salted_key($key) {
    return md5($key.'oogabooga');
}

function send_founder_transfer_email($team, $user) {
    $body = "Team member ".$user->name." has requested you to hand over
the privileges and responsibilities of team founder to him in ".PROJECT.".
    
Visit ".URL_BASE."team_change_founder_form.php?teamid=".$team->id."
to change team founder or decline user's request.
    
If you do not respond to this request within two months, ".$user->name." will
be given the option to become the founder himself.
    
Please do not respond to this email. The mailbox is not monitored and the email
was sent using an automated system.";
    
    $founder = lookup_user_id($team->userid);

    return send_email($founder, PROJECT." team founder transfer", $body);
}

function send_founder_transfer_decline_email($team, $user) {
    $body = "The team founder of ".$team->name." has declined your request
to become the new team founder in ".PROJECT.". You may wish to discuss 
the matter with him directly or apply to become a founder after three
months have passed since the initial request.
    
Please do not respond to this email. The mailbox is not monitored and the email
was sent using an automated system.";
    
    return send_email($user, PROJECT." team founder transfer declined", $body);
}

?>
