(in-package :contextl)

(defun make-enclosing-package (name)
  (make-package name :use '()))

(defgeneric enclose-symbol (symbol package)
  (:method ((symbol symbol)
            (package package))
   (assert (symbol-package symbol) (symbol)
     "Symbol ~S must not be uninterned." symbol)
   (intern (format nil "~A::~A"
                   (package-name (symbol-package symbol))
                   (symbol-name symbol))
           package)))
