

#include <windows.h>
#include <mapi.h>
#include <stdio.h>

#include "send_email.h"

void get_recipient(const char *name, ULONG recipClass, MapiRecipDesc *desc, lpMapiRecipDesc *desc_lookup);

int send_email(const char *sendname, 
               const char *recvname, 
               const char *ccname, 
               const char *subj,
               const char *body,
               const char *path)
{
    FLAGS flags;
    MapiMessage msg;
    ULONG send_res;
    MapiRecipDesc orig;
    MapiRecipDesc recips[2];
    MapiRecipDesc *orig_lookup, *recip_lookup, *cc_lookup;
    int num_recip = 1, return_code = -1;
    MapiFileDesc attachment;
    MapiFileTagExt file_type;
    const char *filename;
    char *attachment_path = 0;


    LHANDLE session;
    /* logon seems to be necessary for outlook express, sometimes,
       and doesn't seem to hurt, otherwise.
     */
    MAPILogon(0, 0, 0, MAPI_LOGON_UI, 0, &session);

    
    orig_lookup = recip_lookup = cc_lookup = NULL;
    
    get_recipient(sendname, MAPI_ORIG, &orig, &orig_lookup);
    get_recipient(recvname, MAPI_TO, &recips[0], &recip_lookup);

    if (ccname && strlen(ccname) > 0) {
        get_recipient(ccname, MAPI_CC, &recips[1], &cc_lookup);
        num_recip++;
    }

    memset(&msg, 0, sizeof(msg));
    msg.lpOriginator = &orig;
    msg.lpRecips = recips;
    msg.lpszMessageType = "text/plain";
    msg.lpszNoteText = (LPSTR) body;
    msg.lpszSubject = (LPSTR)subj;
    msg.nRecipCount = num_recip;
    msg.flFlags = 0;

    if (path) {
        attachment_path = strdup(path);
        /* convert / to \  (thunderbird doesn't like /) */
        char *p = attachment_path;
        while ((p = strchr(p, '/')))
            *p = '\\';

        /* find filename */
        filename = strrchr(attachment_path, '\\');
        if (filename == 0)
            filename = attachment_path;
        else
            filename++;

        memset(&attachment, 0, sizeof(attachment));
        attachment.nPosition = -1;
        attachment.lpszPathName = (LPTSTR)attachment_path;
        attachment.lpszFileName = (LPTSTR)filename;

        attachment.lpFileType = &file_type;
        
        memset(&file_type, 0, sizeof(file_type));
        file_type.lpTag = "text/plain";
        file_type.cbTag = sizeof(file_type.lpTag);

        msg.nFileCount = 1;
        msg.lpFiles = &attachment;
    }

    flags = 0;
    send_res = MAPISendMail(0, 0, &msg, flags, 0);

    if (send_res == SUCCESS_SUCCESS)
        return_code = 0;
    else
        fprintf(stderr, "MAPISendMail returned %ld\n", send_res);

    
    if (orig_lookup) MAPIFreeBuffer(orig_lookup);
    if (recip_lookup) MAPIFreeBuffer(recip_lookup);
    if (cc_lookup) MAPIFreeBuffer(cc_lookup);
    if (attachment_path) free(attachment_path);

    MAPILogoff(session, 0, 0, 0);
    return return_code;
}

void get_recipient(const char *name, ULONG recipClass, MapiRecipDesc *desc, lpMapiRecipDesc *desc_lookup) {
    ULONG ret = MAPIResolveName(0, 0, (LPSTR) name, 0, 0, desc_lookup);
    if (ret == SUCCESS_SUCCESS) {
        memcpy(desc, *desc_lookup, sizeof(MapiRecipDesc));
    } else {
        /* Default to something sensible if MAPIResolveName is not supported 
         * by the mail client (thunderbird)
         */
        memset(desc, 0, sizeof(MapiRecipDesc));
        desc->lpszName = (LPSTR)name;
        desc->lpszAddress = (LPSTR)name;
        desc->lpEntryID = 0;
        desc->ulEIDSize = 0;
    }
    desc->ulRecipClass = recipClass;
}

