#ifndef EDV_DATE_H
#define EDV_DATE_H


/*
 *      Date Relativity:
 */
typedef enum {
        EDV_DATE_RELATIVITY_ABSOLUTE,	/* Relative to christian time */
        EDV_DATE_RELATIVITY_CURRENT	/* Relative to current time */
} edv_date_relativity;


/*
 *	Returns a statically allocated string describing the date &
 *	time.
 *
 *	The format and relativity of the date & time is specified by    
 *	the configuration on the context.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The t specifies the time in seconds since EPOCH.
 */
extern const gchar *EDVDateString(
	edv_context_struct *ctx,
	const gulong t
);

/*
 *	Returns a statically allocated string describing the duration
 *	(delta time or time lapsed).
 *
 *	The format and relativity of the date & time is specified by
 *	the configuration on the context.
 *
 *	The ctx specifies the Endeavour 2 Context.
 *
 *	The dt specifies the delta time in seconds.
 */
extern const gchar *EDVDateStringDuration(
	edv_context_struct *ctx,
	const gulong dt
);


#endif	/* EDV_DATE_H */
