/*
                 Device Mounting, Unmounting, and Ejecting
 */

#ifndef EDV_DEVICE_MOUNT_H
#define EDV_DEVICE_MOUNT_H

#include <glib.h>
#include "edv_device.h"
#include "edv_context.h"


/*
 *	Returns a string describing the last error encountered or NULL
 *	if there was no error.
 *
 *	The returned pointer must not be modified or deleted.
 */
extern const gchar *EDVDeviceMountGetError(void);

/*
 *	Mounts the specified device.
 *
 *	If notify is set to TRUE then a "object_mounted_notify" will
 *	be queued on the context (only on success).
 *
 *	Returns 0 on success and non-zero on error.
 */
extern gint EDVDeviceMount(
	edv_context_struct *ctx, edv_device_struct *d,
	gboolean notify
);

/*
 *	Unmounts the specified device.
 *
 *	If notify is set to TRUE then a "object_unmounted_notify" will
 *	be queued on the context (only on success).
 *
 *	Returns 0 on success and non-zero on error. 
 */
extern gint EDVDeviceUnmount(
	edv_context_struct *ctx, edv_device_struct *d,
	gboolean notify
);

/*
 *	Ejects the media from the specified device.
 *
 *	If the device is mounted then you must call EDVUnmount() to
 *	unmount the device before ejecting it.
 *
 *	Returns 0 on success and non-zero on error.
 */
extern gint EDVDeviceEject(
	edv_context_struct *ctx, edv_device_struct *d
);


/*
 *	2.5.x or older depreciated calls:
 */
extern const gchar *EDVMountGetError(void);
extern gint EDVMount(
	edv_context_struct *ctx, edv_device_struct *d,
	gboolean notify
);
extern gint EDVUnmount(
	edv_context_struct *ctx, edv_device_struct *d,
	gboolean notify
);
extern gint EDVEject(
	edv_context_struct *ctx, edv_device_struct *d
);


#endif	/* EDV_DEVICE_MOUNT_H */
