# -*- coding: utf-8 -*-
#
#  Epiphany extension: coloured tabs
#  Version 0.1 (written in an evening, can be hugely improved)
#  Copyright (C) 2007 Thomas Thurman <tthurman@gnome.org>
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#

import epiphany
import gnomevfs
import gtk
import gtk.gdk
import md5

def _colour_the_tab(tab, data=None):
    url = tab.get_address()
    try:
        host = gnomevfs.URI(url).host_name.split('.')
    except:
        return # ah, forget it. probably about:mozilla or something

    if len(host)==0:
        return # weird
    elif len(host)==1:
        # one element; assume a machine on the local net; use that
        domain = host[0]
    else:
        # use the penultimate one in *most* cases, but there are
        # some top-level domains where the third level is the
        # most important.

        if host[-1] in ['uk', 'in', 'au']:
            domain = host[-3]
        else:
            domain = host[-2]

    # So we have the name to use. Turn it into a colour.
    # Save ourselves some complexity by using MD5.
    colour = md5.md5(domain).hexdigest()[:6]

    notebook = tab.get_parent()

    hbox = notebook.get_tab_label(tab)
    eb = gtk.EventBox()
    newhbox = gtk.HBox()

    colour = hbox.get_colormap().alloc_color("#"+colour)

    for state in (gtk.STATE_NORMAL, gtk.STATE_ACTIVE, gtk.STATE_SELECTED,
                  gtk.STATE_INSENSITIVE, gtk.STATE_PRELIGHT):
        eb.modify_bg(state, colour)

    for child in hbox.get_children():
        packing = hbox.query_child_packing(child)
        child.reparent(newhbox)
        newhbox.set_child_packing(child, *packing)

    hbox.add(eb)
    eb.add(newhbox)
    hbox.show_all()

def attach_tab(window, tab):
    _colour_the_tab (tab)
    tab._colour_tab_handler = tab.connect("dom-content-loaded", _colour_the_tab)
    # we don't call through like this when things are loaded
    # and we should

def detach_tab(window, tab):
    if '_colour_tab_handler' in tab:
        tab.disconnect(tab._colour_tab_handler)
        del tab._colour_tab_handler
