package GCPlugins::GCAllocine;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

use strict;
use utf8;

use GCPlugins::GCPluginsBase;

{
    package GCPlugins::GCPluginAllocine;

    use base qw(GCPluginParser);
 
    sub start
    {
		my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
		$self->{inside}->{$tagname}++;

        if ($self->{parsingList})
        {
            if ($tagname eq "a")
            {

                if (($attr->{href} =~ /^\/film\/fichefilm_gen_cfilm=/) && ($self->{inside}->{h4}))
                {
                    my $url = $attr->{href};
                    $self->{isMovie} = 1;
                    $self->{isInfo} = 0;
                    $self->{movieIdx}++;
                    $self->{movieList}[$self->{movieIdx}]->{"url"} = $url;
                }
            }
        }
        else
        {
           if ($tagname eq "h4")
           {
               $self->{insideActors} = 0;
               $self->{insideDirector} = 0;
               if ($attr->{style} =~ /color:#D20000/)
               {
                   $self->{insideAge} = 1;
               }
               else
               {
                   $self->{insideAge} = 0;
               }
           }
           elsif ($tagname eq "img")
           {
               my $src = $attr->{src};
               if (!$self->{curInfo}->{image})
               {
                   if ($src =~ /\/nmedia\//)
                   {
                       $self->{curInfo}->{image} = $src;
                   }
                   elsif ($src =~ /AffichetteAllocine\.gif/)
                   {
                       $self->{curInfo}->{image} = "empty";
                   }
               }
           }
		   elsif ($tagname eq "br")
		   {
		       if ($self->{insideSynopsis})
		       {
			   $self->{curInfo}->{synopsis} .= '<br>';
		       }
		   }

        }
    }

    sub end
    {
		my ($self, $tagname) = @_;
		
		$self->{inside}->{$tagname}--;

        if ($tagname eq "h4")
        {
            $self->{insideSynopsis} = 0;
        }
    }

    sub text
    {
        my ($self, $origtext) = @_;

        if ($self->{parsingList})
        {
            if ($self->{isMovie})
            {
                $self->{movieList}[$self->{movieIdx}]->{"title"} = $origtext;
                $self->{isMovie} = 0;
                $self->{isInfo} = 1;
                return;
            }

            if ($self->{inside}->{h4})
            {
                my $element = undef;
                if ( $origtext =~ /^ de/ )
                {
                    $origtext =~ s/^ de //;
                    $element = "director";
                }
                elsif (( $origtext =~ m/^ avec/ ) && (!$self->{movieList}[$self->{movieIdx}]->{actors}))
                {
                    $origtext =~ s/ avec //;
                    $element = "actors";
                }
                elsif ( $origtext =~ /^ \([0-9]{4}\)/ )
                {
                    $origtext =~ s/ \(([0-9]{4})\)/$1/;
                    $element = "year";
                    $self->{isInfo} = 0;
                }
                $self->{movieList}[$self->{movieIdx}]->{$element} = $origtext if $element;
            }
            if ($self->{inside}->{h5})
            {
                if ( ( $origtext =~ /^ \(.*?\)/ ) && ($self->{isInfo}) )
                {
                    $origtext =~ s/^ \((.*?)\)/$1/;
                    $self->{movieList}[$self->{movieIdx}]->{"orig"} = $origtext;
                }
            }
        }
        else
        {
            if (($self->{inside}->{h1}) && !($self->{inside}->{script}))
            {
                $origtext =~ s/[\r\n]//g;
                $self->{curInfo}->{title} = $origtext if length($origtext) > 2;
            }
            if ($self->{inside}->{h3})
            {
                $self->{insideSynopsis} = 1 if $origtext =~ /Synopsis/
            }
            if ($self->{inside}->{h4})
            {
                if ($self->{insideSynopsis})
                {
                    $self->{curInfo}->{synopsis} .= $origtext;
                }
                elsif ($self->{insideActors})
                {
                    $self->{curInfo}->{actors} .= $origtext;
                    $self->{curInfo}->{actors} =~ s/^\s*//;
                }
                elsif ($self->{insideDirector})
                {
                    $self->{curInfo}->{director} .= $origtext;
                }
                elsif ($self->{insideAge})
                {
                    $origtext =~ s/.*?([0-9]+).*/$1/;
                    $self->{curInfo}->{age} = $origtext;
                }
                elsif ( $origtext =~ /^Genre/ )
                {
                    $origtext =~ s/^Genre : //;
                    $origtext =~ s/, /,/g;
                    $self->{curInfo}->{type} = lc $origtext;
                }
                elsif (( $origtext =~ /^Film / ) && (!$self->{curInfo}->{nat}))
                {
                    $origtext =~ s/^Film //;
                    $self->{curInfo}->{nat} = $origtext;
                }
                elsif ( $origtext =~ /^Durée/ )
                {
                    $origtext =~ s/^Durée : (.*)?/$1/;
                    $self->{curInfo}->{time} = $origtext;
                }
                elsif ( $origtext =~ /^Date de sortie/ )
                {
                    $origtext =~ s/Date de sortie : (.*)/$1/;
                    $origtext =~ s/\s*$//;
                    $self->{curInfo}->{date} = $origtext;
                }
                elsif ( $origtext =~ /^Titre original/ )
                {
                    $origtext =~ s/^Titre original : .*?/$1/;
                    $self->{curInfo}->{orig} = $origtext;
                }
                elsif (($origtext =~ /^Avec/ ) && (! $self->{curInfo}->{actors}))
                {
                    $self->{insideActors} = 1;
                }
                elsif ( $origtext =~ /^Réalisé par/ )
                {
                    $self->{insideDirector} = 1;
                }
           }
        }
    }

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;

        bless ($self, $class);
        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;
        $html =~ s/&nbsp;/ /gi;
        $html =~ s/<b>|<strong>|<\/b>|<\/strong>|<i>|<\/i>//gi;
        
        #Remove links for genre
        $html =~ s|<a href="/film/alaffiche_genre_gen_genre.*?>(.*?)</a>|$1|gi;
        #"
        
        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
		return "http://www.allocine.fr/recherche/?motcle=$word&f=3&rub=1";
    }
    
    sub getMovieUrl
    {
		my ($self, $url) = @_;
		
		return "http://www.allocine.fr".$url;
    }

    sub getName
    {
        return "Allocine.fr";
    }
    
    sub getImageFile
    {
        return "allocine.png";
    }

    sub getAuthor
    {
        return 'Tian';
    }
    
    sub getLang
    {
        return 'FR';
    }
    
    sub getCharset
    {
        return "ISO-8859-1";
    }
}

1;
