package GCPlugins::GCAmazonFR;

###################################################
#
#  Copyright 2005 Tian
#
#  This file is part of GCfilms.
#
#  GCfilms is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  GCfilms is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with GCfilms; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###################################################

###################################
#														   #
#			Plugin soumis par MeV			   #
#														   #
###################################

use strict;

use GCPlugins::GCPluginsBase;

{
    package GCPlugins::GCPluginAmazonFR;

    use base qw(GCPluginParser);

    sub start
    {
        my ($self, $tagname, $attr, $attrseq, $origtext) = @_;
	
        $self->{inside}->{$tagname}++;

        if ($self->{parsingList})
        {
            if ($tagname eq "b")
            {
                if ($attr->{class} eq 'h3color')
                {
                    $self->{insideH3Color} = 1;
                }
                else
                {
                    $self->{insideH3Color} = 0;
                }
            }
            return if ! $self->{parsingRealList};
            
            if ($tagname eq "a")
            {
                if ($attr->{href} =~ /^\/exec\/obidos\/ASIN\/[A-Z0-9]*\/qid=/)
                {
                    my $url = $attr->{href}; 
                    $self->{isMovie} = 1;
                    $self->{isInfo} = 1;
                    $self->{movieIdx}++;
                    $self->{movieList}[$self->{movieIdx}]->{"url"} = $url;
                }
            }
            elsif ($tagname eq "div")
            {
                $self->{isActors} = 1 if $attr->{class} eq "actors";
                $self->{isYear} = 1 if $attr->{class} eq "year";
            }
        }
        else
        {
            if ($tagname eq "a")
            {
                if ($attr->{href} =~ /^http\:\/\/images-eu\.amazon\.com\/images\/P\/[A-Z0-9]*\.[0-9]*\.LZZZZZZZ\.jpg/)
                {
                    $self->{curInfo}->{image} = $attr->{href};
                }
            }
            elsif ($tagname eq "b")
            {
                $self->{insideName} = 1 if $attr->{class} eq "sans";
            }
            elsif ($tagname eq "div")
            {
                $self->{insideSynopsis} = 1 if $attr->{class} eq "synopsis";
            }
            elsif ($tagname eq "span")
            {
                $self->{insideInfos} = 1 if $attr->{class} eq "small";
            }
        }
    }

    sub end
    {
		my ($self, $tagname) = @_;

        $self->{inside}->{$tagname}--;
    }

    sub text
    {
        my ($self, $origtext) = @_;

        return if length($origtext) < 2;
           
        if ($self->{parsingList})
        {
            $self->{parsingRealList} = 1
                if ($self->{insideH3Color}) && ($origtext =~ /Sorties fran.aises/);

            return if ! $self->{parsingRealList};
            if ($self->{isMovie})
            {
                $origtext =~ s/\n//g;
                $origtext =~ s/^\s*//;
                $self->{movieList}[$self->{movieIdx}]->{"title"} = $origtext;
                $self->{isMovie} = 0;
                $self->{isInfo} = 1;
                return;
            }
            elsif ($self->{isYear})
            {
                $self->{movieList}[$self->{movieIdx}]->{"year"} = $origtext;
                $self->{isYear} = 0;
            }
            elsif ($self->{isActors})
            {
                $self->{movieList}[$self->{movieIdx}]->{"actors"} = $origtext;
                $self->{isActors} = 0;
            }
        }
       	else
        {
            $origtext =~ s/\s{2,}//g;
            $origtext =~ s/\n//g if !$self->{insideSynopsis};

           	if ($self->{insideName})
           	{
							$origtext =~ s/\[endline\]//g;
          	  $self->{curInfo}->{title} = $origtext if !$self->{curInfo}->{title};
							$self->{insideName} = 0;
						}
            elsif ($self->{insideSynopsis})
            {
							$origtext =~ s/\[endline\]/\n/g;
            	$origtext =~ s/^\n*//g;
		          $self->{curInfo}->{synopsis} = $origtext;
							$self->{insideSynopsis} = 0;
						}
						elsif ($self->{insideInfos})
						{
            	if ($origtext =~ /Titre Original.\:.([^\[]*)\[endline\]/)
            	{
		        	  $self->{curInfo}->{orig} = $1;
							}
            	elsif ($origtext =~ /Date de parution.\:.([^\[]*)\[endline\]/)
            	{
		       	 	  $self->{curInfo}->{date} = $1;
							}
           	 	elsif ($origtext =~ /Origine.\:.([^\[]*)\[endline\]/)
           	 	{
		       	 	  $self->{curInfo}->{nat} = $1;
					   	}
           	 	if ($origtext =~ /Avec.\:.([^\[]*)\[endline\](?:.R.alisateur.\:.([^\[]*)\[endline\])?/)
           	 	{
		       	 	  $self->{curInfo}->{actors} = $1;
		       	 	  $self->{curInfo}->{director} = $2;
					   	}
						}
        }
    } 

    sub new
    {
        my $proto = shift;
        my $class = ref($proto) || $proto;
        my $self  = $class->SUPER::new();
        bless ($self, $class);

        $self->{isInfo} = 0;
        $self->{isMovie} = 0;
        $self->{curName} = undef;
        $self->{curUrl} = undef;
        $self->{parsingRealList} = 0;

        return $self;
    }

    sub preProcess
    {
        my ($self, $html) = @_;

        $html =~ s/&#8211;/-/g;
        $html =~ s/<b class="h1">([^<]*)<\/b>/$1/g;
        $html =~ s/<b>|<\/b>|<i>|<\/i>|<span class="(small|serif)">|<\/span>|<\/form>//gi;
        $html =~ s/<a href=\/exec\/obidos\/ASIN\/[A-Z0-9]*\/qid=[0-9]*\/sr=[0-9]*-[0-9]*\/ref=sr_[0-9]*_[0-9]*_[0-9]*\/[0-9]*-[0-9]*-[0-9]*><img src="http\:\/\/images-eu\.amazon\.com\/images\/[A-Z]\/([A-Z0-9]*\.[0-9]*\.THUMBZZZ\.jpg|[0-9]*\/x-site\/icons\/no-img-sm\.gif)" width=[0-9]* height=[0-9]* border=0><\/a>//g;
        $html =~ s/<a href=\/exec\/obidos\/ASIN\/[A-Z0-9]*\/qid=[0-9]*\/sr=[0-9]*-[0-9]*\/ref=sr_[0-9]*_[0-9]*_[0-9]*\/[0-9]*-[0-9]*-[0-9]*><font size=-2>Voir l'image<\/font><\/a>//g;
        #'
        $html =~ s/<a href=\/exec\/obidos\/ASIN\/[A-Z0-9]*\/qid=[0-9]*\/sr=[0-9]*-\/ref=sr_[0-9]*_[0-9]*_\/[0-9]*-[0-9]*-[0-9]*><font ?=verdana,arial,helvetica>[^<]*<\/font><\/a>//g;
        $html =~ s/<\/a>\n\(([0-9]{1,2}? ?\S* ?[0-9]{4})\)\n/<\/a>\n<div class="year">$1<\/div>\n/g;
        $html =~ s/<br> ([^<]*)\n--\n[A-Z]*\n<br> <font ([^>]*)>/<div class="actors">$1<\/div>\n<font $2>/g;
        $html =~ s/<\/a>\n-- ([^<]*)\n--\n[A-Z]*\n<br>\n<font ([^>]*)/<div class="actors">$1<\/div>\n<font $2>/g;
        $html =~ s/<p>|<\/p>|<br>/\[endline\]/gi;
        $html =~ s/<a href="?\/exec\/obidos\/ASIN\/[A-Z0-9]*\/[0-9]*-[0-9]*-[0-9]*"?>([^<]*)<\/a>/$1/g;
        $html =~ s/<img src="http\:\/\/g-images\.amazon\.com\/images\/[^"]*"[^>]*>//g;
        #"
        $html =~ s/<a href="?\/exec\/obidos\/tg\/?[a-z0-9]*\/detail\/-\/?[a-z0-9]*\/[A-Z0-9]*\/?[a-z0-9]*\/[0-9]*-[0-9]*-[0-9]*[^>]*"?>([^<]*)<\/a>/$1/g;
        $html =~ s/<a name="[a-z0-9]*">//g;
        $html =~ s/<a name="amzn-reviews">Chroniques et points de vue\[endline\]<\/a>([^<]*)/<div class="synopsis">$1<\/div>\n/g;
        $html =~ s/<a href="\/exec\/obidos\/search-handle-url\/index=dvd-fr&field-(?:actor|director)=[^\/]*\/[0-9]*-[0-9]*-[0-9]*">([^<]*)<\/a>/$1/g;

        return $html;
    }
    
    sub getSearchUrl
    {
		my ($self, $word) = @_;
	
        return "http://www.amazon.fr/exec/obidos/search-handle-url/index=dvd-fr&field-keywords=$word/402-8537922-2237709";
    }
    
    sub getMovieUrl
    {
		my ($self, $url) = @_;
		
        return "http://www.amazon.fr" . $url;
    }

    sub getName
    {
        return "Amazon.fr";
    }
    
    sub getImageFile
    {
        return "amazon.fr.png";
    }

    sub getAuthor
    {
        return 'MeV';
    }

    sub getLang
    {
        return 'FR';
    }

    sub hasSearchDirector
    {
        return 0;
    }
}

1;
