module GnomeArt
  module Config

    Backgrounds_gnome = 10
    Backgrounds_other = 11
    Backgrounds_all = 12

    Desktop_themes_application = 20
    Desktop_themes_window_border = 21
    Desktop_themes_icons = 22

    Other_themes_login_manager = 30
    Other_themes_splash_screens = 31
    Other_themes_gtk_plus_engines = 32

    Nothing = 0

    Category_dirs = Hash.new("themes")

    Category_dirs[Backgrounds_gnome] = "backgrounds"
    Category_dirs[Backgrounds_other] = "backgrounds"
    Category_dirs[Backgrounds_all] = "backgrounds"

    Category_dirs[Desktop_themes_application] = "themes"
    Category_dirs[Other_themes_splash_screens] = "splashscreens"

    #XML_File = "http://art.thos.me.uk/xml.php"
    XML_File = "http://art.gnome.org/xml.php"

    Default_value = "(Unknown)"
 

    Resolution = Array.new
    Resolution[0] = "All"
    Resolution[1] = "800x600"
    Resolution[2] = "1024x768"

    Gnome_dir = '.gnome2'
    Program_dir = 'gnome-art'
    Home_dir = ENV["HOME"]
    Gnome_backgrounds = "#{Home_dir}/#{Gnome_dir}/backgrounds.xml"
    Temp_dir = "#{Home_dir}/#{Gnome_dir}/#{Program_dir}/tmp"
    Thumbnail_dir = "#{Home_dir}/#{Gnome_dir}/#{Program_dir}/thumbnails"
    GDM_theme_dir = "/usr/share/gdm/themes"
    No_thumbnail_image = "/usr/share/gnome-art/images/no-thumbnail.png"

  end
end
