# Copyright (C) 2005 Michael Gebhart
# 
# This file is part of Gnome-Art.
#
# Gnome-Art is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# Gnome-Art is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Gnome-Art; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

require 'gtk2'
require 'libglade2'

module GnomeArt
  class DownloadDialog

  	def method(handler, *other_args) 
  	  #puts handler
    	super(handler, *other_args)
  	end

    def show
      @download_dialog.show_all  
    end

    def hide
      @download_dialog.hide
    end

    def set_progressbar(count)
      @step_count = count
      @step = 0
      @progressbar_download.fraction = 0        
       @progressbar_download.text = "0 %"
    end

    def next_step
      set_progressbar_status(@step + 1)
    end

    def set_text(text)
      @label_download.text = text
    end

    def set_progressbar_status(step)
      @step = step
      @progressbar_download.fraction = (@step.to_f / @step_count)
       @progressbar_download.text = (@step.to_f * 100 / @step_count).to_i.to_s + " %"
    end

    def init_glade
    	  @glade = GladeXML.new("/usr/share/gnome-art/glade/download_dialog.glade", "download_dialog", nil, GladeXML::FILE) { |handler| method(handler) }

  		@download_dialog = @glade.get_widget("download_dialog")
      @progressbar_download = @glade.get_widget("progressbar_download")
      @label_download = @glade.get_widget("label_download")
    end

    def initialize(parent, text)
      init_glade
      
      @download_dialog.transient_for = parent
      #@download_dialog.title = title
      @label_download.text = text
    end
  end
end
