/*
 * GProFTPD - A GTK+ frontend for the ProFTPD standalone server.
 * Copyright (C) 2001 - 2006 Magnus Loef (Magnus-swe) <magnus-swe@telia.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
 */



#include "../config.h"
#include <gtk/gtk.h>
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "allocate.h"
#include "widgets.h"
#include "populate_servers.h"
#include "show_info.h"

extern char global_server_port[1024];
extern char global_server_name[1024];
extern char global_server_type[1024];



void populate_servers(struct w *widgets)
{
    /* Lists servers in the serverlist */
    FILE *fp;
    GtkTreeIter iter;
    GtkTreePath *path;
    char *old_buffer, *new_buffer;
    long conf_size;
    gboolean edit=0;
    int found=0;
    gchar *utf8=NULL;


    gtk_list_store_clear(widgets->server_store);


    /* Populate the serverlist */
    if((fp=fopen(PROFTPD_CONF, "r"))==NULL)
    {
	/* Dont show annoying popup */
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size=ftell(fp);
    rewind(fp);

    old_buffer = allocate(conf_size);
    new_buffer = allocate(conf_size);

    /* Add a row */
    gtk_list_store_append(GTK_LIST_STORE(widgets->server_store), &iter);

    /* Always append this for the default server */
    utf8 = g_locale_to_utf8("All interfaces", 14, NULL, NULL, NULL);
    gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 0, utf8, -1);


    /* List the default server first */
    if( conf_size > 1 )
    while(fgets(old_buffer, conf_size, fp)!=NULL)
    {
	if( strstr(old_buffer, "<VirtualHost ") || strstr(old_buffer, "<Anonymous "))
	  break;
	
	new_buffer[0]='\0';

	if( strstr(old_buffer, "Port ") && ! strstr(old_buffer, "PassivePorts ") && ! strstr(old_buffer, "standard") )
	{
	    /* Insert the ipaddress or hostname */
	    sprintf(new_buffer, "%s", &old_buffer[5]);
	    new_buffer[strlen(new_buffer)-1]='\0';
	    
	    /* Insert the port */
    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 1, utf8, -1);
	    
	    /* Insert the type */
    	    utf8 = g_locale_to_utf8("Default server", 14, NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 3, utf8, -1);
	}
	if( strstr(old_buffer, "ServerName ") || strstr(old_buffer, "ServerIdent on ") )
	{
    	    utf8 = g_locale_to_utf8("Default server", 14, NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 3, utf8, -1);

    	    if( strstr(old_buffer, "ServerIdent on ") )
	    {
		sprintf(new_buffer, "%s", &old_buffer[16]);
		new_buffer[strlen(new_buffer)-2]='\0';
    		utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    		gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 2, utf8, -1);
	    }
	    if( strstr(old_buffer, "ServerName ") )
	    {
		sprintf(new_buffer, "%s", &old_buffer[12]);
		new_buffer[strlen(new_buffer)-2]='\0';
    		utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    		gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 2, utf8, -1);
	    }
	}
    }		    
    /* End of listing the default server */



    /* List the VirtualHosts */

    found = 0;
    rewind(fp);

    if( conf_size > 1 )
    while(fgets(old_buffer, conf_size, fp)!=NULL)
    {
	if( strstr(old_buffer, "<VirtualHost ") )
	{
	    /* Add a row */
    	    gtk_list_store_append(GTK_LIST_STORE(widgets->server_store), &iter);

	    /* Insert the ipaddress or hostname */
	    sprintf(new_buffer, "%s", &old_buffer[13]);
	    new_buffer[strlen(new_buffer)-2]='\0';

    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 0, utf8, -1);

    	    utf8 = g_locale_to_utf8("Virtualhost", 11, NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 3, utf8, -1);
	    found = 1;
	}    

	if( ! found )
	  continue;

	if( strstr(old_buffer, "Port ") && ! strstr(old_buffer, "PassivePorts ") && ! strstr(old_buffer, "standard ") )
	{
	    /* Insert the ipaddress or hostname */
	    sprintf(new_buffer, "%s", &old_buffer[5]);
	    new_buffer[strlen(new_buffer)-1]='\0';

    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 1, utf8, -1);
	}    

	if( strstr(old_buffer, "ServerName ") )
	{
	    /* Insert the ipaddress or hostname */
	    sprintf(new_buffer, "%s", &old_buffer[12]);
	    new_buffer[strlen(new_buffer)-2]='\0';
    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 2, utf8, -1);
	}    

	if( strstr(old_buffer, "ServerIdent on ") )
	{
	    /* Insert the ipaddress or hostname */
	    sprintf(new_buffer, "%s", &old_buffer[16]);
	    new_buffer[strlen(new_buffer)-2]='\0';
    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 2, utf8, -1);
	}    
    }
    fclose(fp);
    free(old_buffer);
    free(new_buffer);
    if( utf8 !=NULL )
      g_free(utf8);


    /* We always append a line for the default server first.. so this wont crash */
    path = gtk_tree_path_new_first();
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->server_treeview), path, NULL, edit);
    gtk_tree_path_free(path);
}
