/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.SSLInputStream;
import com.sun.net.ssl.internal.ssl.SSLOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;

public final class ClientDiffieHellmanPublic
extends HandshakeMessage {
    public byte[] a;

    public ClientDiffieHellmanPublic() {
        this.a = null;
    }

    public ClientDiffieHellmanPublic(SSLInputStream sSLInputStream) throws IOException {
        this.a = sSLInputStream.a();
    }

    public ClientDiffieHellmanPublic(BigInteger bigInteger) {
        this.a = bigInteger.toByteArray();
    }

    public BigInteger getClientPublicKey() {
        return new BigInteger(1, this.a);
    }

    public int messageLength() {
        if (this.a == null) {
            return 0;
        }
        return this.a.length + 2;
    }

    public int messageType() {
        return 16;
    }

    public void a(PrintStream printStream) throws IOException {
        printStream.println("*** ClientDiffieHellmanPublic");
        if (HandshakeMessage.debug != null && Debug.isOn("verbose")) {
            printStream.print("DH Public key = { ");
            if (this.a == null) {
                printStream.print("<implicit in client cert>");
            } else {
                int n2 = 0;
                while (n2 < this.a.length) {
                    if (n2 != 0) {
                        printStream.print(", ");
                    }
                    printStream.print(this.a[n2] & 0xFF);
                    ++n2;
                }
            }
            printStream.println(" }");
        }
    }

    public void send(SSLOutputStream sSLOutputStream) throws IOException {
        sSLOutputStream.a(this.a);
    }
}

