/*******************************************************\
* irmp3-ncurses - An ncurses frontend for irmp3 using   *
* the Network Control Module                            *
* (C) 2005 Ross Axe                                     *
*                                                       *
* poll-sigio.c - I/O polling using SIGIO                *
\*******************************************************/

#if HAVE_CONFIG_H
#  include "config.h"
#endif

#if HAVE_UNISTD_H
#  include <unistd.h>
#endif
#include <signal.h>
#if HAVE_SYS_IOCTL_H
#  include <sys/ioctl.h>
#endif
#if HAVE_SYS_SOCKET_H
#  include <sys/socket.h>
#endif
#if HAVE_SIGNAL_H
#  include <signal.h>
#endif

#include "irmp3-ncurses.h"

vcid("$Id: poll-sigio.c,v 1.6 2005/03/21 08:50:54 ross Exp $");



static int sigio_sock;

static RETSIGTYPE sigio_handler(int signal)
{
    assert(signal == SIGIO);
    for(;;) {
	fd_set fds;
	struct timeval tv = {0, 0};

	FD_ZERO(&fds);
	FD_SET(sigio_sock, &fds);
	switch(select(sigio_sock + 1, &fds, NULL, NULL, &tv)) {
	case -1:
	    goto recv_err;
	case 0:
	    return (RETSIGTYPE)0;
	case 1:
	    if(!handle_net(sigio_sock)) {
	    recv_err:
		sbar_printf(_("Server shutdown"));
		return (RETSIGTYPE)0;
	    }
	}
    }
}


int main_poll_loop(int sock)
{
    sigset_t sigs;

    sigfillset(&sigs);
    sigprocmask(SIG_BLOCK, &sigs, NULL);

    sigio_sock = sock;
    signal(SIGIO, sigio_handler);
    {
	int val;

#ifdef SIOCSPGRP
	val = getpid();
	ioctl(sock, SIOCSPGRP, &val);
#endif
	val = true;
	ioctl(sock, FIOASYNC, &val);
    }

    for(;;) {
	int ch;

	sigprocmask(SIG_UNBLOCK, &sigs, NULL);
	ch = getch();
	sigprocmask(SIG_BLOCK, &sigs, NULL);
	if(!key_callback(sock, ch))
	    break;
    }

    signal(SIGIO, SIG_IGN);
    return 0;
}
