#!/bin/sh
#
# Irmp3 script execution example
#
# Command line parameters passed to any script executed by irmp3:
#
# $1 Temporary message file name
#
#    Information written to this file will be treat by irmp3.
#       First line:          will be diplayed on lcd after execution
#       All Following lines: will be treat as multiple normal irmp3 commands
#
# $2 Current browser's working directory
#
# $3 Current browser's cursor selection
#
# $4 Current browser's cursor selection type (one of the following key words)
#
#       keyword    meaning
#       ========   ========================
#
#       dir        directory
#       audio      music file
#       list       playlist file
#       listlist   playlist-list file
#       exec       script file
#       other      unknown file type
#
###############################################################################

#Get message passing file name
MSGFILE="$1"

#File that contains current mode (content is written by another script)
MODEFILENAME=/tmp/irmp3.mode.key-right
#Read current mode
MODE=`cat $MODEFILENAME`

#Display something on lcd and issue irmp3 commands depending on current mode
case "$MODE" in

    browser)	echo "Browser mode" 	>  "$MSGFILE"
		echo "browser into" 	>> "$MSGFILE"
		;;
    playback)	echo "Playback mode"	>  "$MSGFILE"
		echo "playlist jump +1"	>> "$MSGFILE"
		;;
    volume)	echo "Volume mode"	>  "$MSGFILE"
		echo "mixer vol +10"	>> "$MSGFILE"
		;;
    vbox)	#check if there are new messages
		if [ `ls /var/spool/vbox` != "" ]; then

		    #Display something on lcd
		    echo "New messages"				  >  "$MSGFILE"

		    #Issue irmp3 commands
		    echo "stop"					  >> "$MSGFILE"
		    echo "playlist loaddir /var/spool/vbox/*.mp3" >> "$MSGFILE"
		    echo "playlist jump 0"			  >> "$MSGFILE"

		else
		    echo "Sorry, no messages"			  >  "$MSGFILE"
		fi
		;;

    default)	echo "Unknown mode"	>  "$MSGFILE"
		;;

esac

#exit with return code "0"    
exit 0
