/*************************************************************************
 * 
 * irmp3 - Multimedia Audio Jukebox for Linux
 * http://irmp3.sourceforge.net
 *
 * $Source: /cvsroot/irmp3/irmp3/src/irmp3d/mod_radio.c,v $
 * -- module for the radio player
 * $Id: mod_radio.c,v 1.5 2004/02/17 20:40:36 boucman Exp $
 *
 * Copyright (C) by Andreas Neuhaus <andy@fasta.fh-dortmund.de>
 *
 * Please contact the current maintainer, Jeremy Rosen <jeremy.rosen@enst-bretagne.fr>
 * for information and support regarding irmp3.
 *
 *
 */

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/wait.h>

#include "config.h"
#include "irmp3tools.h"
#include "irmp3log.h"
#include "irmp3config.h"
#include "irmp3mod.h"
#include "mod_radio.h"

/*************************************************************************
 * GLOBALS
 */
#define RADIO_STATUS_HALT	0
#define RADIO_STATUS_STOP	1
#define RADIO_STATUS_PLAY	2
#define RADIO_STATUS_PAUSE	3
int  mod_radio_status = RADIO_STATUS_HALT;

/*************************************************************************
 * MODULE INFO
 */
mod_t mod_radio = {
	"mod_radio",
	mod_radio_deinit,	// deinit
	NULL,			// reload
	NULL,			// watchfd_set
	NULL,			// poll
	NULL,			// update
	mod_radio_message,	// message
	NULL,	// SIGCHLD handler
	NULL,
	NULL,			// avoid warning
};
/*************************************************************************
 * CATCH SIGNAL OF EXITING PLAYER
 */



/*************************************************************************
 * ANSWER A HALT REQUEST
 *
 */
void mod_radio_halt (void)
{
	system_block(0,NULL,NULL,"%s %s off",config_getstr("radio_binary",RADIO_PATH),config_getstr("fm_params", ""));
	mod_radio_status = RADIO_STATUS_HALT;
}

/******************************************
 * ANSWER A STOP REQUEST
 *
 */

void mod_radio_stop() 
{
	switch(mod_radio_status) {
		case RADIO_STATUS_HALT:
		case RADIO_STATUS_STOP:
			return;
		case RADIO_STATUS_PLAY:
		case RADIO_STATUS_PAUSE:
			system_block(0,NULL,NULL,"%s %s off",config_getstr("radio_binary",RADIO_PATH),config_getstr("fm_params", ""));
			mod_radio_status = RADIO_STATUS_STOP;
			log_printf(LOG_NORMAL, "Playing stopped\n");
			log_printf(LOG_NOISYDEBUG,"mod_radio : entered stop state\n");
			return;
		default:
			log_printf(LOG_ERROR,"mod_radio: unknown status %d\n",mod_radio_status);
			return;
	}
}
		

/******************************************
 * ANSWER A PLAY REQUEST
 *
 */
	
void mod_radio_play(char* frequency) {
	char *output;
	int out_fd;
	switch(mod_radio_status) {
		case RADIO_STATUS_HALT:
		case RADIO_STATUS_PAUSE:
		case RADIO_STATUS_STOP:
		case RADIO_STATUS_PLAY:
			system_block(0,&out_fd,NULL,"%s %s %s",config_getstr("radio_binary",RADIO_PATH),config_getstr("fm_parms",""),frequency);
			output = malloc(256);
			while(readline(out_fd,output,250) >= 0) {
				log_printf(LOG_ERROR,"%s\n",output);
				if (strstr(output,"out of range")){
					close(out_fd);
					mod_sendmsg(MSGTYPE_PLAYER,"error");
					return;
				}
			}
			free(output);
			close(out_fd);
			log_printf(LOG_NORMAL, "Playing radio frequency %s\n", frequency);
			mod_sendmsg(MSGTYPE_PLAYER,"playing");
			mod_sendmsg(MSGTYPE_PLAYER,"time -1 -1");
			mod_radio_status= RADIO_STATUS_PLAY;
			log_printf(LOG_NOISYDEBUG,"mod_radio : entered play state\n");
			return;
		default:
			log_printf(LOG_ERROR,"mod_radio: unknown status %d\n",mod_radio_status);
			return;
	}
}

	
/******************************************
 * ANSWER A PAUSE REQUEST
 *
 */
	
void mod_radio_pause() {
	switch(mod_radio_status) {
		case RADIO_STATUS_HALT:
		case RADIO_STATUS_STOP:
			return;
			
		case RADIO_STATUS_PAUSE:
			system_block(0,NULL,NULL,"%s %s on",config_getstr("radio_binary",RADIO_PATH),config_getstr("fm_params", ""));
			log_printf(LOG_NOISYDEBUG,"mod_radio : entered play state\n");
			mod_radio_status= RADIO_STATUS_PLAY;
			return;
			
		case RADIO_STATUS_PLAY:
			system_block(0,NULL,NULL,"%s %s off",config_getstr("radio_binary",RADIO_PATH),config_getstr("fm_params", ""));
			log_printf(LOG_NOISYDEBUG,"mod_radio : entered pause state\n");
			mod_radio_status= RADIO_STATUS_PAUSE;
			return;
		default:
			log_printf(LOG_ERROR,"mod_radio: unknown status %d\n",mod_radio_status);
			return;

	}
}

/******************************************
 * ANSWER A SEEK REQUEST
 *
 */
void mod_radio_seek() {
	switch(mod_radio_status) {
		case RADIO_STATUS_HALT:
		case RADIO_STATUS_STOP:
			return;
		case RADIO_STATUS_PLAY:
			log_printf(LOG_DEBUG,"mod_radio can not seek");
			return;
		case RADIO_STATUS_PAUSE:
			mod_radio_pause();
			return;
		default:
			log_printf(LOG_ERROR,"mod_radio: unknown status %d\n",mod_radio_status);
			return;

	}
}
/*************************************************************************
 * RECEIVE MESSAGE
 */
void mod_radio_message (int msgtype, char *msg,const char __attribute__((unused))*sender)
{
	char *c1, *c2, *c3,*tmp;
	mod_message_t *answer,*tmp_msg;

	if (msgtype == MSGTYPE_PLAYER) {
		c1 = strtok(msg, " \t");
		if(!c1) return;

		// see if we can play the requested song
		if ( !strcasecmp(c1, "play")) {
			c2 = strtok(NULL, " \t");
			if(!c2) return;
			if ( !strcasecmp(c2,"mod_radio") ) {
				c3 = strtok(NULL, "");
				while(c3 && !isdigit(*c3)) c3++;
				if(!c3) return;
				mod_radio_play(c3);
			} else {
					log_printf(LOG_DEBUG, "mod_radio_message(): not for me: '%s'\n", c2);
					mod_radio_halt();
			}
		} else if ( !strcasecmp(c1, "stop")) {
			mod_radio_stop();
		} else if ( !strcasecmp(c1, "pause")) {
			mod_radio_pause();

		} else if ( !strcasecmp(c1, "seek")) {
			mod_radio_seek();
		}
	} else if (msgtype == MSGTYPE_QUERY) {
		c1 = strtok(msg, " \t");
		if(!c1) return;
		if ( !strcasecmp(c1,"whocanplay")) {
			c2 =  strtok(NULL, "") ;
			if(  !strcasecmp(c2,"radio")) {
				mod_sendmsgf(MSGTYPE_INFO,"canplay mod_radio %s",c2);
			}
		} else if (!strcasecmp(c1,"titleguess")) {
			answer = mod_query(MSGTYPE_QUERY,"songcmd");
			while(answer) {
				if( answer->msgtype != MSGTYPE_INFO) {
					tmp_msg = answer;
					answer =  answer->next;
					free(tmp_msg->msg);
					free(tmp_msg);
					continue;
				}
				tmp = strdup(answer->msg);
				c1 = strtok(tmp," \t");
				if(!strcasecmp(c1,"songcmd")) {
					c1 = strtok(NULL," \t");
					if(!strcasecmp(c1,"radio")) {
						c1 = strtok(NULL,"");
						mod_sendmsgf(MSGTYPE_INFO,"title %s",c1);
					}
				} 
				free(tmp);
				tmp_msg = answer;
				answer =  answer->next;
				free(tmp_msg->msg);
				free(tmp_msg);
			}


		} else {
			if (mod_radio_status != RADIO_STATUS_HALT) {
				if(!strcasecmp(c1,"time"))    mod_sendmsgf( MSGTYPE_INFO,"time -1 -1");
			}
		}
	}
}




/*************************************************************************
 * MODULE DEINIT FUNCTION
 */
void mod_radio_deinit (void)
{
	mod_radio_halt();
	log_printf(LOG_DEBUG, "mod_radio_deinit(): deinitialized\n");
}


/*************************************************************************
 * EOF
 */
