#include "tabwidget.h"
#include <config_dialog.h>


TabWidget::TabWidget()
{
	tabbar=new TabBar();
	setTabBar((QTabBar*)tabbar);
	connect(tabbar, SIGNAL(contextMenu(int, const QPoint&)),
			SLOT(onContextMenu(int, const QPoint &)));
}

void TabWidget::closeEvent(QCloseEvent* e)
{
	kdebugf();
	QWidget* current=currentPage();
	delete current;

	if(count()>0)
		e->ignore();
	else
		e->accept();
}

void TabWidget::keyPressEvent(QKeyEvent* e)
{
//	int key=e->key();
	if(HotKey::shortCut(e, "Chat", "MoveTabLeft"))
		if(currentPageIndex()==0)
			onMoveTab(0, count()-1);
		else
			onMoveTab(currentPageIndex(), currentPageIndex()-1);
	else if(HotKey::shortCut(e, "Chat", "MoveTabRight"))
		if(currentPageIndex()==(count()-1))
			onMoveTab(count()-1, 0);
		else
			onMoveTab(currentPageIndex(), currentPageIndex()+1);
	else if(HotKey::shortCut(e, "Chat", "SwitchTabLeft"))
		if(currentPageIndex()==0)
			setCurrentPage(count()-1);
		else
			setCurrentPage(currentPageIndex()-1);
	else if(HotKey::shortCut(e, "Chat", "SwitchTabRight"))
		if(currentPageIndex()==(count()-1))
			setCurrentPage(0);
		else
			setCurrentPage(currentPageIndex()+1);
	e->accept();
}

void TabWidget::onContextMenu(int id, const QPoint& pos)
{
	kdebugf();
	emit contextMenu(page(id), pos);
}

void TabWidget::onMoveTab(int from, int to)
{
	kdebugf();
	qDebug("from==%i, to==%i\n", from, to);
	QString tablabel=label(from);
	QWidget *w=page(from);
	QIconSet tabiconset = tabIconSet(w);
	QString tabtooltip = tabToolTip(w);
	bool current=(w==currentPage());
	blockSignals(true);
	removePage(w);

	insertTab(w, tabiconset, tablabel, to);

	if(current)
		setCurrentPage(to);

	blockSignals(false);
}


void TabBar::mousePressEvent(QMouseEvent* e)
{
	QTab* selectedtab=selectTab(e->pos());
        if(selectedtab && (e->button()==RightButton))
		emit contextMenu(indexOf(selectedtab->identifier()), mapToGlobal(e->pos()));
	QTabBar::mousePressEvent(e);
}
