/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 **************************************************************************/

/**

Copyright (C) 2005 by 
	Pan Wojtas (Wojtek Sulewski)
	wojciech <  _at_    > sulewski.pl
	gg: 2087202

Na podstawie skryptu TCL autorstwoa Attis'a.
Cz kodu (atak flood i emotikonami) na podstawie aty amd_fanatyka

**/

#include "firewall.h"

#include <qmessagebox.h>
#include <qvgroupbox.h>	//setEnabled
#include <qhgroupbox.h>	//setEnabled
#include <qspinbox.h>	//setEnabled
#include <qcheckbox.h>	//setEnabled
#include <qgrid.h>	//setEnabled
#include <qtimer.h>	//singleShot

#include "../notify/notify.h"

#include "config_dialog.h"
#include "config_file.h"
#include "icons_manager.h"
#include "misc.h"
#include "search.h"
#include "kadu.h"
#include "chat_manager.h"

#include "debug.h"


Firewall *firewall;

extern "C" int firewall_init()
{
	firewall = new Firewall();
	return 0;
}

extern "C" void firewall_close()
{
	delete firewall;
	firewall = NULL;
}


Firewall::Firewall() : flood_messages(0), right_after_connection(false)
{
	kdebugf();
	
	loadSecuredList();

	createGUI();
	
	lastMsg.start();
	lastNotify.start();

	pattern.setCaseSensitive(false);
	pattern.setPattern(unicode2std(config_file.readEntry("Firewall", "answer", tr("I want something"))));

	connect(gadu, SIGNAL(messageFiltering(Protocol *, UserListElements, QCString&, QByteArray&, bool&)), this, SLOT(messageFiltering(Protocol *, UserListElements, QCString&, QByteArray&, bool&)));
	connect(chat_manager, SIGNAL(chatCreated(const UserGroup *)), this, SLOT(chatCreated(const UserGroup *)));
	connect(chat_manager, SIGNAL(chatDestroyed(const UserGroup *)), this, SLOT(chatDestroyed(const UserGroup *)));

	connect(userlist, SIGNAL(userDataChanged(UserListElement, QString, QVariant, QVariant, bool, bool)), this, SLOT(userDataChanged(UserListElement, QString, QVariant, QVariant, bool, bool)));
	connect(userlist, SIGNAL(userAdded(UserListElement, bool, bool)), this, SLOT(userAdded(UserListElement, bool, bool)));
	connect(userlist, SIGNAL(userRemoved(UserListElement, bool, bool)), this, SLOT(userRemoved(UserListElement, bool, bool)));

	
	connect(gadu, SIGNAL(connecting()), this, SLOT(connecting()));
	connect(gadu, SIGNAL(connected()), this, SLOT(connected()));
	
	
	kdebugf2();
	
}

Firewall::~Firewall()
{
	kdebugf();
	
	destroyGUI();

	disconnect(gadu, SIGNAL(messageFiltering(Protocol *, UserListElements, QCString&, QByteArray&, bool&)), this, SLOT(messageFiltering(Protocol *, UserListElements, QCString&, QByteArray&, bool&)));
	disconnect(chat_manager, SIGNAL(chatCreated(const UserGroup *)), this, SLOT(chatCreated(const UserGroup *)));
	disconnect(chat_manager, SIGNAL(chatDestroyed(const UserGroup *)), this, SLOT(chatDestroyed(const UserGroup *)));

	disconnect(userlist, SIGNAL(userDataChanged(UserListElement, QString, QVariant, QVariant, bool, bool)), this, SLOT(userDataChanged(UserListElement, QString, QVariant, QVariant, bool, bool)));
	disconnect(userlist, SIGNAL(userAdded(UserListElement, bool, bool)), this, SLOT(userAdded(UserListElement, bool, bool)));
	disconnect(userlist, SIGNAL(userRemoved(UserListElement, bool, bool)), this, SLOT(userRemoved(UserListElement, bool, bool)));
	
	disconnect(gadu, SIGNAL(connecting()), this, SLOT(connecting()));
	disconnect(gadu, SIGNAL(connected()), this, SLOT(connected()));
	
	
	kdebugf2();
	
}

void Firewall::messageFiltering(Protocol *protocol, UserListElements senders, QCString& msg, QByteArray& formats, bool& stop)
{
	kdebugf();
	
	const char* msg_c = msg;
	QString message = cp2unicode((const unsigned char*)msg_c);

	QString user;
	// czy senders.count() moe by < 1 ???
	if (senders.count() > 1)
		user = tr("conference") + " " + senders[0].ID("Gadu");
	else if (userlist->contains(senders[0], FalseForAnonymous))
		user = senders[0].altNick();
	else
		user = senders[0].ID("Gadu");
	
// emotikony s sprawdzane nawet przy czeniu
	const int min_interval_notify = 2000;
	
	if (config_file.readBoolEntry("Firewall", "dos_emoticons", true))
	{
		bool ignore = false;
		
		if (config_file.readBoolEntry("Firewall", "emoticons_allow_known", false))
		{
			ignore = true;
			CONST_FOREACH (i, senders)
			{
				if (!userlist->contains((*i), FalseForAnonymous))
				{
					ignore = false;
					break;
				}
			}
		}

		if (!ignore && checkEmoticons(message))
		{
			stop = true;
			if (lastNotify.elapsed() > min_interval_notify)
			{
				if (config_file.readBoolEntry("Firewall", "show_hint", true))
					showHint(user, tr("flooding DoS attack with emoticons!"));
				
				if (config_file.readBoolEntry("Firewall", "write_log", true))
				{
					if (message.length() > 50)
						writeLog(user, message.left(50) + "...");
					else
						writeLog(user, message);
				}
	
				lastNotify.restart();
			}
			kdebugf2();
			return;
		}
	}
	
// sprawdzanie, czy nie jest bezporednio po poczeniu z serwerm - wtedy moe by duo wiadomoci. Poza tym, nie ma sensu wysyania pytania do anonima, ktry napisa do nas kilka godzin/dni temu ;)
	
 	if (right_after_connection)
	{
		kdebugf2();
 		return;
	}
	
// atak floodem
	if (config_file.readBoolEntry("Firewall", "dos", true))
		if (checkFlood())
		{
			stop = true;
			if (lastNotify.elapsed() > min_interval_notify)
			{
				if (config_file.readBoolEntry("Firewall", "show_hint", true))
					showHint(user, tr("flooding DoS attack!"));
						
				if (config_file.readBoolEntry("Firewall", "write_log", true))
				{
					if (message.length() > 50)
						writeLog(user, message.left(50) + "...");
					else
						writeLog(user, message);
				}
			
				lastNotify.restart();
			}
			kdebugf2();
			return;
		}

// ochrona przed anonimami
		if (config_file.readBoolEntry("Firewall", "chats", true))
			if (checkChat(unicode2std(message), senders, user, stop))
			{
				stop = true;
				if (config_file.readBoolEntry("Firewall", "show_hint", true))
					showHint(user, message);
				if (config_file.readBoolEntry("Firewall", "write_log", true))
					writeLog(user, message);
				kdebugf2();
				return;
			}

// ochrona przed konferencjami
		if (config_file.readBoolEntry("Firewall", "ignore_conferences", true))
			if (checkConference(message, senders, user))
			{
				stop = true;
				if (config_file.readBoolEntry("Firewall", "show_hint", true))
					showHint(user, message);
				if (config_file.readBoolEntry("Firewall", "write_log", true))
					writeLog(user, message);
				
				kdebugf2();
				return;
			}


	kdebugf2();
}

bool Firewall::checkConference(QString message, UserListElements senders, QString user)
{
	kdebugf();
	
	CONST_FOREACH (i, senders)
	{
 		if (userlist->contains((*i), FalseForAnonymous) || passed.contains((*i)))
		{
			kdebugf2();
 			return false;
		}
	}
	
	kdebugf2();
	return true;
}

bool Firewall::checkChat(QString message, UserListElements senders, QString user, bool& stop)
{
	kdebugf();

	// konferencja
 	if (senders.count() > 1)
	{
		kdebugf2();
 		return false;
	}

 	if (userlist->contains(senders[0], FalseForAnonymous) || passed.contains(senders[0]))
	{
		kdebugf2();
 		return false;
	}

	if (pattern.exactMatch(message.stripWhiteSpace()))
	{
		passed.append(senders[0]);

		if (config_file.readBoolEntry("Firewall", "confirmation", true))
			gadu->sendMessage(senders, unicode2cp(config_file.readEntry("Firewall", "confirmation_text", tr("OK, now say hello, and introduce yourself ;-)"))));
		
		if (config_file.readBoolEntry("Firewall", "write_log", true))
			writeLog(user, tr("User wrote right answer!\n") + "----------------------------------------------------\n");
		
		stop = true;
		
		kdebugf2();
		return false;
	}
	else
	{
		if (last_uin != user && config_file.readBoolEntry("Firewall", "search", true))
		{
			SearchDialog *sd;
	
			sd = new SearchDialog(0, "User info", user.toUInt());
			sd->show();
			sd->firstSearch();
			
			last_uin = user;
		}
		
		kdebugm(KDEBUG_INFO, "%s\n", QString(message).local8Bit().data());
		
		gadu->sendMessage(senders, unicode2cp(config_file_ptr->readEntry("Firewall", "question", tr("This message has been generated AUTOMATICALLY!\n\nI'm a busy person and I don't have time for stupid chats. Find another person to chat with. If you REALLY want something from me, simple type \"I want something\" (capital doesn't matter)"))));
		
		kdebugf2();
		return true;
	}
}

bool Firewall::checkFlood()
{
	kdebugf();
	
	const int min_interval = config_file.readNumEntry("Firewall", "dos_interval", 500); // minimalna przerwa czasowa miedzy przeslaniem 2 kolejnych wiadomosci
	const unsigned int max_flood_messages = 15;
		
	if (lastMsg.restart() >= min_interval)
	{
		flood_messages = 0;
		kdebugf2();
		return false;
	}

	if (flood_messages < max_flood_messages)
	{
		flood_messages++;
		kdebugf2();
		return false;
	}

	kdebugf2();
	return true;
}

bool Firewall::checkEmoticons(QString& message)
{
	kdebugf();
	
	const unsigned int max_occ = config_file.readNumEntry("Firewall", "emoticons_max", 15); // maksymalna laczna ilosc wystapien emotikon

	QStringList emots;
	emots << "<" << ":)" << ":(" << ":-(" << ";)" << ":[" << "wrrrr!" << "niee" << "tiaaa" << ":-)" << ";-)" << ":P" << ":-P" << ";P" << ";-P" << "!!" << "??" << ";(" << ";-(" << ":D" << ":-D" << ";D" << ";-D" << ":O" << ":-O" << ";O" << ";-O" << ":>" << ";>" << ":->" << ";->" << ":|" << ";|" << ":-|" << ";-|" << ":]" << ";]" << ":-]" << ";-]" << ":/" << ";/" << ":-/" << ";-/" << ":*" << ":-*" << ";*" << ";-*" << "]:->";
		
		
	unsigned int occ = 0;
	CONST_FOREACH(i, emots)
	{
		occ += message.contains((*i));
	}


	kdebugf2();
	return (occ > max_occ);
}

void Firewall::userDataChanged(UserListElement elem, QString name, QVariant oldValue, QVariant currentValue, bool massively, bool last)
{
	if(name == "Anonymous" && currentValue.toBool() == false)
	{
		secured.append(elem.ID("Gadu"));
		saveSecuredList();
	}
}

void Firewall::userAdded(UserListElement elem, bool mas, bool last)
{
	if(!elem.isAnonymous())
	{
		secured.append(elem.ID("Gadu"));
		saveSecuredList();
	}
}

void Firewall::userRemoved(UserListElement elem, bool mas, bool last)
{
	if (secured.contains(elem.ID("Gadu")))
	{
		secured.remove(elem.ID("Gadu"));
		saveSecuredList();
	}

}

void Firewall::connecting()
{
	kdebugf();
	
	right_after_connection = true;

	kdebugf2();
}

void Firewall::connected()
{
	kdebugf();
	
	QTimer::singleShot(4000, this, SLOT(changeRight_after_connection()));

	kdebugf2();
}

void Firewall::changeRight_after_connection()
{
	kdebugf();
	
	right_after_connection = !right_after_connection;

	kdebugf2();
}

void Firewall::chatCreated(const UserGroup *group)
{
	kdebugf();

	Chat* chat = chat_manager->findChat(group);
	connect(chat, SIGNAL(messageFiltering(const UserGroup *, QCString &, bool &)), this, SLOT(sendMessageFilter(const UserGroup *, QCString &, bool &)));
	
	//TODO: trzeba disconn?

	kdebugf2();
}

void Firewall::chatDestroyed(const UserGroup *group)
{
	kdebugf();

	CONST_FOREACH (i, *group)
	{
		if (secured_temp_allowed.contains((*i).ID("Gadu")))
			secured_temp_allowed.remove((*i).ID("Gadu"));
	}

	kdebugf2();
}

void Firewall::sendMessageFilter(const UserGroup *users, QCString &msg, bool &stop)
{
	kdebugf();
	
	CONST_FOREACH (i, *users)
	{
		if (!userlist->contains((*i), FalseForAnonymous))
			passed.append((*i));
	}
	
	if (config_file.readBoolEntry("Firewall", "safe_sending", false))
	{
		CONST_FOREACH (i, *users)
		{
			if (secured.contains((*i).ID("Gadu")) && !secured_temp_allowed.contains((*i).ID("Gadu")))
			{
				switch (QMessageBox::warning(0, "Kadu", tr("Are you sure you want to send this message?"), tr("&Yes"), tr("Yes and allow until chat closed"), tr("&No"), 2, 2))
				{
						default:
							stop = true;
							return;
						case 0:
							return;
						case 1:
							secured_temp_allowed.append((*i).ID("Gadu"));
							return;
				}
				
			}
		}
	}
	
	
	kdebugf2();
}

void Firewall::showHint(QString u, QString m)
{
	kdebugf();
	
	QMap<QString,QVariant> parms;
	parms["Pixmap"] = icons_manager->loadIcon(dataPath("kadu/modules/data/firewall/firewall.png"));
	parms["ShowSource"] = bool(FALSE);
	QColor navy("navy");
	QColor lightblue("lightblue");
	parms["Foreground color"] = config_file.readColorEntry("Firewall", "fg_color", &navy);
	parms["Background color"] = config_file.readColorEntry("Firewall", "bg_color", &lightblue);
	parms["Timeout"] = config_file.readUnsignedNumEntry("Firewall", "hint_timeout", 3);

	UserListElement user = userlist->byID("Gadu", u);
	notify->emitMessage(QString::null, QString::null, config_file.readEntry("Firewall", "hint_syntax", tr("%u writes: %m")).replace("%u", u).replace("%m", m), &parms, &user);
	
	kdebugf2();
}

void Firewall::writeLog(QString u, QString m)
{
	kdebugf();
	
	QFile log_file(config_file.readEntry("Firewall", "log_file", ggPath("firewall.log")));
				
	if (!log_file.exists())
	{
		log_file.open(IO_WriteOnly);
		QTextStream stream( &log_file );
		stream << tr("      DATA AND TIME      ::   UIN   :: MESSAGE\n") << "----------------------------------------------------\n";
		log_file.close();
	}
				
	log_file.open(IO_WriteOnly | IO_Append);
	QTextStream stream( &log_file );
	stream << QDateTime::currentDateTime(Qt::LocalTime).toString() << " :: " << u << " :: " << m << "\n";
	log_file.close();
	
	kdebugf2();
}

void Firewall::loadSecuredList()
{
	kdebugf();
	
	QString loaded_str = config_file.readEntry("Firewall", "secured_list");
	secured = QStringList::split(",", loaded_str);
	
	kdebugf2();
}

void Firewall::saveSecuredList()
{
	kdebugf();
	
	QStringList list_to_save = secured;

	config_file.writeEntry("Firewall", "secured_list", list_to_save.join(","));
	config_file.sync();
	
	kdebugf2();
}

bool Firewall::isSecured(QString id)
{
	return secured.findIndex(id) != -1;		// findIndex zwraca -1, jeli nie znalaz...
}


/**

GUI

**/


void Firewall::createGUI(void)
{
	kdebugf();

	ConfigDialog::addTab(QT_TRANSLATE_NOOP("@default", "Firewall"), dataPath("kadu/modules/data/firewall/firewall.png"));
	
	ConfigDialog::addVGroupBox("Firewall", "Firewall", QT_TRANSLATE_NOOP("@default", "Unknown chats protection"));
		ConfigDialog::addCheckBox("Firewall", "Unknown chats protection", QT_TRANSLATE_NOOP("@default", "Ignore conferences with all persons unknown"), "ignore_conferences", true);
		ConfigDialog::addCheckBox("Firewall", "Unknown chats protection", QT_TRANSLATE_NOOP("@default", "Protect against chats with unknown persons"), "chats", true, QT_TRANSLATE_NOOP("@default", "Module will ask the question typed below, if someone wants talk to you and you don't have him on your list."));

	ConfigDialog::addVGroupBox("Firewall", "Unknown chats protection", QT_TRANSLATE_NOOP("@default", "Automatic question"));
		ConfigDialog::addTextEdit("Firewall", "Automatic question", QT_TRANSLATE_NOOP("@default", "Message:"), "question", tr("This message has been generated AUTOMATICALLY!\n\nI'm a busy person and I don't have time for stupid chats. Find another person to chat with. If you REALLY want something from me, simple type \"I want something\" (capital doesn't matter)"), QT_TRANSLATE_NOOP("@default", "This message will be send to unknown person."));
		ConfigDialog::addLineEdit("Firewall", "Automatic question", QT_TRANSLATE_NOOP("@default", "Answer:"), "answer", tr("I want something"), QT_TRANSLATE_NOOP("@default", "Right answer for question above - you can use regexp."));


	ConfigDialog::addHGroupBox("Firewall", "Unknown chats protection", QT_TRANSLATE_NOOP("@default", "After right answer"));
		ConfigDialog::addCheckBox("Firewall", "After right answer", QT_TRANSLATE_NOOP("@default", "Send confirmation:"), "confirmation", true);
		ConfigDialog::addLineEdit("Firewall", "After right answer", "", "confirmation_text", tr("OK, now say hello, and introduce yourself ;-)"), "", "confirmation_text");

	ConfigDialog::addVGroupBox("Firewall", "Firewall", QT_TRANSLATE_NOOP("@default", "DoS attack"), 0, Expert);
		ConfigDialog::addHBox("Firewall", "DoS attack", "DoShbox1");
			ConfigDialog::addCheckBox("Firewall", "DoShbox1", QT_TRANSLATE_NOOP("@default", "Protect against flooding DoS attack"), "dos", true, QT_TRANSLATE_NOOP("@default", "Attack caused by many messages, sent in short time."));
			ConfigDialog::addSpinBox("Firewall", "DoShbox1", QT_TRANSLATE_NOOP("@default", "Min delay between two messages"), "dos_interval", 100, 15000, 100, 500);
		
		ConfigDialog::addHBox("Firewall", "DoS attack", "DoShbox2");
			ConfigDialog::addCheckBox("Firewall", "DoShbox2", QT_TRANSLATE_NOOP("@default", "Protect against emoticons DoS attack"), "dos_emoticons", true, QT_TRANSLATE_NOOP("@default", "Attack caused by many emoticons, sent in short time."));
			ConfigDialog::addSpinBox("Firewall", "DoShbox2", QT_TRANSLATE_NOOP("@default", "Max number of emoticons in one message"), "emoticons_max", 1, 100, 1, 15);
			ConfigDialog::addCheckBox("Firewall", "DoShbox2", QT_TRANSLATE_NOOP("@default", "Allow if known contact"), "emoticons_allow_known", false, QT_TRANSLATE_NOOP("@default", "People from your list can send you unlimited number of emoticons"));


	ConfigDialog::addVGroupBox("Firewall", "Firewall", QT_TRANSLATE_NOOP("@default", "Safe sending"));
	ConfigDialog::addCheckBox("Firewall", "Safe sending", QT_TRANSLATE_NOOP("@default", "Enable safe sending"), "safe_sending", false, QT_TRANSLATE_NOOP("@default", "You must confirm each message sent to these people"));
	ConfigDialog::addGrid("Firewall", "Safe sending" ,"listboxy",3);

		ConfigDialog::addGrid("Firewall", "listboxy", "listbox1", 1);
			ConfigDialog::addLabel("Firewall", "listbox1", QT_TRANSLATE_NOOP("@default", "All"));
			ConfigDialog::addListBox("Firewall", "listbox1","all");

		ConfigDialog::addGrid("Firewall", "listboxy", "listbox2", 1);
			ConfigDialog::addPushButton("Firewall", "listbox2", 0, "AddToNotifyList", 0, "forward");
			ConfigDialog::addPushButton("Firewall", "listbox2", 0, "RemoveFromNotifyList", 0, "back");

		ConfigDialog::addGrid("Firewall", "listboxy", "listbox3", 1);
			ConfigDialog::addLabel("Firewall", "listbox3", QT_TRANSLATE_NOOP("@default", "Secured"));
			ConfigDialog::addListBox("Firewall", "listbox3", "secured");

	ConfigDialog::addVGroupBox("Firewall", "Firewall", QT_TRANSLATE_NOOP("@default", "Notify"));
		ConfigDialog::addHBox("Firewall", "Notify", "hbox1");
			ConfigDialog::addCheckBox("Firewall", "hbox1", QT_TRANSLATE_NOOP("@default", "Show hint"), "show_hint", true);
			ConfigDialog::addColorButton("Firewall", "hbox1", QT_TRANSLATE_NOOP("@default", "Text color:"), "fg_color", QColor("navy"), 0, 0, Advanced);
		ConfigDialog::addHBox("Firewall", "Notify", "hbox2");
			ConfigDialog::addSpinBox("Firewall", "hbox2", QT_TRANSLATE_NOOP("@default", "Show hint for"), "hint_timeout", 1, 100, 1, 3, 0, 0, Expert);
			ConfigDialog::addColorButton("Firewall", "hbox2", QT_TRANSLATE_NOOP("@default", "Background color:"), "bg_color", QColor("lightblue"), 0, 0, Advanced);

			ConfigDialog::addLineEdit("Firewall", "Notify", QT_TRANSLATE_NOOP("@default", "Hint syntax"), "hint_syntax", tr("%u writes: %m"), tr("%u - uin, %m - message"), 0, Advanced);
		ConfigDialog::addCheckBox("Firewall", "Notify", QT_TRANSLATE_NOOP("@default", "Search for unknown person in directory and show window with his personal data."), "search", true);

	ConfigDialog::addHGroupBox("Firewall", "Firewall", QT_TRANSLATE_NOOP("@default", "Log"), 0, Advanced);
		ConfigDialog::addCheckBox("Firewall", "Log", QT_TRANSLATE_NOOP("@default", "Write log to file"), "write_log", true, "", "write_log");
		ConfigDialog::addLineEdit("Firewall", "Log", "", "log_file", ggPath("firewall.log"), "", "log_file");
	
	
	ConfigDialog::connectSlot("Firewall", "Send confirmation:", SIGNAL(toggled(bool)), this, SLOT(toggled_confirmation(bool)));
	ConfigDialog::connectSlot("Firewall", "Protect against chats with unknown persons", SIGNAL(toggled(bool)), this, SLOT(toggled_chats(bool)));
	ConfigDialog::connectSlot("Firewall", "Show hint", SIGNAL(toggled(bool)), this, SLOT(toggled_show_hint(bool)));
	ConfigDialog::connectSlot("Firewall", "Write log to file", SIGNAL(toggled(bool)), this, SLOT(toggled_log(bool)), "write_log");
	ConfigDialog::connectSlot("Firewall", "Protect against flooding DoS attack", SIGNAL(toggled(bool)), this, SLOT(toggled_flooding_DoS(bool)));
	ConfigDialog::connectSlot("Firewall", "Protect against emoticons DoS attack", SIGNAL(toggled(bool)), this, SLOT(toggled_emoticons_DoS(bool)));
	ConfigDialog::connectSlot("Firewall", "Enable safe sending", SIGNAL(toggled(bool)), this, SLOT(toggled_safe_sending(bool)));
	
	ConfigDialog::connectSlot("Firewall", 0, SIGNAL(clicked()), this, SLOT(_Right()), "forward");
	ConfigDialog::connectSlot("Firewall", 0, SIGNAL(clicked()), this, SLOT(_Left()), "back");
	ConfigDialog::connectSlot("Firewall", "all", SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(_Right()));
	ConfigDialog::connectSlot("Firewall", "secured", SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(_Left()));
	
	ConfigDialog::registerSlotOnCreateTab("Firewall", this, SLOT(onCreateTabFirewall()));
	ConfigDialog::registerSlotOnApplyTab("Firewall", this, SLOT(onApplyTabFirewall()));
	
	
	kdebugf2();
}

void Firewall::onCreateTabFirewall()
{
	kdebugf();
	
	QListBox *e_availusers= ConfigDialog::getListBox("Firewall", "all");
	QListBox *e_notifies= ConfigDialog::getListBox("Firewall", "secured");
	
	CONST_FOREACH(i, *userlist)
	{
		if ((*i).usesProtocol("Gadu") && !(*i).isAnonymous())
		{
			if (isSecured((*i).ID("Gadu")))
				e_notifies->insertItem((*i).altNick());
			else
				e_availusers->insertItem((*i).altNick());
		}
	}

	e_availusers->sort();
	e_notifies->sort();
	e_availusers->setSelectionMode(QListBox::Extended);
	e_notifies->setSelectionMode(QListBox::Extended);
	
	
	ConfigDialog::getSpinBox("Firewall", "Show hint for")->setSuffix(" s");
	toggled_chats(config_file.readBoolEntry("Firewall", "chats", true));
	toggled_confirmation(config_file.readBoolEntry("Firewall", "confirmation", true));
	toggled_show_hint(config_file.readBoolEntry("Firewall", "show_hint", true));
	toggled_log(config_file.readBoolEntry("Firewall", "write_log", true));
	toggled_flooding_DoS(config_file.readBoolEntry("Firewall", "dos", true));
	toggled_emoticons_DoS(config_file.readBoolEntry("Firewall", "dos_emoticons", true));
	toggled_safe_sending(config_file.readBoolEntry("Firewall", "safe_sending", false));
	
	kdebugf2();
}

void Firewall::onApplyTabFirewall()
{
	kdebugf();

	QListBox *e_notifies= ConfigDialog::getListBox("Firewall", "secured");
	pattern.setPattern(unicode2std(config_file.readEntry("Firewall", "answer", tr("I want something"))));

	secured.clear();

	for (unsigned int i = 0; i < e_notifies->count(); ++i)
	{
		secured.append(userlist->byAltNick(e_notifies->text(i)).ID("Gadu"));
	}
		
	saveSecuredList();
	
	kdebugf2();
}

void Firewall::toggled_chats(bool toggled)
{
	kdebugf();
	
	ConfigDialog::getVGroupBox("Firewall", "Automatic question")->setEnabled(toggled);
	ConfigDialog::getHGroupBox("Firewall", "After right answer")->setEnabled(toggled);
	
	kdebugf2();
}

void Firewall::toggled_confirmation(bool toggled)
{
	kdebugf();
	
	ConfigDialog::getLineEdit("Firewall", "", "confirmation_text")->setEnabled(toggled);
	
	kdebugf2();
}

void Firewall::toggled_show_hint(bool toggled)
{
	kdebugf();
	
	ConfigDialog::getColorButton("Firewall", "Text color:")->setEnabled(toggled);
	ConfigDialog::getSpinBox("Firewall", "Show hint for")->setEnabled(toggled);
	ConfigDialog::getColorButton("Firewall", "Background color:")->setEnabled(toggled);
	ConfigDialog::getLineEdit("Firewall", "Hint syntax")->setEnabled(toggled);
	
	kdebugf2();
}

void Firewall::toggled_log(bool toggled)
{
	kdebugf();
	
	ConfigDialog::getLineEdit("Firewall", "", "log_file")->setEnabled(toggled);
	
	kdebugf2();
}

void Firewall::toggled_flooding_DoS(bool toggled)
{
	kdebugf();
	
	ConfigDialog::getSpinBox("Firewall", "Min delay between two messages")->setEnabled(toggled);
	
	kdebugf2();
}

void Firewall::toggled_emoticons_DoS(bool toggled)
{
	kdebugf();
	
	ConfigDialog::getSpinBox("Firewall", "Max number of emoticons in one message")->setEnabled(toggled);
	ConfigDialog::getCheckBox("Firewall", "Allow if known contact")->setEnabled(toggled);
	
	kdebugf2();
}

void Firewall::toggled_safe_sending(bool toggled)
{
	kdebugf();
	
	ConfigDialog::getGrid("Firewall", "listboxy")->setEnabled(toggled);
	
	kdebugf2();
}

void Firewall::_Left(void)
{
	kdebugf();
	QListBox *e_availusers= ConfigDialog::getListBox("Firewall", "all");
	QListBox *e_notifies= ConfigDialog::getListBox("Firewall", "secured");
	QStringList tomove;
	unsigned int i, count = e_notifies->count();

	for (i = 0; i < count; ++i)
		if (e_notifies->isSelected(i))
			tomove += e_notifies->text(i);

	CONST_FOREACH(elem, tomove)
	{
		e_availusers->insertItem(*elem);
		e_notifies->removeItem(e_notifies->index(e_notifies->findItem(*elem)));
	}

	e_availusers->sort();
	kdebugf2();
}

void Firewall::_Right(void)
{
	kdebugf();
	QListBox *e_availusers= ConfigDialog::getListBox("Firewall", "all");
	QListBox *e_notifies= ConfigDialog::getListBox("Firewall", "secured");
	QStringList tomove;
	unsigned int i, count = e_availusers->count();

	for(i = 0; i < count; ++i)
		if (e_availusers->isSelected(i))
			tomove += e_availusers->text(i);

	CONST_FOREACH(elem, tomove)
	{
		e_notifies->insertItem(*elem);
		e_availusers->removeItem(e_availusers->index(e_availusers->findItem(*elem)));
	}

	e_notifies->sort();
	kdebugf2();
}

void Firewall::destroyGUI(void)
{
	kdebugf();
	
	ConfigDialog::unregisterSlotOnCreateTab("Firewall", this, SLOT(onCreateTabFirewall()));
	ConfigDialog::unregisterSlotOnApplyTab("Firewall", this, SLOT(onApplyTabFirewall()));
	
	
	ConfigDialog::disconnectSlot("Firewall", 0, SIGNAL(clicked()), this, SLOT(_Right()), "forward");
	ConfigDialog::disconnectSlot("Firewall", 0, SIGNAL(clicked()), this, SLOT(_Left()), "back");
	ConfigDialog::disconnectSlot("Firewall", "all", SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(_Right()));
	ConfigDialog::disconnectSlot("Firewall", "secured", SIGNAL(doubleClicked(QListBoxItem *)), this, SLOT(_Left()));
	
	ConfigDialog::disconnectSlot("Firewall", "Write log to file", SIGNAL(toggled(bool)), this, SLOT(toggled_log(bool)), "write_log");
	ConfigDialog::disconnectSlot("Firewall", "Show hint", SIGNAL(toggled(bool)), this, SLOT(toggled_show_hint(bool)));
	ConfigDialog::disconnectSlot("Firewall", "Send confirmation:", SIGNAL(toggled(bool)), this, SLOT(toggled_confirmation(bool)));
	
	ConfigDialog::removeControl("Firewall", "", "log_file");
	ConfigDialog::removeControl("Firewall", "Write log to file", "write_log");
	ConfigDialog::removeControl("Firewall", "Log");
	ConfigDialog::removeControl("Firewall", "Hint syntax");
	ConfigDialog::removeControl("Firewall", "Search for unknown person in directory and show window with his personal data.");
	ConfigDialog::removeControl("Firewall", "Background color:");
	ConfigDialog::removeControl("Firewall", "Show hint for");
	ConfigDialog::removeControl("Firewall", "hbox2");
	ConfigDialog::removeControl("Firewall", "Text color:");
	ConfigDialog::removeControl("Firewall", "Show hint");
	ConfigDialog::removeControl("Firewall", "hbox1");
	ConfigDialog::removeControl("Firewall", "Notify");
	ConfigDialog::removeControl("Firewall", "secured");
	ConfigDialog::removeControl("Firewall", "Secured");
	ConfigDialog::removeControl("Firewall", "listbox3");
	ConfigDialog::removeControl("Firewall", 0, "back");
	ConfigDialog::removeControl("Firewall", 0, "forward");
	ConfigDialog::removeControl("Firewall", "listbox2");
	ConfigDialog::removeControl("Firewall", "all");
	ConfigDialog::removeControl("Firewall", "All");
	ConfigDialog::removeControl("Firewall", "listbox1");
	ConfigDialog::removeControl("Firewall", "listboxy");
	ConfigDialog::removeControl("Firewall", "Enable safe sending");
	ConfigDialog::removeControl("Firewall", "Safe sending");
	ConfigDialog::removeControl("Firewall", "Allow if known contact");
	ConfigDialog::removeControl("Firewall", "Max number of emoticons in one message");
	ConfigDialog::removeControl("Firewall", "Protect against emoticons DoS attack");
	ConfigDialog::removeControl("Firewall", "DoShbox2");
	ConfigDialog::removeControl("Firewall", "Min delay between two messages");
	ConfigDialog::removeControl("Firewall", "Protect against flooding DoS attack");
	ConfigDialog::removeControl("Firewall", "DoShbox1");
	ConfigDialog::removeControl("Firewall", "DoS attack");
	ConfigDialog::removeControl("Firewall", "", "confirmation_text");
	ConfigDialog::removeControl("Firewall", "Send confirmation:");
	ConfigDialog::removeControl("Firewall", "After right answer");
	ConfigDialog::removeControl("Firewall", "Answer:");
	ConfigDialog::removeControl("Firewall", "Message:");
	ConfigDialog::removeControl("Firewall", "Automatic question");
	ConfigDialog::removeControl("Firewall", "Protect against chats with unknown persons");
	ConfigDialog::removeControl("Firewall", "Ignore conferences with all persons unknown");
	ConfigDialog::removeControl("Firewall", "Unknown chats protection");
	
	ConfigDialog::removeTab("Firewall");
	
	kdebugf2();
	
}
