/***************************************************************************
 *   Weather module for Kadu communicator                                  *
 *   2004 Micha Maek (bysk)                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "textprogress.h"

#include <qtimer.h>

const int TextProgress::dotCount_ = 5;

TextProgress::TextProgress( QWidget* parent, const QString& text )
:
	QLabel( parent ),
	counter_(0)
{
	timer_ = new QTimer( this );
	connect( timer_, SIGNAL(timeout()), this, SLOT(timeout()) );
	
	setText( text );
	
	timer_->start( 250 );
}


TextProgress::~TextProgress()
{
}

void TextProgress::setText( const QString& text )
{
	counter_ = 0;
	text_ = text;
	setProgressText();
}

void TextProgress::setProgressText()
{
	if( !text_.isEmpty() )
	{
		QString text = " " + text_ + " ";
		for( int i=0; i<counter_; ++i )
		{
			text = "." + text + ".";
		}
		
		QLabel::setText( text );
	}
}

void TextProgress::clearProgressText()
{
	text_ = QString::null;
	clear();
}

void TextProgress::timeout()
{
	if( counter_ >= dotCount_ )
		counter_ = 0;
	else
		++counter_;
	
	setProgressText();
}
